/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.attachment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.github.litermc.vschunkloader.Constants;
import com.github.litermc.vschunkloader.VSCApi;
import com.github.litermc.vschunkloader.platform.PlatformHelper;
import com.github.litermc.vschunkloader.util.ChunkLoaderManager;
import com.github.litermc.vschunkloader.util.ChunkSensor;
import com.github.litermc.vschunkloader.util.TaskUtil;
import com.github.litermc.vtil.util.LevelUtil;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.server.MinecraftServer;
import org.joml.AxisAngle4d;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerShipTransformProvider;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.physics_api.PoseVel;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class ChunkSensorAttachment
implements ShipForcesInducer {
    private static final double DT = 0.016666666666666666;
    private final ServerShipWorldCore world = VSGameUtilsKt.getShipObjectWorld((MinecraftServer)PlatformHelper.get().getCurrentServer());
    private volatile LoadedServerShip ship = null;
    @JsonProperty
    private volatile boolean freezed = false;
    private volatile Vector3dc velocity = null;
    private volatile Vector3dc omega = null;

    private ChunkSensorAttachment() {
    }

    public static ChunkSensorAttachment get(ServerShip ship) {
        ChunkSensorAttachment attachment = (ChunkSensorAttachment)ship.getAttachment(ChunkSensorAttachment.class);
        if (attachment != null) {
            return attachment;
        }
        ChunkSensorAttachment newAttachment = new ChunkSensorAttachment();
        ship.saveAttachment(ChunkSensorAttachment.class, (Object)newAttachment);
        return newAttachment;
    }

    @JsonGetter(value="velocity")
    public double[] getVelocity() {
        double[] dArray;
        if (this.freezed) {
            double[] dArray2 = new double[3];
            dArray2[0] = this.velocity.x();
            dArray2[1] = this.velocity.y();
            dArray = dArray2;
            dArray2[2] = this.velocity.z();
        } else {
            dArray = null;
        }
        return dArray;
    }

    @JsonSetter(value="velocity")
    public void setVelocity(double[] velocity) {
        if (velocity == null || velocity.length != 3) {
            this.velocity = null;
            return;
        }
        this.velocity = new Vector3d(velocity[0], velocity[1], velocity[2]);
    }

    @JsonGetter(value="omega")
    public double[] getOmega() {
        double[] dArray;
        if (this.freezed) {
            double[] dArray2 = new double[3];
            dArray2[0] = this.omega.x();
            dArray2[1] = this.omega.y();
            dArray = dArray2;
            dArray2[2] = this.omega.z();
        } else {
            dArray = null;
        }
        return dArray;
    }

    @JsonSetter(value="omega")
    public void setOmega(double[] omega) {
        if (omega == null || omega.length != 3) {
            this.omega = null;
            return;
        }
        this.omega = new Vector3d(omega[0], omega[1], omega[2]);
    }

    public void serverTick(final LoadedServerShip ship) {
        this.ship = ship;
        if (!this.freezed) {
            return;
        }
        long shipId = ship.getId();
        if (!ship.isStatic()) {
            this.freezed = false;
            this.velocity = null;
            this.omega = null;
            Constants.LOG.warn("Ship " + shipId + " had been manually unfreezed");
            return;
        }
        AABBic shipBox = ship.getShipAABB();
        if (shipBox == null) {
            return;
        }
        class_3218 level = LevelUtil.getLevel((String)ship.getChunkClaimDimension());
        if (level == null) {
            return;
        }
        final Vector3dc velocity = this.velocity;
        final Vector3dc omega = this.omega;
        if (this.isShipMovingToUnloads(level, shipBox, ship.getTransform(), velocity, omega)) {
            return;
        }
        Constants.LOG.debug("Ship {} is unfreezing! position={} velocity={} omega={}", new Object[]{shipId, ship.getTransform().getPositionInWorld(), velocity, omega});
        this.freezed = false;
        this.velocity = null;
        this.omega = null;
        ship.setStatic(false);
        final ServerShipTransformProvider lastProvider = ship.getTransformProvider();
        ship.setTransformProvider(new ServerShipTransformProvider(){

            public ServerShipTransformProvider.NextTransformAndVelocityData provideNextTransformAndVelocity(ShipTransform transform, ShipTransform nextTransform) {
                ship.setTransformProvider(lastProvider);
                return new ServerShipTransformProvider.NextTransformAndVelocityData(nextTransform, velocity, omega);
            }
        });
    }

    public void applyForces(PhysShip phyShip) {
        AABBic shipBox;
        LoadedServerShip ship = this.ship;
        if (ship == null) {
            return;
        }
        if (phyShip.isStatic() || ship.isStatic()) {
            return;
        }
        long shipId = phyShip.getId();
        if (this.freezed) {
            this.freezed = false;
            this.velocity = null;
            this.omega = null;
            Constants.LOG.warn("Ship " + shipId + " had been manually unfreezed.");
        }
        if ((shipBox = ship.getShipAABB()) == null) {
            return;
        }
        class_3218 level = LevelUtil.getLevel((String)ship.getChunkClaimDimension());
        if (level == null) {
            return;
        }
        if (!VSCApi.canFreezeShipForChunkLoad((ServerShip)ship)) {
            return;
        }
        PoseVel poseVel = ((PhysShipImpl)phyShip).getPoseVel();
        Vector3dc velocity = poseVel.getVel();
        Vector3dc omega = poseVel.getOmega();
        if (!this.isShipMovingToUnloads(level, shipBox, phyShip.getTransform(), velocity, omega)) {
            return;
        }
        Constants.LOG.debug("Ship {} is freezing! position={} velocity={} omega={}", new Object[]{shipId, phyShip.getTransform().getPositionInWorld(), velocity, omega});
        phyShip.setStatic(true);
        ship.setStatic(true);
        this.freezed = true;
        this.velocity = velocity;
        this.omega = omega;
    }

    private boolean isShipMovingToUnloads(class_3218 level, AABBic shipBox, ShipTransform transform, Vector3dc velocity, Vector3dc omega) {
        Matrix4dc oldTransform = transform.getShipToWorld();
        Matrix4d newTransform = new Matrix4d();
        double omegaSqr = omega.lengthSquared();
        if (omegaSqr > 1.0E-8) {
            Vector3dc pos = transform.getPositionInWorld();
            newTransform.rotationAround((Quaterniondc)new Quaterniond(new AxisAngle4d(Math.sqrt(omegaSqr) * 0.016666666666666666, (Vector3dc)omega.normalize(new Vector3d()))), pos.x(), pos.y(), pos.z()).mul(oldTransform);
        } else {
            newTransform.set(oldTransform);
        }
        newTransform.translate((Vector3dc)velocity.mul(0.016666666666666666, new Vector3d()));
        AABBd shipBoxd = new AABBd((double)shipBox.minX(), (double)shipBox.minY(), (double)shipBox.minZ(), (double)shipBox.maxX(), (double)shipBox.maxY(), (double)shipBox.maxZ());
        AABBd worldBox = shipBoxd.transform(oldTransform, new AABBd());
        AABBd newWorldBox = shipBoxd.transform((Matrix4dc)newTransform, new AABBd());
        int minX = Math.min(class_4076.method_42615((double)worldBox.minX), class_4076.method_42615((double)newWorldBox.minX)) - 1;
        int maxX = Math.max(class_4076.method_42615((double)worldBox.maxX), class_4076.method_42615((double)newWorldBox.maxX)) + 1;
        int minZ = Math.min(class_4076.method_42615((double)worldBox.minZ), class_4076.method_42615((double)newWorldBox.minZ)) - 1;
        int maxZ = Math.max(class_4076.method_42615((double)worldBox.maxZ), class_4076.method_42615((double)newWorldBox.maxZ)) + 1;
        ChunkSensor sensor = ChunkSensor.get(level);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (sensor.isChunkLoaded(x, z)) continue;
                TaskUtil.queueTickEnd(() -> ChunkLoaderManager.get(level).pingChunks(minX, maxX, minZ, maxZ));
                return true;
            }
        }
        return false;
    }
}

