/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.attachment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.github.litermc.vschunkloader.platform.PlatformHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import org.valkyrienskies.core.api.ships.ServerShip;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public final class ForceLoadAttachment {
    private Set<class_2960> forceLoadTokens = new HashSet<class_2960>();

    public static ForceLoadAttachment get(ServerShip ship) {
        ForceLoadAttachment attachment = (ForceLoadAttachment)ship.getAttachment(ForceLoadAttachment.class);
        if (attachment == null) {
            attachment = new ForceLoadAttachment();
            ship.saveAttachment(ForceLoadAttachment.class, (Object)attachment);
        }
        return attachment;
    }

    @JsonGetter(value="forceLoadTokens")
    private Collection<String> getForceLoadTokens() {
        return this.forceLoadTokens.stream().map(class_2960::toString).toList();
    }

    @JsonSetter(value="forceLoadTokens")
    private void setForceLoadTokens(Collection<String> tokens) {
        this.forceLoadTokens.clear();
        tokens.stream().map(class_2960::new).forEach(this.forceLoadTokens::add);
    }

    public boolean isForceLoaded() {
        PlatformHelper platform = PlatformHelper.get();
        for (class_2960 id : this.forceLoadTokens) {
            if (!platform.isModLoaded(id.method_12836())) continue;
            return true;
        }
        return false;
    }

    public boolean isForceLoadedBy(class_2960 token) {
        return this.forceLoadTokens.contains(token);
    }

    public void addForceLoad(class_2960 token) {
        this.forceLoadTokens.add(token);
    }

    public void removeForceLoad(class_2960 token) {
        this.forceLoadTokens.remove(token);
    }

    public void removeAllForceLoadTokens() {
        this.forceLoadTokens.clear();
    }

    public Set<class_2960> getAllForceLoadTokens() {
        return Collections.unmodifiableSet(this.forceLoadTokens);
    }
}

