/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block;

import com.github.litermc.vschunkloader.VSCRegistry;
import com.github.litermc.vschunkloader.config.Config;
import com.github.litermc.vschunkloader.util.ChunkLoaderManager;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class ChunkLoaderBlockEntity
extends class_2586 {
    private int activating = 0;
    private boolean wasActivated = true;
    private int energyStored = 0;
    Object energyStorage = null;

    protected ChunkLoaderBlockEntity(class_2591<? extends ChunkLoaderBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public ChunkLoaderBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends ChunkLoaderBlockEntity>)((class_2591)VSCRegistry.BlockEntities.CHUNK_LOADER.get()), pos, state);
    }

    public boolean isRunning() {
        return this.activating > 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int avaliable = this.getMaxEnergyStored() - this.energyStored;
        if (avaliable <= 0) {
            return 0;
        }
        int received = Math.min(avaliable, maxReceive);
        if (!simulate) {
            this.energyStored += received;
        }
        return received;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getEnergyConsumeRate() {
        return Config.chunkLoaderEnergyConsumeRate;
    }

    public int getMaxEnergyStored() {
        return this.getEnergyConsumeRate() * 4;
    }

    public void method_11014(class_2487 data) {
        super.method_11014(data);
        this.activating = data.method_10550("Activating");
        this.energyStored = data.method_10550("EnergyStored");
    }

    protected void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10569("Activating", this.activating);
        data.method_10569("EnergyStored", this.energyStored);
    }

    public void serverTick() {
        int newEnergy;
        class_3218 level = (class_3218)this.method_10997();
        if (level.method_8321(this.method_11016()) != this) {
            this.method_11012();
            return;
        }
        if (this.activating <= 1 && (newEnergy = this.energyStored - this.getEnergyConsumeRate()) >= 0) {
            this.activating += 20;
            this.energyStored = newEnergy;
            this.method_5431();
            this.wasActivated = true;
            this.onRefresh();
        }
        if (!this.isRunning()) {
            if (this.wasActivated) {
                this.wasActivated = false;
                this.onDeactivate();
                this.method_5431();
            }
            return;
        }
        --this.activating;
        this.method_5431();
    }

    public void onRefresh() {
        class_3218 level = (class_3218)this.method_10997();
        ChunkLoaderManager.get(level).refreshChunkLoader(this.method_11016());
    }

    public void onDeactivate() {
        class_3218 level = (class_3218)this.method_10997();
        ChunkLoaderManager.get(level).deactivateChunkLoader(this.method_11016());
    }
}

