/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block;

import com.github.litermc.vschunkloader.VSCRegistry;
import com.github.litermc.vschunkloader.block.ChunkLoaderBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import team.reborn.energy.api.EnergyStorage;

public class ChunkLoaderBlockEntityCapabilityProvider {
    public static void register() {
        EnergyStorage.SIDED.registerForBlockEntity(ChunkLoaderBlockEntityCapabilityProvider::energyStorageGetter, (class_2591)VSCRegistry.BlockEntities.CHUNK_LOADER.get());
        EnergyStorage.SIDED.registerForBlockEntity(ChunkLoaderBlockEntityCapabilityProvider::energyStorageGetter, (class_2591)VSCRegistry.BlockEntities.CHUNK_LOADER_WEAK.get());
    }

    private static EnergyStorage energyStorageGetter(ChunkLoaderBlockEntity be, class_2350 side) {
        if (be.energyStorage == null) {
            be.energyStorage = new EnergyStorageImpl(be);
        }
        return (EnergyStorage)be.energyStorage;
    }

    private static final class EnergyStorageImpl
    implements EnergyStorage {
        private final ChunkLoaderBlockEntity be;

        private EnergyStorageImpl(ChunkLoaderBlockEntity be) {
            this.be = be;
        }

        public boolean supportsInsertion() {
            return true;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            int maxReceive = maxAmount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxAmount;
            int recieved = this.be.receiveEnergy(maxReceive, true);
            if (recieved > 0) {
                transaction.addCloseCallback((transactionCtx, result) -> {
                    if (result.wasCommitted()) {
                        this.be.receiveEnergy(maxReceive, false);
                    }
                });
            }
            return recieved;
        }

        public boolean supportsExtraction() {
            return false;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long getAmount() {
            return this.be.getEnergyStored();
        }

        public long getCapacity() {
            return this.be.getMaxEnergyStored();
        }
    }
}

