/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block.ammo;

import com.github.litermc.vschunkloader.VSCRegistry;
import com.github.litermc.vschunkloader.attachment.AmmoShipAttachment;
import com.github.litermc.vschunkloader.block.ammo.AmmoAssemblerBlock;
import com.github.litermc.vschunkloader.block.ammo.AmmoAssemblerPeripheral;
import com.github.litermc.vschunkloader.block.ammo.AssembleResult;
import com.github.litermc.vschunkloader.config.Config;
import com.github.litermc.vtil.block.AbstractAssemblerBlockEntity;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5552;
import net.minecraft.class_7923;
import org.joml.primitives.AABBi;
import org.valkyrienskies.core.api.ships.ServerShip;

public class AmmoAssemblerBlockEntity
extends AbstractAssemblerBlockEntity {
    private static final int MAX_DIM = 128;
    private static final String AMMO_DEFAULT_SLUG_PREFIX = "+assembled+ammo+";
    private boolean triggering = false;
    private volatile AssembleResult assembleResult = AssembleResult.SUCCESS;
    private int energyStored = 0;
    private int energyConsumption = Config.ammoAssembleEnergy;
    private final AABBi box = new AABBi();
    private Runnable assembleFinishCallback = null;
    Object energyStorage = null;
    Object peripheral = null;

    public AmmoAssemblerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)VSCRegistry.BlockEntities.AMMO_ASSEMBLER.get(), pos, state);
    }

    public boolean isAssembling() {
        return this.assembleResult.isWorking();
    }

    public boolean isAssembleSuccessed() {
        return this.assembleResult.isSuccess();
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }

    public AssembleResult getAssembleResult() {
        return this.assembleResult;
    }

    private void setAssembleResult(AssembleResult result) {
        if (this.assembleResult == result) {
            return;
        }
        this.assembleResult = result;
        this.method_5431();
        this.method_10997().method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(AmmoAssemblerBlock.LED, (Comparable)((Object)result.getLED())), 3);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int avaliable = this.getMaxEnergyStored() - this.energyStored;
        if (avaliable <= 0) {
            return 0;
        }
        int received = Math.min(Math.min(avaliable, maxReceive), (this.getMaxEnergyStored() + 99) / 100);
        if (!simulate) {
            this.energyStored += received;
        }
        return received;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.getEnergyConsumption();
    }

    public void method_11014(class_2487 data) {
        this.energyStored = data.method_10550("EnergyStored");
        this.triggering = data.method_10577("Powered");
        try {
            this.assembleResult = AssembleResult.valueOf(data.method_10558("AssembleResult"));
        }
        catch (IllegalArgumentException e) {
            this.assembleResult = AssembleResult.SUCCESS;
        }
    }

    public void method_11007(class_2487 data) {
        data.method_10569("EnergyStored", this.energyStored);
        data.method_10556("Powered", this.triggering);
        this.saveShared(data);
    }

    public void saveShared(class_2487 data) {
        data.method_10582("AssembleResult", this.assembleResult.toString());
    }

    public class_2487 method_16887() {
        class_2487 data = super.method_16887();
        this.saveShared(data);
        return data;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void neighborChanged(class_2248 neighbor, class_2338 neighborPos, boolean moving) {
        class_1937 level = this.method_10997();
        class_2338 pos = this.method_11016();
        boolean shouldTrigger = class_2350.method_42013().filter(dir -> dir != this.method_11010().method_11654((class_2769)class_2318.field_10927)).anyMatch(dir -> level.method_49808(pos.method_10093(dir), dir) > 0);
        if (this.triggering == shouldTrigger) {
            return;
        }
        this.triggering = shouldTrigger;
        if (shouldTrigger) {
            this.startAssemble(null);
        }
    }

    Object createPeripheral() {
        AmmoAssemblerPeripheral peripheral = new AmmoAssemblerPeripheral(this);
        this.assembleFinishCallback = peripheral::onAssembleFinish;
        return peripheral;
    }

    public boolean startAssemble(String slug) {
        if (this.isAssembling()) {
            return false;
        }
        if (this.energyStored < this.energyConsumption) {
            this.finishAssemble(AssembleResult.NO_ENERGY);
            return true;
        }
        return super.startAssemble(slug);
    }

    protected void setAssembling(boolean assembling) {
        super.setAssembling(assembling);
        if (assembling) {
            this.setAssembleResult(AssembleResult.WORKING);
        }
    }

    protected void finishAssemble(AssembleResult result) {
        this.setAssembleResult(result);
        this.finishAssemble();
    }

    protected void finishAssemble() {
        super.finishAssemble();
        if (this.assembleFinishCallback != null) {
            this.assembleFinishCallback.run();
        }
    }

    protected void finishAssembleAsSuccess() {
        this.finishAssemble(AssembleResult.SUCCESS);
    }

    protected void finishAssembleAsAssembleSelf() {
        this.finishAssemble(AssembleResult.ASSEMBLING_SELF);
    }

    protected void finishAssembleAsTooManyBlocks() {
        this.finishAssemble(AssembleResult.TOO_MANY_BLOCKS);
    }

    protected void finishAssembleAsNoBlockToAssemble() {
        this.finishAssemble(AssembleResult.NO_BLOCK);
    }

    protected void finishAssembleAsConflicts() {
        this.finishAssemble(AssembleResult.OTHER_ASSEMBLING);
    }

    protected void addAssemblingBlock(class_2338 pos) {
        class_1937 level = this.method_10997();
        if (!level.method_33598(pos.method_10263(), pos.method_10260())) {
            this.finishAssemble(AssembleResult.CHUNK_UNLOADED);
            return;
        }
        class_2680 block = level.method_8320(pos);
        if (block.method_26215()) {
            return;
        }
        if (!this.canAssembleBlock(block)) {
            this.finishAssemble(AssembleResult.UNABLE_ASSEMBLE);
            return;
        }
        this.box.union(pos.method_10263(), pos.method_10264(), pos.method_10260());
        if (this.box.lengthX() > 128 || this.box.lengthY() > 128 || this.box.lengthZ() > 128) {
            this.finishAssemble(AssembleResult.SIZE_OVERFLOW);
            return;
        }
        super.addAssemblingBlock(pos);
    }

    protected boolean canAssembleBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block instanceof class_5552) {
            return false;
        }
        class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
        return !Config.ammoAssembleBlacklist.contains(blockId);
    }

    protected void onAssembleSuccess(ServerShip ship) {
        if (ship.getSlug() == null) {
            ship.setSlug(AMMO_DEFAULT_SLUG_PREFIX + ship.getId());
        }
        AmmoShipAttachment.create(ship);
    }

    private static Stream<class_2338> streamBlocksInAABB(class_238 box) {
        int minX = (int)Math.round(box.field_1323);
        int maxX = (int)Math.round(box.field_1320);
        int minY = (int)Math.round(box.field_1322);
        int maxY = (int)Math.round(box.field_1325);
        int minZ = (int)Math.round(box.field_1321);
        int maxZ = (int)Math.round(box.field_1324);
        int widthX = maxX - minX;
        int widthY = maxY - minY;
        int widthZ = maxZ - minZ;
        return IntStream.range(0, widthX * widthY * widthZ).mapToObj(i -> {
            int x = i % widthX + minX;
            int z = (i /= widthX) % widthZ + minZ;
            int y = (i /= widthZ) + minY;
            return new class_2338(x, y, z);
        });
    }
}

