/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block.ammo;

import com.github.litermc.vschunkloader.VSCRegistry;
import com.github.litermc.vschunkloader.block.ammo.AmmoAssemblerBlockEntity;
import com.github.litermc.vschunkloader.compat.CompatMods;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import team.reborn.energy.api.EnergyStorage;

public class AmmoAssemblerBlockEntityCapabilityProvider {
    public static void register() {
        EnergyStorage.SIDED.registerForBlockEntity(AmmoAssemblerBlockEntityCapabilityProvider::energyStorageGetter, (class_2591)VSCRegistry.BlockEntities.AMMO_ASSEMBLER.get());
        if (CompatMods.COMPUTERCRAFT.isLoaded()) {
            PeripheralLookup.get().registerForBlockEntity(AmmoAssemblerBlockEntityCapabilityProvider::peripheralGetter, (class_2591)VSCRegistry.BlockEntities.AMMO_ASSEMBLER.get());
        }
    }

    private static EnergyStorage energyStorageGetter(AmmoAssemblerBlockEntity be, class_2350 side) {
        if (be.energyStorage == null) {
            be.energyStorage = new EnergyStorageImpl(be);
        }
        return (EnergyStorage)be.energyStorage;
    }

    private static <T> T peripheralGetter(AmmoAssemblerBlockEntity be, class_2350 side) {
        if (be.peripheral == null) {
            be.peripheral = be.createPeripheral();
        }
        return (T)be.peripheral;
    }

    private static final class EnergyStorageImpl
    implements EnergyStorage {
        private final AmmoAssemblerBlockEntity be;

        private EnergyStorageImpl(AmmoAssemblerBlockEntity be) {
            this.be = be;
        }

        public boolean supportsInsertion() {
            return true;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            int maxReceive = maxAmount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxAmount;
            int recieved = this.be.receiveEnergy(maxReceive, true);
            if (recieved > 0) {
                transaction.addCloseCallback((transactionCtx, result) -> {
                    if (result.wasCommitted()) {
                        this.be.receiveEnergy(maxReceive, false);
                    }
                });
            }
            return recieved;
        }

        public boolean supportsExtraction() {
            return false;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long getAmount() {
            return this.be.getEnergyStored();
        }

        public long getCapacity() {
            return this.be.getMaxEnergyStored();
        }
    }
}

