/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block.ammo;

import com.github.litermc.vschunkloader.block.ammo.AmmoAssemblerBlockEntity;
import com.github.litermc.vschunkloader.block.ammo.AssembleResult;
import com.github.litermc.vschunkloader.util.TaskUtil;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class AmmoAssemblerPeripheral
implements IPeripheral {
    public static final String ASSEMBLE_SUCCESS_EVENT_ID = "ammo_assemble_success";
    public static final String ASSEMBLE_FAILED_EVENT_ID = "ammo_assemble_failed";
    private static final Set<String> ADDTIONAL_TYPES = Set.of("energy_storage");
    private final AmmoAssemblerBlockEntity assembler;
    private final long peripheralId;
    private final AttachedComputerSet computers = new AttachedComputerSet();
    private final AtomicBoolean assembling = new AtomicBoolean();
    private final AssembleCallback assembleCallbackInstance = new AssembleCallback();

    public AmmoAssemblerPeripheral(AmmoAssemblerBlockEntity assembler) {
        this.assembler = assembler;
        this.peripheralId = assembler.method_11016().method_10063();
    }

    public Object getTarget() {
        return this.assembler;
    }

    public String getType() {
        return "vsc_ammo_assembler";
    }

    public Set<String> getAdditionalTypes() {
        return ADDTIONAL_TYPES;
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @LuaFunction
    public final boolean isAssembling() {
        return this.assembler.isAssembling();
    }

    @LuaFunction
    public final MethodResult assemble(Optional<String> slug) throws LuaException {
        String slugStr = slug.orElse(null);
        if (!this.assembling.compareAndSet(false, true)) {
            throw new LuaException("Already assembling");
        }
        TaskUtil.queueTickEnd(() -> {
            if (!this.assembler.startAssemble(slugStr)) {
                this.queueEvent(ASSEMBLE_FAILED_EVENT_ID, this.peripheralId, true, "Already assembling");
            }
        });
        return this.assembleCallbackInstance.pull;
    }

    void onAssembleFinish() {
        AssembleResult result = this.assembler.getAssembleResult();
        if (result.isSuccess()) {
            this.queueEvent(ASSEMBLE_SUCCESS_EVENT_ID, this.peripheralId);
            return;
        }
        this.queueEvent(ASSEMBLE_FAILED_EVENT_ID, this.peripheralId, false, result.getMessageId());
    }

    protected void queueEvent(String event, Object ... args) {
        this.computers.forEach(computer -> computer.queueEvent(event, args));
    }

    public boolean equals(IPeripheral other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AmmoAssemblerPeripheral) {
            AmmoAssemblerPeripheral otherAssembler = (AmmoAssemblerPeripheral)other;
            return this.assembler == otherAssembler.assembler;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public int getEnergy() {
        return this.assembler.getEnergyStored();
    }

    @LuaFunction(mainThread=true)
    public int getEnergyCapacity() {
        return this.assembler.getMaxEnergyStored();
    }

    private final class AssembleCallback
    implements ILuaCallback {
        private final MethodResult pull = MethodResult.pullEvent(null, (ILuaCallback)this);

        private AssembleCallback() {
        }

        public MethodResult resume(Object[] args) throws LuaException {
            Boolean isCritical;
            Object object;
            block10: {
                block9: {
                    Number peripheralId;
                    if (args.length < 2) {
                        return this.pull;
                    }
                    Object object2 = args[0];
                    if (!(object2 instanceof String)) {
                        return this.pull;
                    }
                    String event = (String)object2;
                    boolean successed = event.equals(AmmoAssemblerPeripheral.ASSEMBLE_SUCCESS_EVENT_ID);
                    if (!successed && !event.equals(AmmoAssemblerPeripheral.ASSEMBLE_FAILED_EVENT_ID)) {
                        return this.pull;
                    }
                    Object object3 = args[1];
                    if (!(object3 instanceof Number) || (peripheralId = (Number)object3).longValue() != AmmoAssemblerPeripheral.this.peripheralId) {
                        return this.pull;
                    }
                    if (successed) {
                        AmmoAssemblerPeripheral.this.assembling.set(false);
                        return MethodResult.of((Object)true);
                    }
                    if (args.length < 4 || !((object = args[2]) instanceof Boolean)) break block9;
                    isCritical = (Boolean)object;
                    object = args[3];
                    if (object instanceof String) break block10;
                }
                return this.pull;
            }
            String error = (String)object;
            if (isCritical.booleanValue()) {
                throw new LuaException(error);
            }
            AmmoAssemblerPeripheral.this.assembling.set(false);
            return MethodResult.of((Object[])new Object[]{false, error});
        }
    }
}

