/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.command;

import com.github.litermc.vschunkloader.VSCApi;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.command.ShipArgument;

public final class VSCCommands {
    public static final String ROOT_LITERAL = "vschunkloader";
    public static final class_2960 FORCELOAD_TOKEN = new class_2960("vschunkloader", "command");

    private VSCCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)ROOT_LITERAL).requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"forceload").then(class_2170.method_9244((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::forceLoad)))).then(class_2170.method_9247((String)"unforceload").then(class_2170.method_9244((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::unforceLoad)))).then(class_2170.method_9247((String)"unforceload-all").then(class_2170.method_9244((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::unforceLoadAll)))).then(class_2170.method_9247((String)"is-forceloaded").then(class_2170.method_9244((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::isForceLoaded)))).then(class_2170.method_9247((String)"query-forceload-tokens").then(class_2170.method_9244((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::queryForceLoadTokens))));
    }

    private static int forceLoad(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        int successCount = 0;
        for (Ship ship : ships) {
            if (!VSCApi.forceLoad(server, ship.getId(), FORCELOAD_TOKEN, true)) continue;
            ++successCount;
        }
        int finalSuccessCount = successCount;
        source.method_9226(() -> class_2561.method_43469((String)"command.vschunkloader.forceload", (Object[])new Object[]{finalSuccessCount}), true);
        return finalSuccessCount;
    }

    private static int unforceLoad(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        int successCount = 0;
        for (Ship ship : ships) {
            if (!VSCApi.forceLoad(server, ship.getId(), FORCELOAD_TOKEN, false)) continue;
            ++successCount;
        }
        int finalSuccessCount = successCount;
        source.method_9226(() -> class_2561.method_43469((String)"command.vschunkloader.unforceload", (Object[])new Object[]{finalSuccessCount}), true);
        return finalSuccessCount;
    }

    private static int unforceLoadAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        int successCount = 0;
        for (Ship ship : ships) {
            if (!VSCApi.clearForceLoadTokens(server, ship.getId())) continue;
            ++successCount;
        }
        int finalSuccessCount = successCount;
        source.method_9226(() -> class_2561.method_43469((String)"command.vschunkloader.unforceload", (Object[])new Object[]{finalSuccessCount}), true);
        return finalSuccessCount;
    }

    private static int isForceLoaded(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        int loadedCount = 0;
        for (Ship ship : ships) {
            if (!VSCApi.isForceLoaded(server, ship.getId())) continue;
            ++loadedCount;
        }
        int finalLoadedCount = loadedCount;
        source.method_9226(() -> finalLoadedCount == 0 ? class_2561.method_43471((String)"command.vschunkloader.is_forceloaded.none") : class_2561.method_43469((String)"command.vschunkloader.is_forceloaded", (Object[])new Object[]{finalLoadedCount}), false);
        return finalLoadedCount;
    }

    private static int queryForceLoadTokens(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        if (ships.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43471((String)"argument.valkyrienskies.ship.no_found"));
            return 0;
        }
        if (ships.size() > 1) {
            source.method_9213((class_2561)class_2561.method_43471((String)"argument.valkyrienskies.ship.multiple_found"));
            return 0;
        }
        Ship ship = (Ship)ships.iterator().next();
        Set<class_2960> tokens = VSCApi.getForceLoadTokens(server, ship.getId());
        if (tokens == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"argument.valkyrienskies.ship.no_found"));
            return 0;
        }
        int count = tokens.size();
        if (count == 0) {
            source.method_9226(() -> class_2561.method_43471((String)"command.vschunkloader.query_forceload.none"), false);
            return 1;
        }
        source.method_9226(() -> {
            class_5250 component = class_2561.method_43469((String)"command.vschunkloader.query_forceload.title", (Object[])new Object[]{count});
            tokens.stream().map(class_2960::toString).sorted().map(token -> class_2561.method_43470((String)"\n- ").method_27693(token)).forEach(arg_0 -> ((class_5250)component).method_10852(arg_0));
            return component;
        }, false);
        return count + 1;
    }
}

