/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.config;

import com.google.common.base.Splitter;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class ConfigFile {
    public static final String TRANSLATION_PREFIX = "gui.vschunkloader.config.";
    public static final Splitter SPLITTER = Splitter.on((char)'.');
    protected final Map<String, Entry> entries;

    protected ConfigFile(Map<String, Entry> entries) {
        this.entries = entries;
    }

    public final Stream<Entry> entries() {
        return this.entries.values().stream().flatMap(Entry::entries);
    }

    public final Entry getEntry(String path) {
        Iterator iterator = SPLITTER.split((CharSequence)path).iterator();
        Entry entry = this.entries.get(iterator.next());
        while (iterator.hasNext()) {
            if (!(entry instanceof Group)) {
                return null;
            }
            Group group = (Group)entry;
            entry = group.children.get(iterator.next());
        }
        return entry;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Entry {
        protected final String path;
        private final String translationKey;
        private final String comment;

        protected Entry(String path, String comment) {
            this.path = path;
            this.translationKey = ConfigFile.TRANSLATION_PREFIX + path;
            this.comment = comment;
        }

        public final String path() {
            return this.path;
        }

        public final String translationKey() {
            return this.translationKey;
        }

        public final String comment() {
            return this.comment;
        }

        abstract Stream<Entry> entries();
    }

    public static final class Group
    extends Entry {
        private final Map<String, Entry> children;

        public Group(String translationKey, String comment, Map<String, Entry> children) {
            super(translationKey, comment);
            this.children = children;
        }

        @Override
        Stream<Entry> entries() {
            return Stream.concat(Stream.of(this), this.children.values().stream().flatMap(Entry::entries));
        }
    }

    @FunctionalInterface
    public static interface ConfigListener {
        public void onConfigChanged(Path var1);
    }

    public static abstract class Builder {
        protected final Deque<RootGroup> groupStack = new ArrayDeque<RootGroup>();
        private String pendingComment;

        protected Builder() {
            this.groupStack.addLast(new RootGroup("", new HashMap<String, Entry>()));
        }

        protected final String getPath() {
            return this.groupStack.getLast().path();
        }

        protected final String getPath(String name) {
            String path = this.groupStack.getLast().path();
            return path.isEmpty() ? name : path + "." + name;
        }

        protected String getTranslation(String name) {
            StringBuilder key = new StringBuilder(ConfigFile.TRANSLATION_PREFIX);
            for (RootGroup group : this.groupStack) {
                key.append(group).append('.');
            }
            key.append(name);
            return key.toString();
        }

        @OverridingMethodsMustInvokeSuper
        public Builder comment(String comment) {
            if (this.pendingComment != null) {
                throw new IllegalStateException("Already have a comment");
            }
            this.pendingComment = comment;
            return this;
        }

        protected String takeComment() {
            String comment = this.pendingComment;
            if (comment == null) {
                throw new IllegalStateException("No comment specified");
            }
            this.pendingComment = null;
            return comment;
        }

        @OverridingMethodsMustInvokeSuper
        public void push(String name) {
            String path = this.getPath(name);
            HashMap<String, Entry> children = new HashMap<String, Entry>();
            this.groupStack.getLast().children().put(name, new Group(path, this.takeComment(), children));
            this.groupStack.addLast(new RootGroup(path, children));
        }

        @OverridingMethodsMustInvokeSuper
        public void pop() {
            this.groupStack.removeLast();
        }

        public abstract Builder worldRestart();

        public abstract <T> Value<T> define(String var1, T var2);

        public abstract Value<Boolean> define(String var1, boolean var2);

        public abstract Value<Integer> defineInRange(String var1, int var2, int var3, int var4);

        public abstract <T> Value<List<? extends T>> defineList(String var1, List<? extends T> var2, Predicate<Object> var3);

        public abstract <V extends Enum<V>> Value<V> defineEnum(String var1, V var2);

        public abstract ConfigFile build(ConfigListener var1);

        protected record RootGroup(String path, Map<String, Entry> children) {
        }
    }

    public static abstract class Value<T>
    extends Entry
    implements Supplier<T> {
        protected Value(String translationKey, String comment) {
            super(translationKey, comment);
        }

        @Override
        Stream<Entry> entries() {
            return Stream.of(this);
        }
    }
}

