/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.mixin;

import com.github.litermc.vschunkloader.platform.PlatformHelper;
import com.github.litermc.vschunkloader.util.AdvancedBitSet;
import com.github.litermc.vschunkloader.util.ChunkLoaderManager;
import com.github.litermc.vschunkloader.util.ChunkLoaderPlayerHolder;
import com.github.litermc.vschunkloader.util.ChunkSensor;
import com.github.litermc.vschunkloader.util.ChunkWatchTasksImpl;
import com.github.litermc.vschunkloader.util.TaskUtil;
import com.github.litermc.vtil.util.LevelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.chunks.ChunkUnwatchTask;
import org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTasks;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.physics_api.voxel.updates.IVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel.updates.VoxelShapeUpdateType;

@Mixin(value={ShipObjectServerWorld.class})
public abstract class MixinShipObjectServerWorld
implements ServerShipWorldCore {
    @Shadow(remap=false)
    @Final
    private ArrayList<ShipObjectServerWorld.LevelVoxelUpdates> voxelShapeUpdatesList;
    @Unique
    private final Set<IPlayer> disconnectedPlayers = new HashSet<IPlayer>();
    @Unique
    private final Map<Long, String> teleportedShips = new HashMap<Long, String>();
    @Unique
    private final SortedSet<ChunkUnwatchTask> pendingUnwatchTasks = new TreeSet<ChunkUnwatchTask>((a, b) -> Long.compare(a.getChunkPos(), b.getChunkPos()));
    @Unique
    private final Map<class_1923, AdvancedBitSet> loadedChunks = new HashMap<class_1923, AdvancedBitSet>();

    @ModifyVariable(method={"setPlayers"}, at=@At(value="HEAD"), remap=false)
    public Set<? extends IPlayer> setPlayers$head(Set<? extends IPlayer> players) {
        HashSet<? extends IPlayer> playerSet = new HashSet<IPlayer>(players);
        for (class_3218 level : PlatformHelper.get().getCurrentServer().method_3738()) {
            ChunkLoaderManager.get(level).streamChunkLoaders().map(ChunkLoaderPlayerHolder::getPlayerData).forEach(playerSet::add);
        }
        return Collections.unmodifiableSet(playerSet);
    }

    @Inject(method={"onDisconnect"}, at={@At(value="RETURN")}, remap=false)
    public void onDisconnect(IPlayer player, CallbackInfo ci) {
        this.disconnectedPlayers.add(player);
    }

    @Inject(method={"teleportShip"}, at={@At(value="HEAD")}, remap=false)
    public void teleportShip(ServerShip ship, ShipTeleportData teleportData, CallbackInfo ci) {
        long shipId = ship.getId();
        String dimId = teleportData.getNewDimension();
        String shipDim = ship.getChunkClaimDimension();
        if (dimId == null || dimId.equals(shipDim)) {
            return;
        }
        this.teleportedShips.put(ship.getId(), shipDim);
        ship.getActiveChunksSet().forEach((x, z) -> {
            HashSet<IPlayer> players = new HashSet<IPlayer>();
            this.getIPlayersWatchingShipChunk(x, z, shipDim).forEachRemaining(players::add);
            if (!players.isEmpty()) {
                this.pendingUnwatchTasks.add(new ChunkWatchTasksImpl.ChunkUnwatchTaskImpl(new class_1923(x, z), shipDim, players, true, ship));
            }
        });
        class_3218 level = LevelUtil.getLevel((String)dimId);
        if (level == null) {
            return;
        }
        Vector3dc pos = teleportData.getNewPos();
        ChunkLoaderPlayerHolder.createFixed(level, new class_243(pos.x(), pos.y(), pos.z()));
    }

    @Inject(method={"getChunkWatchTasks"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    public void getChunkWatchTasks(CallbackInfoReturnable<ChunkWatchTasks> cir) {
        if (this.disconnectedPlayers.isEmpty() && this.teleportedShips.isEmpty() && this.pendingUnwatchTasks.isEmpty()) {
            return;
        }
        ChunkWatchTasks oldWatchTasks = (ChunkWatchTasks)cir.getReturnValue();
        TreeSet<ChunkUnwatchTask> unwatchTasks = new TreeSet<ChunkUnwatchTask>((a, b) -> Long.compare(a.getChunkPos(), b.getChunkPos()));
        unwatchTasks.addAll(this.pendingUnwatchTasks);
        this.pendingUnwatchTasks.clear();
        if (!this.disconnectedPlayers.isEmpty()) {
            for (LoadedServerShip ship : this.getLoadedShips()) {
                String dim = ship.getChunkClaimDimension();
                ship.getActiveChunksSet().forEach((x, z) -> {
                    HashSet<IPlayer> players = new HashSet<IPlayer>(this.disconnectedPlayers);
                    HashSet oldPlayers = new HashSet();
                    this.getIPlayersWatchingShipChunk(x, z, dim).forEachRemaining(oldPlayers::add);
                    players.removeIf(Predicate.not(oldPlayers::contains));
                    boolean shouldUnload = players.size() == oldPlayers.size();
                    unwatchTasks.add(new ChunkWatchTasksImpl.ChunkUnwatchTaskImpl(new class_1923(x, z), dim, players, shouldUnload, (ServerShip)ship));
                });
            }
            this.disconnectedPlayers.clear();
        }
        if (!this.teleportedShips.isEmpty()) {
            HashSet teleportedShipSet = new HashSet(this.teleportedShips.size());
            this.teleportedShips.forEach((shipId, oldDim) -> {
                ServerShip newShip = (ServerShip)this.getAllShips().getById(shipId.longValue());
                if (newShip == null) {
                    return;
                }
                String newDim = newShip.getChunkClaimDimension();
                if (oldDim.equals(newDim)) {
                    return;
                }
            });
            this.teleportedShips.clear();
            oldWatchTasks.getUnwatchTasks().removeIf(t -> teleportedShipSet.contains(this.getAllShips().getByChunkPos(t.getChunkX(), t.getChunkZ(), t.getDimensionId())));
        }
        ChunkWatchTasks newWatchTasks = ChunkWatchTasksImpl.merge(oldWatchTasks, new ChunkWatchTasksImpl(null, unwatchTasks));
        cir.setReturnValue((Object)newWatchTasks);
    }

    @Inject(method={"clearNewUpdatedDeletedShipObjectsAndVoxelUpdates"}, at={@At(value="HEAD")}, remap=false)
    public void clearNewUpdatedDeletedShipObjectsAndVoxelUpdates(CallbackInfo ci) {
        for (ShipObjectServerWorld.LevelVoxelUpdates updates : this.voxelShapeUpdatesList) {
            class_3218 level = LevelUtil.getLevel((String)updates.getDimensionId());
            if (level == null) continue;
            ChunkSensor sensor = ChunkSensor.get(level);
            int maxSectionCount = level.method_32890();
            for (IVoxelShapeUpdate update : updates.getUpdates()) {
                AdvancedBitSet sections;
                boolean isload;
                int z;
                int x = update.getRegionX();
                if (VSGameUtilsKt.isChunkInShipyard((class_1937)level, (int)x, (int)(z = update.getRegionZ()))) continue;
                int y = level.method_31603(update.getRegionY());
                class_1923 pos = new class_1923(x, z);
                boolean bl = isload = update.getVoxelShapeUpdateType() != VoxelShapeUpdateType.DELETE;
                if (isload) {
                    sections = this.loadedChunks.computeIfAbsent(pos, pos0 -> new AdvancedBitSet(maxSectionCount));
                    if (!sections.set(y) || sections.count() != maxSectionCount) continue;
                    TaskUtil.queueTickStart(() -> sensor.onChunkLoaded(pos));
                    continue;
                }
                sections = this.loadedChunks.get(pos);
                if (sections == null) continue;
                if (sections.count() == maxSectionCount) {
                    TaskUtil.queueTickStart(() -> sensor.onChunkUnload(pos));
                }
                sections.clear(y);
                if (!sections.isEmpty()) continue;
                this.loadedChunks.remove(pos);
            }
        }
    }
}

