/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.util;

import com.github.litermc.vschunkloader.block.ChunkLoaderBlockEntity;
import com.github.litermc.vschunkloader.util.ChunkLoaderPlayerHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;

public final class ChunkLoaderManager
extends class_18 {
    private static final String DATA_NAME = "vschunkloader_ChunkLoaders";
    private static final String POSITIONS_KEY = "Positions";
    private final class_3218 level;
    private final Map<class_2338, ChunkLoaderPlayerHolder> chunkLoaders = new ConcurrentHashMap<class_2338, ChunkLoaderPlayerHolder>();
    private final Map<Long, ChunkLoaderPlayerHolder> forcedShips = new ConcurrentHashMap<Long, ChunkLoaderPlayerHolder>();
    private final Map<class_1923, ChunkLoaderPlayerHolder> pingingRegions = new ConcurrentHashMap<class_1923, ChunkLoaderPlayerHolder>();

    private ChunkLoaderManager(class_3218 level) {
        this.level = level;
    }

    public static ChunkLoaderManager get(class_3218 level) {
        return (ChunkLoaderManager)level.method_17983().method_17924(data -> ChunkLoaderManager.load(level, data), () -> new ChunkLoaderManager(level), DATA_NAME);
    }

    private static ChunkLoaderManager load(class_3218 level, class_2487 data) {
        ChunkLoaderManager manager = new ChunkLoaderManager(level);
        for (long posLong : data.method_10565(POSITIONS_KEY)) {
            class_2338 pos = class_2338.method_10092((long)posLong);
            manager.chunkLoaders.put(pos, manager.createChunkLoaderHolder(pos));
        }
        return manager;
    }

    public class_2487 method_75(class_2487 data) {
        data.method_10564(POSITIONS_KEY, this.chunkLoaders.keySet().stream().filter(pos -> {
            ChunkLoaderBlockEntity chunkLoader;
            class_2586 patt2078$temp = this.level.method_8321(pos);
            return patt2078$temp instanceof ChunkLoaderBlockEntity && (chunkLoader = (ChunkLoaderBlockEntity)patt2078$temp).isRunning();
        }).mapToLong(class_2338::method_10063).toArray());
        return data;
    }

    public Stream<ChunkLoaderPlayerHolder> streamChunkLoaders() {
        return Stream.of(this.chunkLoaders.values().stream(), this.forcedShips.values().stream(), this.pingingRegions.values().stream()).flatMap(Function.identity());
    }

    public void refreshChunkLoader(class_2338 pos) {
        ChunkLoaderPlayerHolder holder = this.chunkLoaders.compute(pos, (p, oldHolder) -> {
            boolean noOld;
            boolean bl = noOld = oldHolder == null;
            if (noOld || oldHolder.isDiscarding()) {
                if (noOld) {
                    this.method_80();
                } else {
                    oldHolder.setDiscardCallback(null);
                }
                oldHolder = this.createChunkLoaderHolder((class_2338)p);
            }
            return oldHolder;
        });
        holder.refresh();
    }

    public void deactivateChunkLoader(class_2338 pos) {
        ChunkLoaderPlayerHolder holder = this.chunkLoaders.get(pos);
        if (holder != null) {
            holder.discard();
        }
    }

    private ChunkLoaderPlayerHolder createChunkLoaderHolder(class_2338 pos) {
        ChunkLoaderPlayerHolder holder = ChunkLoaderPlayerHolder.createForBlock(this.level, pos);
        holder.setDiscardCallback(() -> {
            if (this.chunkLoaders.remove(pos, holder)) {
                this.method_80();
            }
        });
        return holder;
    }

    public void refreshForcedShip(ServerShip ship) {
        AABBic box = ship.getShipAABB();
        if (box == null) {
            return;
        }
        class_243 position = new class_243((double)((box.maxX() + box.minX()) / 2), (double)((box.maxY() + box.minY()) / 2), (double)((box.maxZ() + box.minZ()) / 2));
        ChunkLoaderPlayerHolder holder = this.forcedShips.compute(ship.getId(), (id, oldHolder) -> {
            if (oldHolder != null) {
                if (!oldHolder.isDiscarding()) {
                    oldHolder.setPosition(position);
                    return oldHolder;
                }
                oldHolder.setDiscardCallback(null);
            }
            ChunkLoaderPlayerHolder newHolder = ChunkLoaderPlayerHolder.createForShip(this.level, id, position);
            newHolder.setDiscardCallback(() -> this.forcedShips.remove(id, newHolder));
            return newHolder;
        });
        holder.refresh();
    }

    public void pingChunks(int minX, int maxX, int minZ, int maxZ) {
        int minRX = this.chunkToRegionPos(minX);
        int maxRX = this.chunkToRegionPos(maxX);
        int minRZ = this.chunkToRegionPos(minZ);
        int maxRZ = this.chunkToRegionPos(maxZ);
        for (int x = minRX; x <= maxRX; ++x) {
            for (int z = minRZ; z <= maxRZ; ++z) {
                this.pingRegion(x, z);
            }
        }
    }

    private int getRegionSize() {
        return this.level.method_8503().method_3760().method_38651() * 2 - 1;
    }

    private int chunkToRegionPos(int n) {
        return Math.floorDiv(n, this.getRegionSize());
    }

    private int regionToChunkPos(int n) {
        int size = this.getRegionSize();
        return n * size + size / 2;
    }

    private void pingRegion(int x, int z) {
        class_1923 pos0 = new class_1923(this.regionToChunkPos(x), this.regionToChunkPos(z));
        ChunkLoaderPlayerHolder holder = this.pingingRegions.compute(pos0, (pos, oldHolder) -> {
            if (oldHolder != null) {
                if (!oldHolder.isDiscarding()) {
                    return oldHolder;
                }
                oldHolder.setDiscardCallback(null);
            }
            ChunkLoaderPlayerHolder newHolder = ChunkLoaderPlayerHolder.createFixed(this.level, new class_243((double)pos.method_33940(), 0.0, (double)pos.method_33942()));
            newHolder.setDiscardCallback(() -> this.pingingRegions.remove(pos, newHolder));
            return newHolder;
        });
        holder.refresh();
    }
}

