/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.util;

import com.github.litermc.vschunkloader.Constants;
import com.github.litermc.vschunkloader.platform.PlatformHelper;
import com.github.litermc.vschunkloader.util.IChunkLoaderFakePlayer;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;

public final class ChunkLoaderPlayerHolder {
    private static int count = 0;
    private final class_3218 level;
    private final GameProfile fakeGameProfile;
    private class_243 position;
    private IChunkLoaderFakePlayer fakePlayer;
    private IPlayer playerData;

    private ChunkLoaderPlayerHolder(class_3218 level, class_243 position, String name) {
        this.level = level;
        this.position = position;
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        this.fakeGameProfile = new GameProfile(uuid, name);
        class_3222 fakePlayer = PlatformHelper.get().createFakePlayer(this.level, this.fakeGameProfile);
        this.fakePlayer = (IChunkLoaderFakePlayer)fakePlayer;
        this.playerData = new MinecraftPlayer((class_1657)fakePlayer);
        this.fakePlayer.bindPosition(this.position);
        fakePlayer.method_29495(this.position);
        this.level.method_18213(fakePlayer);
    }

    public static ChunkLoaderPlayerHolder createForBlock(class_3218 level, class_2338 blockPos) {
        Constants.LOG.debug("ChunkLoaderPlayerHolder: creating at block: {}", (Object)blockPos);
        String name = "ChunkLoader:" + level.method_27983().method_29177().toString() + "#" + blockPos.toString();
        return new ChunkLoaderPlayerHolder(level, blockPos.method_46558(), name);
    }

    public static ChunkLoaderPlayerHolder createFixed(class_3218 level, class_243 position) {
        Constants.LOG.debug("ChunkLoaderPlayerHolder: creating fixed: {}", (Object)position);
        int id = count++;
        String name = "ChunkLoaderFixed:" + level.method_27983().method_29177().toString() + "#" + Integer.toString(id, 16);
        return new ChunkLoaderPlayerHolder(level, position, name);
    }

    public static ChunkLoaderPlayerHolder createForShip(class_3218 level, long shipId, class_243 position) {
        Constants.LOG.debug("ChunkLoaderPlayerHolder: creating for ship: {} @ {}", (Object)shipId, (Object)position);
        String name = "ChunkLoaderShip:" + level.method_27983().method_29177().toString() + "#" + shipId;
        return new ChunkLoaderPlayerHolder(level, position, name);
    }

    public IPlayer getPlayerData() {
        return this.playerData;
    }

    public void setDiscardCallback(Runnable callback) {
        this.fakePlayer.setDiscardCallback(callback);
    }

    public void setPosition(class_243 position) {
        this.position = position;
        this.fakePlayer.bindPosition(position);
    }

    public void refresh() {
        this.fakePlayer.refreshCountDown();
    }

    public void discard() {
        this.fakePlayer.startDiscard();
    }

    public boolean isDiscarding() {
        return this.fakePlayer.isDiscarding();
    }
}

