/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader;

import com.github.litermc.vschunkloader.VSCApi;
import com.github.litermc.vschunkloader.attachment.ChunkSensorAttachment;
import com.github.litermc.vschunkloader.config.Config;
import com.github.litermc.vschunkloader.util.ChunkLoaderManager;
import com.github.litermc.vschunkloader.util.TaskUtil;
import com.github.litermc.vtil.util.LevelUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class VSCListeners {
    private VSCListeners() {
    }

    public static void onServerLevelLoad(ServerLevel level) {
        ChunkLoaderManager.get(level);
    }

    public static void onServerLevelUnload(ServerLevel level) {
    }

    public static void preServerTick(MinecraftServer server) {
        TaskUtil.preServerTick();
        ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((MinecraftServer)server);
        for (ServerShip ship : shipWorld.getAllShips()) {
            String slug;
            if (!Config.forceLoadAllShips ? !VSCApi.isForceLoaded(server, ship.getId()) : (slug = ship.getSlug()) != null && slug.startsWith("+reuse+")) continue;
            ServerLevel level = LevelUtil.getLevel((String)ship.getChunkClaimDimension());
            if (level == null) continue;
            ChunkLoaderManager.get(level).refreshForcedShip(ship);
        }
        for (ServerShip ship : shipWorld.getLoadedShips()) {
            ChunkSensorAttachment.get(ship).serverTick((LoadedServerShip)ship);
        }
    }

    public static void postServerTick(MinecraftServer server) {
        TaskUtil.postServerTick();
    }

    public static void onServerChunkLoad(ServerLevel level, LevelChunk chunk) {
    }

    public static void onServerChunkUnload(ServerLevel level, LevelChunk chunk) {
    }
}

