/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader;

import com.github.litermc.vschunkloader.block.ChunkLoaderBlock;
import com.github.litermc.vschunkloader.block.ChunkLoaderBlockEntity;
import com.github.litermc.vschunkloader.block.ChunkLoaderWeakBlock;
import com.github.litermc.vschunkloader.block.ChunkLoaderWeakBlockEntity;
import com.github.litermc.vschunkloader.block.ammo.AmmoAssemblerBlock;
import com.github.litermc.vschunkloader.block.ammo.AmmoAssemblerBlockEntity;
import com.github.litermc.vschunkloader.block.ammo.AmmoManagerBlock;
import com.github.litermc.vschunkloader.block.ammo.AmmoManagerBlockEntity;
import com.github.litermc.vschunkloader.platform.PlatformHelper;
import com.github.litermc.vschunkloader.platform.RegistrationHelper;
import com.github.litermc.vschunkloader.platform.RegistryEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;

public final class VSCRegistry {
    private VSCRegistry() {
    }

    public static void register() {
        Blocks.REGISTRY.register();
        BlockEntities.REGISTRY.register();
        Items.REGISTRY.register();
        CreativeTabs.REGISTRY.register();
    }

    public static final class Blocks {
        private static final RegistrationHelper<Block> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256747_);
        public static final RegistryEntry<AmmoAssemblerBlock> AMMO_ASSEMBLER = REGISTRY.register("ammo_assembler", () -> new AmmoAssemblerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(5.0f).m_60918_(SoundType.f_56749_).m_278166_(PushReaction.IGNORE).m_60924_((state, level, pos) -> false).m_60999_()));
        public static final RegistryEntry<AmmoManagerBlock> AMMO_MANAGER = REGISTRY.register("ammo_manager", () -> new AmmoManagerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(10.0f).m_60918_(SoundType.f_154663_).m_278166_(PushReaction.IGNORE).m_60924_((state, level, pos) -> false).m_60999_()));
        public static final RegistryEntry<ChunkLoaderBlock> CHUNK_LOADER = REGISTRY.register("chunk_loader", () -> new ChunkLoaderBlock(BlockBehaviour.Properties.m_284310_().m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_278166_(PushReaction.IGNORE).m_60955_().m_60924_((state, level, pos) -> false).m_60999_()));
        public static final RegistryEntry<ChunkLoaderWeakBlock> CHUNK_LOADER_WEAK = REGISTRY.register("chunk_loader_weak", () -> new ChunkLoaderWeakBlock(BlockBehaviour.Properties.m_284310_().m_60978_(3.0f).m_60918_(SoundType.f_56742_).m_278166_(PushReaction.IGNORE).m_60955_().m_60924_((state, level, pos) -> false).m_60999_()));

        private Blocks() {
        }
    }

    public static final class BlockEntities {
        private static final RegistrationHelper<BlockEntityType<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256922_);
        public static final RegistryEntry<BlockEntityType<AmmoAssemblerBlockEntity>> AMMO_ASSEMBLER = BlockEntities.ofBlock(Blocks.AMMO_ASSEMBLER, AmmoAssemblerBlockEntity::new);
        public static final RegistryEntry<BlockEntityType<AmmoManagerBlockEntity>> AMMO_MANAGER = BlockEntities.ofBlock(Blocks.AMMO_MANAGER, AmmoManagerBlockEntity::new);
        public static final RegistryEntry<BlockEntityType<ChunkLoaderBlockEntity>> CHUNK_LOADER = BlockEntities.ofBlock(Blocks.CHUNK_LOADER, ChunkLoaderBlockEntity::new);
        public static final RegistryEntry<BlockEntityType<ChunkLoaderWeakBlockEntity>> CHUNK_LOADER_WEAK = BlockEntities.ofBlock(Blocks.CHUNK_LOADER_WEAK, ChunkLoaderWeakBlockEntity::new);

        private static <T extends BlockEntity> RegistryEntry<BlockEntityType<T>> ofBlock(RegistryEntry<? extends Block> block, BiFunction<BlockPos, BlockState, T> factory) {
            return REGISTRY.register(block.id().m_135815_(), () -> PlatformHelper.get().createBlockEntityType(factory, (Block)block.get()));
        }

        private BlockEntities() {
        }
    }

    public static final class Items {
        private static final RegistrationHelper<Item> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256913_);
        private static final List<RegistryEntry<? extends Item>> TAB_ITEMS = new ArrayList<RegistryEntry<? extends Item>>();
        public static final RegistryEntry<BlockItem> AMMO_ASSEMBLER = Items.ofBlock(Blocks.AMMO_ASSEMBLER, (block, props) -> new BlockItem((Block)block, props.m_41497_(Rarity.UNCOMMON).m_41487_(64)));
        public static final RegistryEntry<BlockItem> AMMO_MANAGER = Items.ofBlock(Blocks.AMMO_MANAGER, (block, props) -> new BlockItem((Block)block, props.m_41497_(Rarity.RARE).m_41487_(1)));
        public static final RegistryEntry<BlockItem> CHUNK_LOADER = Items.ofBlock(Blocks.CHUNK_LOADER, (block, props) -> new BlockItem((Block)block, props.m_41497_(Rarity.EPIC).m_41487_(1)));
        public static final RegistryEntry<BlockItem> CHUNK_LOADER_WEAK = Items.ofBlock(Blocks.CHUNK_LOADER_WEAK, (block, props) -> new BlockItem((Block)block, props.m_41497_(Rarity.UNCOMMON).m_41487_(16)));

        private static Item.Properties properties() {
            return new Item.Properties();
        }

        private static <B extends Block, I extends Item> RegistryEntry<I> ofBlock(RegistryEntry<B> block, BiFunction<B, Item.Properties, I> supplier) {
            RegistryEntry<Item> entry = REGISTRY.register(block.id().m_135815_(), () -> (Item)supplier.apply((Block)block.get(), Items.properties()));
            TAB_ITEMS.add(entry);
            return entry;
        }

        private Items() {
        }
    }

    static class CreativeTabs {
        static final RegistrationHelper<CreativeModeTab> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_279569_);
        private static final RegistryEntry<CreativeModeTab> TAB = REGISTRY.register("tab", () -> PlatformHelper.get().newCreativeModeTab().m_257737_(() -> new ItemStack((ItemLike)Items.CHUNK_LOADER.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.vschunkloader")).m_257501_((context, out) -> Items.TAB_ITEMS.stream().map(Supplier::get).forEach(arg_0 -> ((CreativeModeTab.Output)out).m_246326_(arg_0))).m_257652_());

        CreativeTabs() {
        }
    }
}

