/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.github.litermc.vschunkloader.VSCListeners;
import com.github.litermc.vschunkloader.VSCRegistry;
import com.github.litermc.vschunkloader.block.BlockCapabilityProviders;
import com.github.litermc.vschunkloader.command.VSCCommands;
import com.github.litermc.vschunkloader.config.ConfigSpec;
import com.github.litermc.vschunkloader.platform.ForgeConfigFile;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="vschunkloader")
@Mod.EventBusSubscriber
public class VSChunkLoaderMod {
    public VSChunkLoaderMod() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modBus = context.getModEventBus();
        VSCRegistry.register();
        BlockCapabilityProviders.register();
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)((ForgeConfigFile)ConfigSpec.serverSpec).spec());
        modBus.addListener(this::onConfigLoad);
        modBus.addListener(this::onConfigReload);
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        VSCCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            VSCListeners.onServerLevelLoad(level);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            VSCListeners.onServerLevelUnload(level);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                VSCListeners.preServerTick(event.getServer());
                break;
            }
            case END: {
                VSCListeners.postServerTick(event.getServer());
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            levelAccessor = event.getChunk();
            if (levelAccessor instanceof LevelChunk) {
                LevelChunk chunk = (LevelChunk)levelAccessor;
                VSCListeners.onServerChunkLoad(level, chunk);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            levelAccessor = event.getChunk();
            if (levelAccessor instanceof LevelChunk) {
                LevelChunk chunk = (LevelChunk)levelAccessor;
                VSCListeners.onServerChunkUnload(level, chunk);
            }
        }
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        this.syncConfig(event.getConfig());
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        this.syncConfig(event.getConfig());
    }

    private void syncConfig(ModConfig config) {
        Path path;
        if (!config.getModId().equals("vschunkloader")) {
            return;
        }
        CommentedConfig commentedConfig = config.getConfigData();
        if (commentedConfig instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)commentedConfig;
            v0 = fileConfig.getNioPath();
        } else {
            v0 = path = null;
        }
        if (config.getType() == ModConfig.Type.SERVER && ((ForgeConfigFile)ConfigSpec.serverSpec).spec().isLoaded()) {
            ConfigSpec.syncServer(path);
        } else if (config.getType() == ModConfig.Type.CLIENT) {
            ConfigSpec.syncClient(path);
        }
    }
}

