/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block;

import com.github.litermc.vschunkloader.VSCRegistry;
import com.github.litermc.vschunkloader.config.Config;
import com.github.litermc.vschunkloader.util.ChunkLoaderManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ChunkLoaderBlockEntity
extends BlockEntity {
    private int activating = 0;
    private boolean wasActivated = true;
    private int energyStored = 0;
    Object energyStorage = null;

    protected ChunkLoaderBlockEntity(BlockEntityType<? extends ChunkLoaderBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ChunkLoaderBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ChunkLoaderBlockEntity>)((BlockEntityType)VSCRegistry.BlockEntities.CHUNK_LOADER.get()), pos, state);
    }

    public boolean isRunning() {
        return this.activating > 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int avaliable = this.getMaxEnergyStored() - this.energyStored;
        if (avaliable <= 0) {
            return 0;
        }
        int received = Math.min(avaliable, maxReceive);
        if (!simulate) {
            this.energyStored += received;
        }
        return received;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getEnergyConsumeRate() {
        return Config.chunkLoaderEnergyConsumeRate;
    }

    public int getMaxEnergyStored() {
        return this.getEnergyConsumeRate() * 4;
    }

    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.activating = data.m_128451_("Activating");
        this.energyStored = data.m_128451_("EnergyStored");
    }

    protected void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128405_("Activating", this.activating);
        data.m_128405_("EnergyStored", this.energyStored);
    }

    public void serverTick() {
        int newEnergy;
        ServerLevel level = (ServerLevel)this.m_58904_();
        if (level.m_7702_(this.m_58899_()) != this) {
            this.m_7651_();
            return;
        }
        if (this.activating <= 1 && (newEnergy = this.energyStored - this.getEnergyConsumeRate()) >= 0) {
            this.activating += 20;
            this.energyStored = newEnergy;
            this.m_6596_();
            this.wasActivated = true;
            this.onRefresh();
        }
        if (!this.isRunning()) {
            if (this.wasActivated) {
                this.wasActivated = false;
                this.onDeactivate();
                this.m_6596_();
            }
            return;
        }
        --this.activating;
        this.m_6596_();
    }

    public void onRefresh() {
        ServerLevel level = (ServerLevel)this.m_58904_();
        ChunkLoaderManager.get(level).refreshChunkLoader(this.m_58899_());
    }

    public void onDeactivate() {
        ServerLevel level = (ServerLevel)this.m_58904_();
        ChunkLoaderManager.get(level).deactivateChunkLoader(this.m_58899_());
    }
}

