/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block;

import com.github.litermc.vschunkloader.VSCRegistry;
import com.github.litermc.vschunkloader.block.ChunkLoaderBlockEntity;
import com.github.litermc.vschunkloader.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public final class ChunkLoaderWeakBlockEntity
extends ChunkLoaderBlockEntity {
    private int secondsUsed = 0;

    public ChunkLoaderWeakBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ChunkLoaderBlockEntity>)((BlockEntityType)VSCRegistry.BlockEntities.CHUNK_LOADER_WEAK.get()), pos, state);
    }

    @Override
    public boolean isRunning() {
        return super.isRunning() && !this.isOutOfTime();
    }

    @Override
    public int getEnergyConsumeRate() {
        return Config.weakChunkLoaderEnergyConsumeRate;
    }

    public boolean isOutOfTime() {
        return this.secondsUsed >= this.getMaxActiveSeconds();
    }

    public int getMaxActiveSeconds() {
        return Config.weakChunkLoaderMaxActivateSeconds;
    }

    @Override
    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.secondsUsed = data.m_128451_("SecondsUsed");
    }

    @Override
    protected void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128405_("SecondsUsed", this.secondsUsed);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.m_58901_()) {
            return;
        }
        if (this.isOutOfTime()) {
            this.m_58904_().m_46961_(this.m_58899_(), false);
            this.m_7651_();
        }
    }

    @Override
    public void onRefresh() {
        super.onRefresh();
        if (!this.isOutOfTime()) {
            ++this.secondsUsed;
            this.m_6596_();
        }
    }
}

