/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block.ammo;

import com.github.litermc.vschunkloader.VSCRegistry;
import com.github.litermc.vschunkloader.attachment.AmmoShipAttachment;
import com.github.litermc.vschunkloader.block.ammo.AmmoAssemblerBlock;
import com.github.litermc.vschunkloader.block.ammo.AmmoAssemblerPeripheral;
import com.github.litermc.vschunkloader.block.ammo.AssembleResult;
import com.github.litermc.vschunkloader.config.Config;
import com.github.litermc.vtil.block.AbstractAssemblerBlockEntity;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.primitives.AABBi;
import org.valkyrienskies.core.api.ships.ServerShip;

public class AmmoAssemblerBlockEntity
extends AbstractAssemblerBlockEntity {
    private static final int MAX_DIM = 128;
    private static final String AMMO_DEFAULT_SLUG_PREFIX = "+assembled+ammo+";
    private boolean triggering = false;
    private volatile AssembleResult assembleResult = AssembleResult.SUCCESS;
    private int energyStored = 0;
    private int energyConsumption = Config.ammoAssembleEnergy;
    private final AABBi box = new AABBi();
    private Runnable assembleFinishCallback = null;
    Object energyStorage = null;
    Object peripheral = null;

    public AmmoAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VSCRegistry.BlockEntities.AMMO_ASSEMBLER.get(), pos, state);
    }

    public boolean isAssembling() {
        return this.assembleResult.isWorking();
    }

    public boolean isAssembleSuccessed() {
        return this.assembleResult.isSuccess();
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }

    public AssembleResult getAssembleResult() {
        return this.assembleResult;
    }

    private void setAssembleResult(AssembleResult result) {
        if (this.assembleResult == result) {
            return;
        }
        this.assembleResult = result;
        this.m_6596_();
        this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(AmmoAssemblerBlock.LED, (Comparable)((Object)result.getLED())), 3);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int avaliable = this.getMaxEnergyStored() - this.energyStored;
        if (avaliable <= 0) {
            return 0;
        }
        int received = Math.min(Math.min(avaliable, maxReceive), (this.getMaxEnergyStored() + 99) / 100);
        if (!simulate) {
            this.energyStored += received;
        }
        return received;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.getEnergyConsumption();
    }

    public void m_142466_(CompoundTag data) {
        this.energyStored = data.m_128451_("EnergyStored");
        this.triggering = data.m_128471_("Powered");
        try {
            this.assembleResult = AssembleResult.valueOf(data.m_128461_("AssembleResult"));
        }
        catch (IllegalArgumentException e) {
            this.assembleResult = AssembleResult.SUCCESS;
        }
    }

    public void m_183515_(CompoundTag data) {
        data.m_128405_("EnergyStored", this.energyStored);
        data.m_128379_("Powered", this.triggering);
        this.saveShared(data);
    }

    public void saveShared(CompoundTag data) {
        data.m_128359_("AssembleResult", this.assembleResult.toString());
    }

    public CompoundTag m_5995_() {
        CompoundTag data = super.m_5995_();
        this.saveShared(data);
        return data;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void neighborChanged(Block neighbor, BlockPos neighborPos, boolean moving) {
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_();
        boolean shouldTrigger = Direction.m_235666_().filter(dir -> dir != this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).anyMatch(dir -> level.m_277185_(pos.m_121945_(dir), dir) > 0);
        if (this.triggering == shouldTrigger) {
            return;
        }
        this.triggering = shouldTrigger;
        if (shouldTrigger) {
            this.startAssemble(null);
        }
    }

    Object createPeripheral() {
        AmmoAssemblerPeripheral peripheral = new AmmoAssemblerPeripheral(this);
        this.assembleFinishCallback = peripheral::onAssembleFinish;
        return peripheral;
    }

    public boolean startAssemble(String slug) {
        if (this.isAssembling()) {
            return false;
        }
        if (this.energyStored < this.energyConsumption) {
            this.finishAssemble(AssembleResult.NO_ENERGY);
            return true;
        }
        return super.startAssemble(slug);
    }

    protected void setAssembling(boolean assembling) {
        super.setAssembling(assembling);
        if (assembling) {
            this.setAssembleResult(AssembleResult.WORKING);
        }
    }

    protected void finishAssemble(AssembleResult result) {
        this.setAssembleResult(result);
        this.finishAssemble();
    }

    protected void finishAssemble() {
        super.finishAssemble();
        if (this.assembleFinishCallback != null) {
            this.assembleFinishCallback.run();
        }
    }

    protected void finishAssembleAsSuccess() {
        this.finishAssemble(AssembleResult.SUCCESS);
    }

    protected void finishAssembleAsAssembleSelf() {
        this.finishAssemble(AssembleResult.ASSEMBLING_SELF);
    }

    protected void finishAssembleAsTooManyBlocks() {
        this.finishAssemble(AssembleResult.TOO_MANY_BLOCKS);
    }

    protected void finishAssembleAsNoBlockToAssemble() {
        this.finishAssemble(AssembleResult.NO_BLOCK);
    }

    protected void finishAssembleAsConflicts() {
        this.finishAssemble(AssembleResult.OTHER_ASSEMBLING);
    }

    protected void addAssemblingBlock(BlockPos pos) {
        Level level = this.m_58904_();
        if (!level.m_151577_(pos.m_123341_(), pos.m_123343_())) {
            this.finishAssemble(AssembleResult.CHUNK_UNLOADED);
            return;
        }
        BlockState block = level.m_8055_(pos);
        if (block.m_60795_()) {
            return;
        }
        if (!this.canAssembleBlock(block)) {
            this.finishAssemble(AssembleResult.UNABLE_ASSEMBLE);
            return;
        }
        this.box.union(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        if (this.box.lengthX() > 128 || this.box.lengthY() > 128 || this.box.lengthZ() > 128) {
            this.finishAssemble(AssembleResult.SIZE_OVERFLOW);
            return;
        }
        super.addAssemblingBlock(pos);
    }

    protected boolean canAssembleBlock(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof GameMasterBlock) {
            return false;
        }
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        return !Config.ammoAssembleBlacklist.contains(blockId);
    }

    protected void onAssembleSuccess(ServerShip ship) {
        if (ship.getSlug() == null) {
            ship.setSlug(AMMO_DEFAULT_SLUG_PREFIX + ship.getId());
        }
        AmmoShipAttachment.create(ship);
    }

    private static Stream<BlockPos> streamBlocksInAABB(AABB box) {
        int minX = (int)Math.round(box.f_82288_);
        int maxX = (int)Math.round(box.f_82291_);
        int minY = (int)Math.round(box.f_82289_);
        int maxY = (int)Math.round(box.f_82292_);
        int minZ = (int)Math.round(box.f_82290_);
        int maxZ = (int)Math.round(box.f_82293_);
        int widthX = maxX - minX;
        int widthY = maxY - minY;
        int widthZ = maxZ - minZ;
        return IntStream.range(0, widthX * widthY * widthZ).mapToObj(i -> {
            int x = i % widthX + minX;
            int z = (i /= widthX) % widthZ + minZ;
            int y = (i /= widthZ) + minY;
            return new BlockPos(x, y, z);
        });
    }
}

