/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block.ammo;

import com.github.litermc.vschunkloader.block.ammo.AmmoAssemblerBlockEntity;
import com.github.litermc.vschunkloader.compat.CompatMods;
import dan200.computercraft.shared.Capabilities;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public final class AmmoAssemblerBlockEntityCapabilityProvider
implements ICapabilityProvider {
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("vschunkloader", "ammo_assembler");
    private final AmmoAssemblerBlockEntity be;
    private final LazyOptional<IEnergyStorage> energyStorage;
    private final LazyOptional<Object> lazyPeripheral;

    private AmmoAssemblerBlockEntityCapabilityProvider(AmmoAssemblerBlockEntity be) {
        this.be = be;
        this.energyStorage = LazyOptional.of(() -> new EnergyStorage(this.be));
        this.lazyPeripheral = LazyOptional.of(this.be::createPeripheral);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyStorage.cast();
        }
        if (CompatMods.COMPUTERCRAFT.isLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.lazyPeripheral.cast();
        }
        return LazyOptional.empty();
    }

    private void invalidate() {
        this.energyStorage.invalidate();
        this.lazyPeripheral.invalidate();
    }

    public static void onGatherCapabilities(AttachCapabilitiesEvent<AmmoAssemblerBlockEntity> event) {
        AmmoAssemblerBlockEntityCapabilityProvider provider = new AmmoAssemblerBlockEntityCapabilityProvider((AmmoAssemblerBlockEntity)((Object)event.getObject()));
        event.addCapability(CAPABILITY_ID, (ICapabilityProvider)provider);
        event.addListener(provider::invalidate);
    }

    private static final class EnergyStorage
    implements IEnergyStorage {
        private final AmmoAssemblerBlockEntity be;

        private EnergyStorage(AmmoAssemblerBlockEntity be) {
            this.be = be;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.be.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return this.be.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.be.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

