/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.block.ammo;

import com.github.litermc.vschunkloader.VSCRegistry;
import com.github.litermc.vschunkloader.attachment.AmmoShipAttachment;
import com.github.litermc.vschunkloader.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class AmmoManagerBlockEntity
extends BlockEntity {
    private final AABBd manageArea;

    public AmmoManagerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VSCRegistry.BlockEntities.AMMO_MANAGER.get(), pos, state);
        double r = Config.ammoManagerAnchoringRange;
        this.manageArea = new AABBd((double)pos.m_123341_() - r, (double)pos.m_123342_() - r, (double)pos.m_123343_() - r, (double)pos.m_123341_() + r + 1.0, (double)pos.m_123342_() + r + 1.0, (double)pos.m_123343_() + r + 1.0);
    }

    public AABBd getManageArea() {
        ServerLevel level = (ServerLevel)this.m_58904_();
        ServerShip ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)this.m_58899_());
        if (ship == null) {
            return this.manageArea;
        }
        return this.manageArea.transform(ship.getShipToWorld(), new AABBd());
    }

    public void serverTick() {
        ServerLevel level = (ServerLevel)this.m_58904_();
        ServerShipWorldCore world = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
        for (LoadedServerShip ship : world.getLoadedShips().getIntersecting((AABBdc)this.getManageArea())) {
            AmmoShipAttachment attachment = (AmmoShipAttachment)ship.getAttachment(AmmoShipAttachment.class);
            if (attachment == null) continue;
            attachment.managerTick();
        }
    }
}

