/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.command;

import com.github.litermc.vschunkloader.VSCApi;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.command.ShipArgument;

public final class VSCCommands {
    public static final String ROOT_LITERAL = "vschunkloader";
    public static final ResourceLocation FORCELOAD_TOKEN = new ResourceLocation("vschunkloader", "command");

    private VSCCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)ROOT_LITERAL).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"forceload").then(Commands.m_82129_((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::forceLoad)))).then(Commands.m_82127_((String)"unforceload").then(Commands.m_82129_((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::unforceLoad)))).then(Commands.m_82127_((String)"unforceload-all").then(Commands.m_82129_((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::unforceLoadAll)))).then(Commands.m_82127_((String)"is-forceloaded").then(Commands.m_82129_((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::isForceLoaded)))).then(Commands.m_82127_((String)"query-forceload-tokens").then(Commands.m_82129_((String)"ships", (ArgumentType)ShipArgument.Companion.ships()).executes(VSCCommands::queryForceLoadTokens))));
    }

    private static int forceLoad(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.m_81377_();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        int successCount = 0;
        for (Ship ship : ships) {
            if (!VSCApi.forceLoad(server, ship.getId(), FORCELOAD_TOKEN, true)) continue;
            ++successCount;
        }
        int finalSuccessCount = successCount;
        source.m_288197_(() -> Component.m_237110_((String)"command.vschunkloader.forceload", (Object[])new Object[]{finalSuccessCount}), true);
        return finalSuccessCount;
    }

    private static int unforceLoad(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.m_81377_();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        int successCount = 0;
        for (Ship ship : ships) {
            if (!VSCApi.forceLoad(server, ship.getId(), FORCELOAD_TOKEN, false)) continue;
            ++successCount;
        }
        int finalSuccessCount = successCount;
        source.m_288197_(() -> Component.m_237110_((String)"command.vschunkloader.unforceload", (Object[])new Object[]{finalSuccessCount}), true);
        return finalSuccessCount;
    }

    private static int unforceLoadAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.m_81377_();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        int successCount = 0;
        for (Ship ship : ships) {
            if (!VSCApi.clearForceLoadTokens(server, ship.getId())) continue;
            ++successCount;
        }
        int finalSuccessCount = successCount;
        source.m_288197_(() -> Component.m_237110_((String)"command.vschunkloader.unforceload", (Object[])new Object[]{finalSuccessCount}), true);
        return finalSuccessCount;
    }

    private static int isForceLoaded(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.m_81377_();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        int loadedCount = 0;
        for (Ship ship : ships) {
            if (!VSCApi.isForceLoaded(server, ship.getId())) continue;
            ++loadedCount;
        }
        int finalLoadedCount = loadedCount;
        source.m_288197_(() -> finalLoadedCount == 0 ? Component.m_237115_((String)"command.vschunkloader.is_forceloaded.none") : Component.m_237110_((String)"command.vschunkloader.is_forceloaded", (Object[])new Object[]{finalLoadedCount}), false);
        return finalLoadedCount;
    }

    private static int queryForceLoadTokens(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.m_81377_();
        Set ships = ShipArgument.Companion.getShips(context, "ships");
        if (ships.isEmpty()) {
            source.m_81352_((Component)Component.m_237115_((String)"argument.valkyrienskies.ship.no_found"));
            return 0;
        }
        if (ships.size() > 1) {
            source.m_81352_((Component)Component.m_237115_((String)"argument.valkyrienskies.ship.multiple_found"));
            return 0;
        }
        Ship ship = (Ship)ships.iterator().next();
        Set<ResourceLocation> tokens = VSCApi.getForceLoadTokens(server, ship.getId());
        if (tokens == null) {
            source.m_81352_((Component)Component.m_237115_((String)"argument.valkyrienskies.ship.no_found"));
            return 0;
        }
        int count = tokens.size();
        if (count == 0) {
            source.m_288197_(() -> Component.m_237115_((String)"command.vschunkloader.query_forceload.none"), false);
            return 1;
        }
        source.m_288197_(() -> {
            MutableComponent component = Component.m_237110_((String)"command.vschunkloader.query_forceload.title", (Object[])new Object[]{count});
            tokens.stream().map(ResourceLocation::toString).sorted().map(token -> Component.m_237113_((String)"\n- ").m_130946_(token)).forEach(arg_0 -> ((MutableComponent)component).m_7220_(arg_0));
            return component;
        }, false);
        return count + 1;
    }
}

