/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.mixin.client;

import com.github.litermc.vschunkloader.accessor.ClientChunkCacheAccessor;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.compat.SodiumCompat;
import org.valkyrienskies.mod.compat.VSRenderer;
import org.valkyrienskies.mod.mixin.ValkyrienCommonMixinConfigPlugin;
import org.valkyrienskies.mod.mixin.accessors.client.multiplayer.ClientLevelAccessor;
import org.valkyrienskies.mod.mixin.accessors.client.render.LevelRendererAccessor;
import org.valkyrienskies.mod.mixinducks.client.render.IVSViewAreaMethods;
import org.valkyrienskies.mod.mixinducks.client.world.ClientChunkCacheDuck;
import org.valkyrienskies.mod.mixinducks.mod_compat.vanilla_renderer.LevelRendererDuck;

@Mixin(value={ClientChunkCache.class}, priority=100)
public abstract class MixinClientChunkCache
implements ClientChunkCacheAccessor,
ClientChunkCacheDuck {
    @Unique
    private static final LongObjectMap<LevelChunk> EMPTY_NETTY_MAP = new LongObjectHashMap();
    @Shadow
    @Final
    ClientLevel f_104411_;
    @Unique
    private final Long2ObjectMap<LevelChunk> shipChunks = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());

    public LongObjectMap<LevelChunk> vs$getShipChunks() {
        return EMPTY_NETTY_MAP;
    }

    @Override
    public Long2ObjectMap<LevelChunk> vsc$getShipChunks() {
        return this.shipChunks;
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void preReplaceWithPacketData(int x, int z, FriendlyByteBuf buf, CompoundTag tag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> cir) {
        LevelChunk worldChunk;
        ChunkPos pos;
        long chunkPosLong;
        LevelChunk oldChunk;
        System.out.println("packet with: " + x + ", " + z);
        if (!VSGameUtilsKt.isChunkInShipyard((Level)this.f_104411_, (int)x, (int)z)) {
            return;
        }
        LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
        if (levelRenderer instanceof LevelRendererDuck) {
            LevelRendererDuck levelRenderer2 = (LevelRendererDuck)levelRenderer;
            levelRenderer2.vs$setNeedsFrustumUpdate();
        }
        if ((oldChunk = (LevelChunk)this.shipChunks.get(chunkPosLong = (pos = new ChunkPos(x, z)).m_45588_())) != null) {
            worldChunk = oldChunk;
            worldChunk.m_187971_(buf, tag, consumer);
        } else {
            worldChunk = new LevelChunk((Level)this.f_104411_, pos);
            worldChunk.m_187971_(buf, tag, consumer);
            this.shipChunks.put(chunkPosLong, (Object)worldChunk);
        }
        this.f_104411_.m_171649_(pos);
        SodiumCompat.onChunkAdded((ClientLevel)this.f_104411_, (int)x, (int)z);
        cir.setReturnValue((Object)worldChunk);
    }

    public void vs$removeShip(ClientShip ship) {
        ChunkClaim chunks = ship.getChunkClaim();
        for (int x = chunks.getXStart(); x <= chunks.getXEnd(); ++x) {
            for (int z = chunks.getZStart(); z <= chunks.getZEnd(); ++z) {
                this.removeShipChunk(x, z);
            }
        }
    }

    @Unique
    private void removeShipChunk(int chunkX, int chunkZ) {
        LevelChunk chunk = (LevelChunk)this.shipChunks.remove(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
        if (chunk == null) {
            return;
        }
        this.f_104411_.m_104665_(chunk);
        if (ValkyrienCommonMixinConfigPlugin.getVSRenderer() != VSRenderer.SODIUM) {
            ((IVSViewAreaMethods)((LevelRendererAccessor)((ClientLevelAccessor)this.f_104411_).getLevelRenderer()).getViewArea()).unloadChunk(chunkX, chunkZ);
        }
        SodiumCompat.onChunkRemoved((ClientLevel)this.f_104411_, (int)chunkX, (int)chunkZ);
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/LevelChunk;"}, at={@At(value="HEAD")}, cancellable=true)
    public void preGetChunk(int chunkX, int chunkZ, ChunkStatus chunkStatus, boolean bl, CallbackInfoReturnable<LevelChunk> cir) {
        LevelChunk shipChunk = (LevelChunk)this.shipChunks.get(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
        if (shipChunk != null) {
            cir.setReturnValue((Object)shipChunk);
        }
    }
}

