/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.platform;

import com.github.litermc.vschunkloader.config.ConfigFile;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ForgeConfigFile
extends ConfigFile {
    private final ForgeConfigSpec spec;

    private ForgeConfigFile(ForgeConfigSpec spec, Map<String, ConfigFile.Entry> entries) {
        super(entries);
        this.spec = spec;
    }

    public ForgeConfigSpec spec() {
        return this.spec;
    }

    private static final class ValueImpl<T>
    extends ConfigFile.Value<T> {
        private final ForgeConfigSpec.ConfigValue<T> value;

        private ValueImpl(String path, String comment, ForgeConfigSpec.ConfigValue<T> value) {
            super(path, comment);
            this.value = value;
        }

        @Override
        public T get() {
            return (T)this.value.get();
        }
    }

    static class Builder
    extends ConfigFile.Builder {
        private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();

        Builder() {
        }

        private void translation(String name) {
            this.builder.translation(this.getTranslation(name));
        }

        @Override
        public ConfigFile.Builder comment(String comment) {
            super.comment(comment);
            this.builder.comment(comment);
            return this;
        }

        @Override
        public void push(String name) {
            super.push(name);
            this.translation(name);
            this.builder.push(name);
        }

        @Override
        public void pop() {
            super.pop();
            this.builder.pop();
        }

        @Override
        public ConfigFile.Builder worldRestart() {
            this.builder.worldRestart();
            return this;
        }

        private <T> ConfigFile.Value<T> defineValue(String name, ForgeConfigSpec.ConfigValue<T> value) {
            ValueImpl<T> wrapped = new ValueImpl<T>(this.getPath(name), this.takeComment(), value);
            ((ConfigFile.Builder.RootGroup)this.groupStack.getLast()).children().put(name, wrapped);
            return wrapped;
        }

        @Override
        public <T> ConfigFile.Value<T> define(String name, T defaultValue) {
            this.translation(name);
            return this.defineValue(name, this.builder.define(name, defaultValue));
        }

        @Override
        public ConfigFile.Value<Boolean> define(String name, boolean defaultValue) {
            this.translation(name);
            return this.defineValue(name, (ForgeConfigSpec.ConfigValue)this.builder.define(name, defaultValue));
        }

        @Override
        public ConfigFile.Value<Integer> defineInRange(String name, int defaultValue, int min, int max) {
            this.translation(name);
            return this.defineValue(name, (ForgeConfigSpec.ConfigValue)this.builder.defineInRange(name, defaultValue, min, max));
        }

        @Override
        public <T> ConfigFile.Value<List<? extends T>> defineList(String name, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            this.translation(name);
            return this.defineValue(name, this.builder.defineList(name, defaultValue, elementValidator));
        }

        @Override
        public <V extends Enum<V>> ConfigFile.Value<V> defineEnum(String name, V defaultValue) {
            this.translation(name);
            return this.defineValue(name, (ForgeConfigSpec.ConfigValue)this.builder.defineEnum(name, defaultValue));
        }

        @Override
        public ConfigFile build(ConfigFile.ConfigListener onChange) {
            Map<String, ConfigFile.Entry> children = ((ConfigFile.Builder.RootGroup)this.groupStack.removeLast()).children();
            if (!this.groupStack.isEmpty()) {
                throw new IllegalStateException("Mismatched config push/pop");
            }
            ForgeConfigSpec spec = this.builder.build();
            return new ForgeConfigFile(spec, children);
        }
    }
}

