/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.platform;

import com.github.litermc.vschunkloader.network.MessageType;
import com.github.litermc.vschunkloader.network.NetworkMessage;
import com.github.litermc.vschunkloader.network.NetworkMessages;
import com.github.litermc.vschunkloader.network.client.ClientNetworkContext;
import com.github.litermc.vschunkloader.network.server.ServerNetworkContext;
import com.github.litermc.vschunkloader.platform.Services;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkHandler.class);
    private static final SimpleChannel network;

    private NetworkHandler() {
    }

    public static void setup() {
        MessageTypeImpl forgeType;
        for (MessageType<? extends NetworkMessage<ServerNetworkContext>> messageType : NetworkMessages.getServerbound()) {
            forgeType = (MessageTypeImpl)messageType;
            NetworkHandler.registerMainThread(forgeType, NetworkDirection.PLAY_TO_SERVER, c -> () -> c.getSender());
        }
        for (MessageType<NetworkMessage<Object>> messageType : NetworkMessages.getClientbound()) {
            forgeType = (MessageTypeImpl)messageType;
            NetworkHandler.registerMainThread(forgeType, NetworkDirection.PLAY_TO_CLIENT, x -> ClientHolder.get());
        }
    }

    public static Packet<ClientGamePacketListener> createClientboundPacket(NetworkMessage<ClientNetworkContext> packet) {
        return network.toVanillaPacket(packet, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static Packet<ServerGamePacketListener> createServerboundPacket(NetworkMessage<ServerNetworkContext> packet) {
        return network.toVanillaPacket(packet, NetworkDirection.PLAY_TO_SERVER);
    }

    static <H, T extends NetworkMessage<H>> void registerMainThread(MessageTypeImpl<T> type, NetworkDirection direction, Function<NetworkEvent.Context, H> handler) {
        network.messageBuilder(type.klass(), type.id(), direction).encoder(NetworkMessage::write).decoder(type.reader()).consumerMainThread((packet, contextSup) -> {
            try {
                packet.handle(handler.apply((NetworkEvent.Context)contextSup.get()));
            }
            catch (Error | RuntimeException e) {
                LOG.error("Failed handling packet", e);
                throw e;
            }
        }).add();
    }

    static {
        String version = "1.5.0";
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("vschunkloader", "network")).networkProtocolVersion(() -> version).clientAcceptedVersions(version::equals).serverAcceptedVersions(version::equals).simpleChannel();
    }

    public record MessageTypeImpl<T extends NetworkMessage<?>>(int id, Class<T> klass, Function<FriendlyByteBuf, T> reader) implements MessageType<T>
    {
    }

    private static final class ClientHolder {
        @Nullable
        private static final ClientNetworkContext INSTANCE;
        @Nullable
        private static final Throwable ERROR;

        private ClientHolder() {
        }

        static ClientNetworkContext get() {
            ClientNetworkContext instance = INSTANCE;
            return instance == null ? Services.raise(ClientNetworkContext.class, ERROR) : instance;
        }

        static {
            Services.LoadedService<ClientNetworkContext> helper = Services.tryLoad(ClientNetworkContext.class);
            INSTANCE = helper.instance();
            ERROR = helper.error();
        }
    }
}

