/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.platform;

import com.github.litermc.vschunkloader.config.ConfigFile;
import com.github.litermc.vschunkloader.network.MessageType;
import com.github.litermc.vschunkloader.network.NetworkMessage;
import com.github.litermc.vschunkloader.network.client.ClientNetworkContext;
import com.github.litermc.vschunkloader.network.container.ContainerData;
import com.github.litermc.vschunkloader.platform.FakePlayer;
import com.github.litermc.vschunkloader.platform.ForgeConfigFile;
import com.github.litermc.vschunkloader.platform.NetworkHandler;
import com.github.litermc.vschunkloader.platform.PlatformHelper;
import com.github.litermc.vschunkloader.platform.RegistrationHelper;
import com.github.litermc.vschunkloader.platform.RegistryEntry;
import com.github.litermc.vschunkloader.platform.RegistryWrappers;
import com.google.auto.service.AutoService;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

@AutoService(value={PlatformHelper.class})
public class PlatformHelperImpl
implements PlatformHelper {
    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public ConfigFile.Builder createConfigBuilder() {
        return new ForgeConfigFile.Builder();
    }

    @Override
    public MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @Override
    public <T> ResourceLocation getRegistryKey(ResourceKey<Registry<T>> registry, T object) {
        ResourceLocation key = RegistryManager.ACTIVE.getRegistry(registry).getKey(object);
        if (key == null) {
            throw new IllegalArgumentException(object + " was not registered in " + registry);
        }
        return key;
    }

    @Override
    public <T> T getRegistryObject(ResourceKey<Registry<T>> registry, ResourceLocation id) {
        Object value = RegistryManager.ACTIVE.getRegistry(registry).getValue(id);
        if (value == null) {
            throw new IllegalArgumentException(id + " was not registered in " + registry);
        }
        return (T)value;
    }

    @Override
    public <T> RegistryWrappers.RegistryWrapper<T> wrap(ResourceKey<Registry<T>> key) {
        return new RegistryWrapperImpl(key.m_135782_(), RegistryManager.ACTIVE.getRegistry(key));
    }

    @Override
    public <T> RegistrationHelper<T> createRegistrationHelper(ResourceKey<Registry<T>> registry) {
        return new RegistrationHelperImpl(DeferredRegister.create(registry, (String)"vschunkloader"));
    }

    @Nullable
    public <K> K tryGetRegistryObject(ResourceKey<Registry<K>> registry, ResourceLocation id) {
        return (K)RegistryManager.ACTIVE.getRegistry(registry).getValue(id);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> factory, Block block) {
        return new BlockEntityType(factory::apply, Set.of(block), null);
    }

    @Override
    public <C extends AbstractContainerMenu, T extends ContainerData> MenuType<C> createMenuType(Function<FriendlyByteBuf, T> reader, ContainerData.Factory<C, T> factory) {
        return IForgeMenuType.create((id, player, data) -> factory.create(id, player, (ContainerData)reader.apply(data)));
    }

    @Override
    public void openMenu(Player player, Component title, MenuConstructor menu, ContainerData data) {
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider(menu, title), data::toBytes);
    }

    @Override
    public <T extends NetworkMessage<?>> MessageType<T> createMessageType(int id, ResourceLocation channel, Class<T> klass, FriendlyByteBuf.Reader<T> reader) {
        return new NetworkHandler.MessageTypeImpl<T>(id, klass, reader);
    }

    @Override
    public Packet<ClientGamePacketListener> createPacket(NetworkMessage<ClientNetworkContext> message) {
        return NetworkHandler.createClientboundPacket(message);
    }

    @Override
    public CreativeModeTab.Builder newCreativeModeTab() {
        return CreativeModeTab.builder();
    }

    @Override
    public ServerPlayer createFakePlayer(ServerLevel world, GameProfile profile) {
        return FakePlayer.create(world, profile);
    }

    private record RegistryWrapperImpl<T>(ResourceLocation name, ForgeRegistry<T> registry) implements RegistryWrappers.RegistryWrapper<T>
    {
        public int m_7447_(T object) {
            return this.registry.getID(object);
        }

        @Override
        public ResourceLocation getKey(T object) {
            ResourceLocation key = this.registry.getKey(object);
            if (key == null) {
                throw new IllegalStateException(object + " was not registered in " + this.name);
            }
            return key;
        }

        @Override
        public T get(ResourceLocation location) {
            Object object = this.registry.getValue(location);
            if (object == null) {
                throw new IllegalStateException(location + " was not registered in " + this.name);
            }
            return (T)object;
        }

        @Override
        @Nullable
        public T tryGet(ResourceLocation location) {
            return (T)this.registry.getValue(location);
        }

        @Nullable
        public T m_7942_(int id) {
            return (T)this.registry.getValue(id);
        }

        public int m_13562_() {
            return this.registry.getKeys().size();
        }

        public Iterator<T> iterator() {
            return this.registry.iterator();
        }
    }

    private record RegistrationHelperImpl<T>(DeferredRegister<T> registry) implements RegistrationHelper<T>
    {
        @Override
        public <U extends T> RegistryEntry<U> register(String name, Supplier<U> create) {
            return new RegistryEntryImpl(this.registry().register(name, create));
        }

        @Override
        public void register() {
            this.registry().register(FMLJavaModLoadingContext.get().getModEventBus());
        }
    }

    private record RegistryEntryImpl<T>(RegistryObject<T> object) implements RegistryEntry<T>
    {
        @Override
        public ResourceLocation id() {
            return this.object().getId();
        }

        @Override
        public T get() {
            return (T)this.object().get();
        }
    }
}

