/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.util;

import com.github.litermc.vschunkloader.block.ChunkLoaderBlockEntity;
import com.github.litermc.vschunkloader.util.ChunkLoaderPlayerHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;

public final class ChunkLoaderManager
extends SavedData {
    private static final String DATA_NAME = "vschunkloader_ChunkLoaders";
    private static final String POSITIONS_KEY = "Positions";
    private final ServerLevel level;
    private final Map<BlockPos, ChunkLoaderPlayerHolder> chunkLoaders = new ConcurrentHashMap<BlockPos, ChunkLoaderPlayerHolder>();
    private final Map<Long, ChunkLoaderPlayerHolder> forcedShips = new ConcurrentHashMap<Long, ChunkLoaderPlayerHolder>();
    private final Map<ChunkPos, ChunkLoaderPlayerHolder> pingingRegions = new ConcurrentHashMap<ChunkPos, ChunkLoaderPlayerHolder>();

    private ChunkLoaderManager(ServerLevel level) {
        this.level = level;
    }

    public static ChunkLoaderManager get(ServerLevel level) {
        return (ChunkLoaderManager)level.m_8895_().m_164861_(data -> ChunkLoaderManager.load(level, data), () -> new ChunkLoaderManager(level), DATA_NAME);
    }

    private static ChunkLoaderManager load(ServerLevel level, CompoundTag data) {
        ChunkLoaderManager manager = new ChunkLoaderManager(level);
        for (long posLong : data.m_128467_(POSITIONS_KEY)) {
            BlockPos pos = BlockPos.m_122022_((long)posLong);
            manager.chunkLoaders.put(pos, manager.createChunkLoaderHolder(pos));
        }
        return manager;
    }

    public CompoundTag m_7176_(CompoundTag data) {
        data.m_128388_(POSITIONS_KEY, this.chunkLoaders.keySet().stream().filter(pos -> {
            ChunkLoaderBlockEntity chunkLoader;
            BlockEntity patt2078$temp = this.level.m_7702_(pos);
            return patt2078$temp instanceof ChunkLoaderBlockEntity && (chunkLoader = (ChunkLoaderBlockEntity)patt2078$temp).isRunning();
        }).mapToLong(BlockPos::m_121878_).toArray());
        return data;
    }

    public Stream<ChunkLoaderPlayerHolder> streamChunkLoaders() {
        return Stream.of(this.chunkLoaders.values().stream(), this.forcedShips.values().stream(), this.pingingRegions.values().stream()).flatMap(Function.identity());
    }

    public void refreshChunkLoader(BlockPos pos) {
        ChunkLoaderPlayerHolder holder = this.chunkLoaders.compute(pos, (p, oldHolder) -> {
            boolean noOld;
            boolean bl = noOld = oldHolder == null;
            if (noOld || oldHolder.isDiscarding()) {
                if (noOld) {
                    this.m_77762_();
                } else {
                    oldHolder.setDiscardCallback(null);
                }
                oldHolder = this.createChunkLoaderHolder((BlockPos)p);
            }
            return oldHolder;
        });
        holder.refresh();
    }

    public void deactivateChunkLoader(BlockPos pos) {
        ChunkLoaderPlayerHolder holder = this.chunkLoaders.get(pos);
        if (holder != null) {
            holder.discard();
        }
    }

    private ChunkLoaderPlayerHolder createChunkLoaderHolder(BlockPos pos) {
        ChunkLoaderPlayerHolder holder = ChunkLoaderPlayerHolder.createForBlock(this.level, pos);
        holder.setDiscardCallback(() -> {
            if (this.chunkLoaders.remove(pos, holder)) {
                this.m_77762_();
            }
        });
        return holder;
    }

    public void refreshForcedShip(ServerShip ship) {
        AABBic box = ship.getShipAABB();
        if (box == null) {
            return;
        }
        Vec3 position = new Vec3((double)((box.maxX() + box.minX()) / 2), (double)((box.maxY() + box.minY()) / 2), (double)((box.maxZ() + box.minZ()) / 2));
        ChunkLoaderPlayerHolder holder = this.forcedShips.compute(ship.getId(), (id, oldHolder) -> {
            if (oldHolder != null) {
                if (!oldHolder.isDiscarding()) {
                    oldHolder.setPosition(position);
                    return oldHolder;
                }
                oldHolder.setDiscardCallback(null);
            }
            ChunkLoaderPlayerHolder newHolder = ChunkLoaderPlayerHolder.createForShip(this.level, id, position);
            newHolder.setDiscardCallback(() -> this.forcedShips.remove(id, newHolder));
            return newHolder;
        });
        holder.refresh();
    }

    public void pingChunks(int minX, int maxX, int minZ, int maxZ) {
        int minRX = this.chunkToRegionPos(minX);
        int maxRX = this.chunkToRegionPos(maxX);
        int minRZ = this.chunkToRegionPos(minZ);
        int maxRZ = this.chunkToRegionPos(maxZ);
        for (int x = minRX; x <= maxRX; ++x) {
            for (int z = minRZ; z <= maxRZ; ++z) {
                this.pingRegion(x, z);
            }
        }
    }

    private int getRegionSize() {
        return this.level.m_7654_().m_6846_().m_184213_() * 2 - 1;
    }

    private int chunkToRegionPos(int n) {
        return Math.floorDiv(n, this.getRegionSize());
    }

    private int regionToChunkPos(int n) {
        int size = this.getRegionSize();
        return n * size + size / 2;
    }

    private void pingRegion(int x, int z) {
        ChunkPos pos0 = new ChunkPos(this.regionToChunkPos(x), this.regionToChunkPos(z));
        ChunkLoaderPlayerHolder holder = this.pingingRegions.compute(pos0, (pos, oldHolder) -> {
            if (oldHolder != null) {
                if (!oldHolder.isDiscarding()) {
                    return oldHolder;
                }
                oldHolder.setDiscardCallback(null);
            }
            ChunkLoaderPlayerHolder newHolder = ChunkLoaderPlayerHolder.createFixed(this.level, new Vec3((double)pos.m_151390_(), 0.0, (double)pos.m_151393_()));
            newHolder.setDiscardCallback(() -> this.pingingRegions.remove(pos, newHolder));
            return newHolder;
        });
        holder.refresh();
    }
}

