/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.util;

import com.github.litermc.vschunkloader.Constants;
import com.github.litermc.vschunkloader.platform.PlatformHelper;
import com.github.litermc.vschunkloader.util.IChunkLoaderFakePlayer;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;

public final class ChunkLoaderPlayerHolder {
    private static int count = 0;
    private final ServerLevel level;
    private final GameProfile fakeGameProfile;
    private Vec3 position;
    private IChunkLoaderFakePlayer fakePlayer;
    private IPlayer playerData;

    private ChunkLoaderPlayerHolder(ServerLevel level, Vec3 position, String name) {
        this.level = level;
        this.position = position;
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        this.fakeGameProfile = new GameProfile(uuid, name);
        ServerPlayer fakePlayer = PlatformHelper.get().createFakePlayer(this.level, this.fakeGameProfile);
        this.fakePlayer = (IChunkLoaderFakePlayer)fakePlayer;
        this.playerData = new MinecraftPlayer((Player)fakePlayer);
        this.fakePlayer.bindPosition(this.position);
        fakePlayer.m_20219_(this.position);
        this.level.m_8834_(fakePlayer);
    }

    public static ChunkLoaderPlayerHolder createForBlock(ServerLevel level, BlockPos blockPos) {
        Constants.LOG.debug("ChunkLoaderPlayerHolder: creating at block: {}", (Object)blockPos);
        String name = "ChunkLoader:" + level.m_46472_().m_135782_().toString() + "#" + blockPos.toString();
        return new ChunkLoaderPlayerHolder(level, blockPos.m_252807_(), name);
    }

    public static ChunkLoaderPlayerHolder createFixed(ServerLevel level, Vec3 position) {
        Constants.LOG.debug("ChunkLoaderPlayerHolder: creating fixed: {}", (Object)position);
        int id = count++;
        String name = "ChunkLoaderFixed:" + level.m_46472_().m_135782_().toString() + "#" + Integer.toString(id, 16);
        return new ChunkLoaderPlayerHolder(level, position, name);
    }

    public static ChunkLoaderPlayerHolder createForShip(ServerLevel level, long shipId, Vec3 position) {
        Constants.LOG.debug("ChunkLoaderPlayerHolder: creating for ship: {} @ {}", (Object)shipId, (Object)position);
        String name = "ChunkLoaderShip:" + level.m_46472_().m_135782_().toString() + "#" + shipId;
        return new ChunkLoaderPlayerHolder(level, position, name);
    }

    public IPlayer getPlayerData() {
        return this.playerData;
    }

    public void setDiscardCallback(Runnable callback) {
        this.fakePlayer.setDiscardCallback(callback);
    }

    public void setPosition(Vec3 position) {
        this.position = position;
        this.fakePlayer.bindPosition(position);
    }

    public void refresh() {
        this.fakePlayer.refreshCountDown();
    }

    public void discard() {
        this.fakePlayer.startDiscard();
    }

    public boolean isDiscarding() {
        return this.fakePlayer.isDiscarding();
    }
}

