/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.util;

import com.github.litermc.vschunkloader.accessor.ServerLevelAccessor;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public final class ChunkSensor {
    private final Set<ChunkPos> loadedChunks = ConcurrentHashMap.newKeySet();

    public static ChunkSensor get(ServerLevel level) {
        return ((ServerLevelAccessor)level).vsc$getChunkSensor();
    }

    public boolean isChunkLoaded(ChunkPos pos) {
        return this.loadedChunks.contains(pos);
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.isChunkLoaded(new ChunkPos(x, z));
    }

    public void onChunkLoaded(ChunkPos pos) {
        this.loadedChunks.add(pos);
    }

    public void onChunkUnload(ChunkPos pos) {
        this.loadedChunks.remove(pos);
    }
}

