/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.util;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.world.level.ChunkPos;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.apigame.world.chunks.ChunkUnwatchTask;
import org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTask;
import org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTasks;

public final class ChunkWatchTasksImpl
implements ChunkWatchTasks {
    private final SortedSet<ChunkWatchTask> watchTasks;
    private final SortedSet<ChunkUnwatchTask> unwatchTasks;

    public ChunkWatchTasksImpl(SortedSet<ChunkWatchTask> watchTasks, SortedSet<ChunkUnwatchTask> unwatchTasks) {
        this.watchTasks = watchTasks == null ? Collections.emptySortedSet() : watchTasks;
        this.unwatchTasks = unwatchTasks == null ? Collections.emptySortedSet() : unwatchTasks;
    }

    public static ChunkWatchTasks merge(ChunkWatchTasks a, ChunkWatchTasks b) {
        return new ChunkWatchTasksImpl(ChunkWatchTasksImpl.mergeWatchSet(a.getWatchTasks(), b.getWatchTasks()), ChunkWatchTasksImpl.mergeUnwatchSet(a.getUnwatchTasks(), b.getUnwatchTasks()));
    }

    public SortedSet<ChunkWatchTask> getWatchTasks() {
        return this.watchTasks;
    }

    public SortedSet<ChunkUnwatchTask> getUnwatchTasks() {
        return this.unwatchTasks;
    }

    public static SortedSet<ChunkWatchTask> mergeWatchSet(SortedSet<ChunkWatchTask> a, SortedSet<ChunkWatchTask> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        TreeSet<ChunkWatchTask> set = new TreeSet<ChunkWatchTask>((x, y) -> Long.compare(x.getChunkPos(), y.getChunkPos()));
        set.addAll(a);
        set.addAll(b);
        return set;
    }

    public static SortedSet<ChunkUnwatchTask> mergeUnwatchSet(SortedSet<ChunkUnwatchTask> a, SortedSet<ChunkUnwatchTask> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        TreeSet<ChunkUnwatchTask> set = new TreeSet<ChunkUnwatchTask>((x, y) -> Long.compare(x.getChunkPos(), y.getChunkPos()));
        set.addAll(a);
        set.addAll(b);
        return set;
    }

    public static final class ChunkUnwatchTaskImpl
    implements ChunkUnwatchTask {
        private final ChunkPos chunkPos;
        private final String dimension;
        private final Iterable<IPlayer> players;
        private final boolean shouldUnload;
        private final ServerShip ship;

        public ChunkUnwatchTaskImpl(ChunkPos chunkPos, String dimension, Iterable<IPlayer> players, boolean shouldUnload, ServerShip ship) {
            this.chunkPos = chunkPos;
            this.dimension = dimension;
            this.players = players;
            this.shouldUnload = shouldUnload;
            this.ship = ship;
        }

        public long getChunkPos() {
            return this.chunkPos.m_45588_();
        }

        public String getDimensionId() {
            return this.dimension;
        }

        public Iterable<IPlayer> getPlayersNeedUnwatching() {
            return this.players;
        }

        public boolean getShouldUnload() {
            return this.shouldUnload;
        }

        public ServerShip getShip() {
            return this.ship;
        }

        public int getChunkX() {
            return this.chunkPos.f_45578_;
        }

        public int getChunkZ() {
            return this.chunkPos.f_45579_;
        }

        public int compareTo(ChunkUnwatchTask task) {
            return 0;
        }
    }
}

