/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.vschunkloader.util;

import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

public final class TaskUtil {
    private static final Queue<Task> TICK_START_QUEUE = new PriorityBlockingQueue<Task>();
    private static final Queue<Task> TICK_END_QUEUE = new PriorityBlockingQueue<Task>();
    private static volatile long tick = 0L;

    private TaskUtil() {
    }

    public static void preServerTick() {
        long t = ++tick;
        for (int i = TICK_START_QUEUE.size(); i > 0; --i) {
            Task task = TICK_START_QUEUE.element();
            if (task.tick() > t) {
                return;
            }
            TICK_START_QUEUE.remove();
            task.task().run();
        }
    }

    public static void postServerTick() {
        long t = tick;
        for (int i = TICK_END_QUEUE.size(); i > 0; --i) {
            Task task = TICK_END_QUEUE.element();
            if (task.tick() > t) {
                return;
            }
            TICK_END_QUEUE.remove();
            task.task().run();
        }
    }

    public static void queueTickStart(Runnable task) {
        TaskUtil.queueTickStart(0, task);
    }

    public static void queueTickStart(int delay, Runnable task) {
        TICK_START_QUEUE.add(new Task(tick + (long)delay, task));
    }

    public static void queueTickEnd(Runnable task) {
        TaskUtil.queueTickEnd(0, task);
    }

    public static void queueTickEnd(int delay, Runnable task) {
        TICK_END_QUEUE.add(new Task(tick + (long)delay, task));
    }

    record Task(long tick, Runnable task) implements Comparable<Task>
    {
        @Override
        public int compareTo(Task other) {
            return Long.compare(this.tick, other.tick);
        }
    }
}

