/*
 * Decompiled with CFR 0.152.
 */
package de.kevin_stefan.virtualChests;

import de.kevin_stefan.virtualChests.Lang;
import de.kevin_stefan.virtualChests.VCViewInfo;
import de.kevin_stefan.virtualChests.VirtualChests;
import de.kevin_stefan.virtualChests.storage.StorageProvider;
import de.kevin_stefan.virtualChests.storage.model.VirtualChest;
import de.kevin_stefan.virtualChests.storage.model.VirtualChestHistory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class VCManager {
    private static final HashMap<UUID, VCViewInfo> openChests = new HashMap();

    private VCManager() {
    }

    public static void openChest(Player player, OfflinePlayer targetPlayer, int number) {
        if (!openChests.containsKey(targetPlayer.getUniqueId())) {
            Inventory inventory;
            Component title = VirtualChests.getPluginLanguage().getFormatted(new Lang.CHEST_NAME(targetPlayer.getName(), number));
            VirtualChest virtualChest = StorageProvider.getInstance().getVChest(targetPlayer.getUniqueId(), number);
            if (virtualChest == null) {
                virtualChest = new VirtualChest();
                virtualChest.setPlayer(targetPlayer.getUniqueId());
                virtualChest.setNumber(number);
                inventory = VCManager.createVChestInventory(title, null);
            } else {
                inventory = VCManager.createVChestInventory(title, virtualChest.getContent());
            }
            openChests.put(targetPlayer.getUniqueId(), new VCViewInfo(virtualChest, inventory));
        }
        player.openInventory(VCManager.openChests.get((Object)targetPlayer.getUniqueId()).inventory);
    }

    public static void closeInventory(Inventory inventory) {
        List<VCViewInfo> list = openChests.values().stream().filter(viewInfo -> viewInfo.inventory.equals((Object)inventory)).toList();
        if (list.isEmpty()) {
            return;
        }
        if (list.size() > 1) {
            VirtualChests.getInstance().getLogger().warning("Found multiple inventories in the list, this should not happen");
            return;
        }
        VCViewInfo viewInfo2 = list.getFirst();
        byte[] serializedItems = ItemStack.serializeItemsAsBytes((ItemStack[])inventory.getContents());
        if (inventory.isEmpty()) {
            StorageProvider.getInstance().deleteVChest(viewInfo2.virtualChest);
        } else {
            viewInfo2.virtualChest.setContent(serializedItems);
            VirtualChest savedVChest = StorageProvider.getInstance().setVChest(viewInfo2.virtualChest);
            if (savedVChest != null) {
                viewInfo2.virtualChest = savedVChest;
            } else {
                VirtualChests.getPluginLogger().severe("Unexpected error occurred: Could not save VirtualChest");
            }
        }
        VCManager.addHistory(viewInfo2.virtualChest.getPlayer(), viewInfo2.virtualChest.getNumber(), serializedItems);
        if (inventory.getViewers().size() == 1) {
            openChests.remove(viewInfo2.virtualChest.getPlayer());
        }
    }

    public static Inventory createVChestInventory(Component title, @Nullable byte[] content) {
        int size = VirtualChests.getPluginConfig().getInt("chest_rows") * 9;
        Inventory inventory = Bukkit.createInventory(null, (int)size, (Component)title);
        if (content != null) {
            ItemStack[] items = ItemStack.deserializeItemsFromBytes((byte[])content);
            if (items.length > inventory.getSize()) {
                throw new RuntimeException(String.format("More items than space in chest. Did you lower chest_rows in config? (expected %d, got %d)", items.length / 9, inventory.getSize() / 9));
            }
            inventory.setContents(items);
        }
        return inventory;
    }

    public static void addHistory(UUID player, int number, byte[] content) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)VirtualChests.getInstance(), () -> {
            VirtualChestHistory newHistory = new VirtualChestHistory();
            newHistory.setPlayer(player);
            newHistory.setNumber(number);
            newHistory.setContent(content);
            newHistory.setTimestamp(System.currentTimeMillis());
            VirtualChestHistory lastHistory = StorageProvider.getInstance().getLastVChestHistory(player, number);
            if (lastHistory == null || !Arrays.equals(content, lastHistory.getContent())) {
                StorageProvider.getInstance().addVChestHistory(newHistory);
            }
        });
    }
}

