/*
 * Decompiled with CFR 0.152.
 */
package de.kevin_stefan.virtualChests.storage;

import de.kevin_stefan.virtualChests.VirtualChests;
import de.kevin_stefan.virtualChests.storage.model.VirtualChest;
import de.kevin_stefan.virtualChests.storage.model.VirtualChestHistory;
import dev.dejvokep.boostedyaml.YamlDocument;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hibernate.cfg.Configuration;
import org.jetbrains.annotations.Nullable;

public class StorageProvider {
    private static StorageProvider instance;
    private final EntityManagerFactory factory;

    private StorageProvider() {
        VirtualChests.getPluginLogger().info("Loading Storage...");
        Configuration dbConfig = new Configuration();
        YamlDocument config = VirtualChests.getPluginConfig();
        String storageType = config.getString("storage.type", "sqlite");
        if (storageType.equalsIgnoreCase("mysql")) {
            VirtualChests.getPluginLogger().info("using MySQL");
            String address = config.getString("storage.mysql.address");
            String database = config.getString("storage.mysql.database");
            String username = config.getString("storage.mysql.username");
            String password = config.getString("storage.mysql.password");
            dbConfig.setJdbcUrl("jdbc:mysql://" + address + "/" + database);
            dbConfig.setCredentials(username, password);
            dbConfig.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQLDialect");
            dbConfig.setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver");
        } else {
            VirtualChests.getPluginLogger().info("using SQLite");
            dbConfig.setJdbcUrl("jdbc:sqlite:" + String.valueOf(new File(VirtualChests.getInstance().getDataFolder(), "data.db")));
            dbConfig.setProperty("hibernate.dialect", "org.hibernate.community.dialect.SQLiteDialect");
            dbConfig.setProperty("hibernate.connection.driver_class", "org.sqlite.JDBC");
        }
        dbConfig.setProperty("hibernate.hbm2ddl.auto", "update");
        dbConfig.setProperty("hibernate.c3p0.min_size", 1);
        dbConfig.setProperty("hibernate.c3p0.max_size", 10);
        dbConfig.setProperty("hibernate.show_sql", VirtualChests.getPluginLogger().isDebug());
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        dbConfig.addAnnotatedClass(VirtualChest.class);
        dbConfig.addAnnotatedClass(VirtualChestHistory.class);
        this.factory = dbConfig.buildSessionFactory();
    }

    public static StorageProvider getInstance() {
        if (instance == null) {
            instance = new StorageProvider();
        }
        return instance;
    }

    public static void close() {
        if (instance != null) {
            StorageProvider.instance.factory.close();
        }
    }

    public void testConnection() {
        try (EntityManager manager = this.factory.createEntityManager();){
            manager.isOpen();
        }
    }

    @Nullable
    public VirtualChest getVChest(UUID player, int number) {
        try (EntityManager manager = this.factory.createEntityManager();){
            TypedQuery query = manager.createNamedQuery("VirtualChest.get", VirtualChest.class);
            query.setParameter("player", (Object)player);
            query.setParameter("number", (Object)number);
            VirtualChest virtualChest = (VirtualChest)query.getSingleResultOrNull();
            return virtualChest;
        }
    }

    @Nullable
    public VirtualChest setVChest(VirtualChest vChest) {
        try (EntityManager manager = this.factory.createEntityManager();){
            manager.getTransaction().begin();
            VirtualChest virtualChest = (VirtualChest)manager.merge((Object)vChest);
            manager.getTransaction().commit();
            VirtualChest virtualChest2 = virtualChest;
            return virtualChest2;
        }
    }

    public void deleteVChest(VirtualChest vChest) {
        try (EntityManager manager = this.factory.createEntityManager();){
            manager.getTransaction().begin();
            manager.remove((Object)vChest);
            manager.getTransaction().commit();
        }
    }

    public long getVChestCount(UUID player, int number) {
        try (EntityManager manager = this.factory.createEntityManager();){
            CriteriaBuilder builder = manager.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Long.class);
            Root root = query.from(VirtualChest.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("player"), (Object)player));
            predicates.add(builder.equal((Expression)root.get("number"), (Object)number));
            query.select((Selection)builder.count((Expression)root)).where((Expression)builder.and(predicates));
            long l = (Long)manager.createQuery(query).getSingleResult();
            return l;
        }
    }

    public boolean doesVChestExist(UUID player, int number) {
        return this.getVChestCount(player, number) > 0L;
    }

    @Nullable
    public VirtualChestHistory getLastVChestHistory(UUID player, int number) {
        try (EntityManager manager = this.factory.createEntityManager();){
            TypedQuery query = manager.createNamedQuery("VirtualChestHistory.get", VirtualChestHistory.class);
            query.setParameter("player", (Object)player);
            query.setParameter("number", (Object)number);
            query.setMaxResults(1);
            VirtualChestHistory virtualChestHistory = (VirtualChestHistory)query.getSingleResultOrNull();
            return virtualChestHistory;
        }
    }

    public List<VirtualChestHistory> getVChestHistory(UUID player, int number) {
        try (EntityManager manager = this.factory.createEntityManager();){
            TypedQuery query = manager.createNamedQuery("VirtualChestHistory.get", VirtualChestHistory.class);
            query.setParameter("player", (Object)player);
            query.setParameter("number", (Object)number);
            List list = query.getResultList();
            return list;
        }
    }

    public List<VirtualChestHistory> getVChestHistory(UUID player, int number, int page) {
        int pageSize = VirtualChests.getPluginConfig().getInt("history_page_size");
        int offset = (page - 1) * pageSize;
        try (EntityManager manager = this.factory.createEntityManager();){
            TypedQuery query = manager.createNamedQuery("VirtualChestHistory.get", VirtualChestHistory.class);
            query.setParameter("player", (Object)player);
            query.setParameter("number", (Object)number);
            query.setFirstResult(offset);
            query.setMaxResults(pageSize);
            List list = query.getResultList();
            return list;
        }
    }

    public long getVChestHistoryCount(UUID player, int number) {
        try (EntityManager manager = this.factory.createEntityManager();){
            CriteriaBuilder builder = manager.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Long.class);
            Root root = query.from(VirtualChestHistory.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("player"), (Object)player));
            predicates.add(builder.equal((Expression)root.get("number"), (Object)number));
            query.select((Selection)builder.count((Expression)root)).where((Expression)builder.and(predicates));
            long l = (Long)manager.createQuery(query).getSingleResult();
            return l;
        }
    }

    @Nullable
    public VirtualChestHistory getVChestHistory(int id, UUID player, int number) {
        try (EntityManager manager = this.factory.createEntityManager();){
            TypedQuery query = manager.createNamedQuery("VirtualChestHistory.getOne", VirtualChestHistory.class);
            query.setParameter("id", (Object)id);
            query.setParameter("player", (Object)player);
            query.setParameter("number", (Object)number);
            query.setMaxResults(1);
            VirtualChestHistory virtualChestHistory = (VirtualChestHistory)query.getSingleResultOrNull();
            return virtualChestHistory;
        }
    }

    public void addVChestHistory(VirtualChestHistory vChestHistory) {
        try (EntityManager manager = this.factory.createEntityManager();){
            manager.getTransaction().begin();
            manager.persist((Object)vChestHistory);
            int keepLast = VirtualChests.getPluginConfig().getInt("keep_last");
            if (keepLast > 0) {
                Query deleteQuery = manager.createQuery("delete from VirtualChestHistory where player = :player and number = :number and id not in (select id from VirtualChestHistory where player = :player and number = :number order by timestamp desc limit :limit)");
                deleteQuery.setParameter("player", (Object)vChestHistory.getPlayer());
                deleteQuery.setParameter("number", (Object)vChestHistory.getNumber());
                deleteQuery.setParameter("limit", (Object)keepLast);
                deleteQuery.executeUpdate();
            }
            manager.getTransaction().commit();
        }
    }

    public void deleteVChestHistory(VirtualChestHistory vChestHistory) {
        try (EntityManager manager = this.factory.createEntityManager();){
            manager.getTransaction().begin();
            manager.remove((Object)vChestHistory);
            manager.getTransaction().commit();
        }
    }
}

