/*
 * Decompiled with CFR 0.152.
 */
package de.kevin_stefan.virtualChests.utils;

import de.kevin_stefan.virtualChests.utils.PluginLanguage;
import de.kevin_stefan.virtualChests.utils.PluginLogger;
import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.dvs.versioning.Versioning;
import dev.dejvokep.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import dev.dejvokep.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import dev.dejvokep.boostedyaml.serialization.YamlSerializer;
import dev.dejvokep.boostedyaml.settings.Settings;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import dev.dejvokep.boostedyaml.spigot.SpigotSerializer;
import dev.dejvokep.boostedyaml.utils.format.NodeRole;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class MinecraftPlugin
extends JavaPlugin {
    private static PluginLogger logger;
    private static YamlDocument config;
    private static PluginLanguage language;

    public void onEnable() {
        config = this.initializeConfig();
        logger = new PluginLogger(this.getLogger(), config.getBoolean("debug", Boolean.valueOf(false)));
        language = new PluginLanguage(config);
    }

    public static PluginLogger getPluginLogger() {
        return logger;
    }

    public static YamlDocument getPluginConfig() {
        return config;
    }

    public static PluginLanguage getPluginLanguage() {
        return language;
    }

    private YamlDocument initializeConfig() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        InputStream defaultConfigStream = this.getResource("config.yml");
        if (defaultConfigStream == null) {
            throw new RuntimeException("No default config.yml file found inside the plugins resources folder");
        }
        LoaderSettings loaderSettings = LoaderSettings.builder().setAutoUpdate(true).build();
        UpdaterSettings updaterSettings = UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("config-version")).build();
        GeneralSettings generalSettings = GeneralSettings.builder().setSerializer((YamlSerializer)SpigotSerializer.getInstance()).build();
        DumperSettings dumperSettings = DumperSettings.builder().setScalarFormatter((tag, value, role, def) -> {
            if (tag != Tag.STR) {
                return def;
            }
            return role == NodeRole.KEY ? ScalarStyle.PLAIN : ScalarStyle.DOUBLE_QUOTED;
        }).build();
        try {
            return YamlDocument.create((File)configFile, (InputStream)defaultConfigStream, (Settings[])new Settings[]{loaderSettings, updaterSettings, generalSettings, dumperSettings});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

