/*
 * Decompiled with CFR 0.152.
 */
package de.kevin_stefan.virtualChests.utils;

import java.util.logging.Logger;

public final class PluginLogger {
    private final Logger logger;
    private boolean debug = false;

    public PluginLogger(Logger pluginLogger) {
        this.logger = pluginLogger;
    }

    public PluginLogger(Logger pluginLogger, boolean debug) {
        this.logger = pluginLogger;
        this.setDebug(debug);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void warning(String msg) {
        this.logger.warning(msg);
    }

    public void severe(String msg) {
        this.logger.severe(msg);
    }

    public void debug(String msg) {
        StackWalker.StackFrame frame = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stream -> stream.skip(1L).findFirst().orElse(null));
        if (frame == null) {
            this.logger.info("DEBUG: " + msg);
            return;
        }
        String caller = String.format("L%s %s#%s: ", frame.getLineNumber(), frame.getDeclaringClass().getSimpleName(), frame.getMethodName());
        this.logger.info(caller + msg);
    }
}

