/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.chestsearch;

import java.lang.reflect.Method;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2480;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3708;
import net.minecraft.class_631;
import net.minecraft.class_8168;
import net.wurstclient.WurstClient;
import net.wurstclient.chestsearch.ChestEntry;
import net.wurstclient.chestsearch.ChestManager;
import net.wurstclient.clickgui.screens.ChestSearchScreen;

public class ChestCleaner {
    private final ChestManager manager = new ChestManager();
    private int tickCounter = 0;
    private int ticksSinceWorldObserved = 0;
    private String lastServer = null;
    private String lastDimension = null;

    public void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            try {
                ++this.tickCounter;
                if (this.tickCounter < 100) {
                    return;
                }
                this.tickCounter = 0;
                class_310 mc = WurstClient.MC;
                if (mc == null || mc.field_1687 == null) {
                    return;
                }
                String curServer = null;
                try {
                    if (mc.method_1558() != null) {
                        curServer = mc.method_1558().field_3761;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String curDimension = null;
                try {
                    curDimension = mc.field_1687.method_27983().method_29177().toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.lastServer == null || !this.lastServer.equals(curServer) || this.lastDimension == null || !this.lastDimension.equals(curDimension)) {
                    this.ticksSinceWorldObserved = 0;
                    this.lastServer = curServer;
                    this.lastDimension = curDimension;
                } else {
                    this.ticksSinceWorldObserved += 100;
                }
                String serverIp = null;
                try {
                    if (mc.method_1558() != null) {
                        serverIp = mc.method_1558().field_3761;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String dimension = null;
                try {
                    dimension = mc.field_1687.method_27983().method_29177().toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                for (ChestEntry e : this.manager.all()) {
                    if (e.serverIp != null && serverIp != null && !e.serverIp.equals(serverIp) || e.dimension != null && dimension != null && !e.dimension.equals(dimension)) continue;
                    try {
                        int closestZ;
                        long dz;
                        int closestY;
                        long dy;
                        int configuredRadius;
                        int configuredGrace = this.manager.getConfig() == null ? 200 : this.manager.getConfig().graceTicks;
                        int n = configuredRadius = this.manager.getConfig() == null ? 64 : this.manager.getConfig().scanRadius;
                        if (this.ticksSinceWorldObserved < configuredGrace) continue;
                        int minX = Math.min(e.x, e.maxX);
                        int minY = Math.min(e.y, e.maxY);
                        int minZ = Math.min(e.z, e.maxZ);
                        int maxX = Math.max(e.x, e.maxX);
                        int maxY = Math.max(e.y, e.maxY);
                        int maxZ = Math.max(e.z, e.maxZ);
                        class_2338 playerPos = mc.field_1724.method_24515();
                        int px = playerPos.method_10263();
                        int py = playerPos.method_10264();
                        int pz = playerPos.method_10260();
                        int closestX = Math.max(minX, Math.min(px, maxX));
                        long dx = px - closestX;
                        long distSq = dx * dx + (dy = (long)(py - (closestY = Math.max(minY, Math.min(py, maxY))))) * dy + (dz = (long)(pz - (closestZ = Math.max(minZ, Math.min(pz, maxZ))))) * dz;
                        if (distSq > (long)configuredRadius * (long)configuredRadius) continue;
                        boolean anyChunkNotLoaded = false;
                        boolean anyContainerPresent = false;
                        block17: for (int bx = minX; bx <= maxX; ++bx) {
                            for (int by = minY; by <= maxY; ++by) {
                                for (int bz = minZ; bz <= maxZ; ++bz) {
                                    boolean hasBe;
                                    class_2338 pos = new class_2338(bx, by, bz);
                                    boolean chunkLoaded = false;
                                    try {
                                        boolean tmp;
                                        chunkLoaded = tmp = mc.field_1687.method_22340(pos);
                                    }
                                    catch (Throwable ignored) {
                                        try {
                                            class_631 cm = mc.field_1687.method_2935();
                                            Method m = cm.getClass().getMethod("isChunkLoaded", Integer.TYPE, Integer.TYPE);
                                            chunkLoaded = Boolean.TRUE.equals(m.invoke((Object)cm, pos.method_10263() >> 4, pos.method_10260() >> 4));
                                        }
                                        catch (Throwable cm) {
                                            // empty catch block
                                        }
                                    }
                                    if (!chunkLoaded) {
                                        anyChunkNotLoaded = true;
                                        break block17;
                                    }
                                    class_2680 state = mc.field_1687.method_8320(pos);
                                    boolean containerBlock = state != null && (state.method_26204() instanceof class_2281 || state.method_26204() instanceof class_3708 || state.method_26204() instanceof class_2480 || state.method_26204() instanceof class_8168);
                                    boolean bl = hasBe = mc.field_1687.method_8321(pos) != null;
                                    if (!containerBlock || !hasBe) continue;
                                    anyContainerPresent = true;
                                    break block17;
                                }
                            }
                        }
                        if (anyChunkNotLoaded || anyContainerPresent) continue;
                        ChestSearchScreen.clearDecorations(e.dimension, e.getMinPos());
                        this.manager.removeChest(e.serverIp, e.dimension, minX, minY, minZ);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }
}

