/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.chestsearch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.wurstclient.chestsearch.ChestEntry;

public class ChestDatabase {
    private final File file;
    private final Gson gson;
    private List<ChestEntry> entries;

    public ChestDatabase(File file) {
        this.file = file;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.entries = new ArrayList<ChestEntry>();
        this.load();
    }

    private void load() {
        try {
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
                this.entries = new ArrayList<ChestEntry>();
                this.save();
                return;
            }
            Type t = new TypeToken<List<ChestEntry>>(this){}.getType();
            try (FileReader r = new FileReader(this.file);){
                List read = (List)this.gson.fromJson((Reader)r, t);
                if (read != null) {
                    for (ChestEntry entry : read) {
                        if (entry == null) continue;
                        entry.ensureBounds();
                    }
                    this.entries = read;
                    if (this.dedupeLoadedEntries()) {
                        this.save();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.entries = new ArrayList<ChestEntry>();
        }
    }

    public synchronized void save() {
        try (FileWriter w = new FileWriter(this.file);){
            this.gson.toJson(this.entries, (Appendable)w);
            System.out.println("[ChestDatabase] saved " + this.entries.size() + " entries to " + this.file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void upsert(ChestEntry entry) {
        if (entry != null) {
            entry.ensureBounds();
        }
        try {
            String eServer = entry.serverIp;
            String eDim = entry.dimension;
            String entryKey = this.contentsKey(entry);
            if (entryKey != null) {
                for (ChestEntry e : this.entries) {
                    String k;
                    if (!this.equalsServerDim(e, eServer, eDim) || (k = this.contentsKey(e)) == null || !k.equals(entryKey) || !this.equalsPos(e, entry)) continue;
                    entry.x = e.x;
                    entry.y = e.y;
                    entry.z = e.z;
                    entry.clickedX = e.clickedX;
                    entry.clickedY = e.clickedY;
                    entry.clickedZ = e.clickedZ;
                    this.entries.remove(e);
                    entry.touch();
                    this.entries.add(entry);
                    this.finalizeInsert(entry);
                    System.out.println("[ChestDatabase] merged entry by contents; preserved primary=" + entry.x + "," + entry.y + "," + entry.z);
                    return;
                }
            }
        }
        catch (Throwable eServer) {
            // empty catch block
        }
        Iterator<ChestEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            ChestEntry e = it.next();
            if (!this.equalsPos(e, entry) || !this.equalsServerDim(e, entry)) continue;
            entry.x = e.x;
            entry.y = e.y;
            entry.z = e.z;
            entry.clickedX = e.clickedX;
            entry.clickedY = e.clickedY;
            entry.clickedZ = e.clickedZ;
            entry.touch();
            it.remove();
            this.entries.add(entry);
            this.finalizeInsert(entry);
            System.out.println("[ChestDatabase] updated entry at bounds " + String.valueOf(entry.getMinPos()) + " -> " + String.valueOf(entry.getMaxPos()) + " facing=" + entry.facing + " (preserved primary=" + entry.x + "," + entry.y + "," + entry.z + ")");
            return;
        }
        entry.touch();
        this.entries.add(entry);
        this.finalizeInsert(entry);
        System.out.println("[ChestDatabase] added entry at bounds " + String.valueOf(entry.getMinPos()) + " -> " + String.valueOf(entry.getMaxPos()) + " facing=" + entry.facing);
    }

    public synchronized void removeAt(String serverIp, String dimension, int x, int y, int z) {
        this.entries = this.entries.stream().filter(e -> !this.equalsServerDim((ChestEntry)e, serverIp, dimension) || e.x != x || e.y != y || e.z != z).collect(Collectors.toList());
        this.save();
        System.out.println("[ChestDatabase] removed entry at " + x + "," + y + "," + z);
    }

    public synchronized List<ChestEntry> search(String query) {
        String q = query.toLowerCase();
        ArrayList<ChestEntry> res = new ArrayList<ChestEntry>();
        for (ChestEntry e : this.entries) {
            boolean matched = false;
            if (e.serverIp != null && e.serverIp.toLowerCase().contains(q)) {
                matched = true;
            }
            if (e.dimension != null && e.dimension.toLowerCase().contains(q)) {
                matched = true;
            }
            for (ChestEntry.ItemEntry item : e.items) {
                if (item.itemId != null && item.itemId.toLowerCase().contains(q)) {
                    matched = true;
                }
                if (item.displayName != null && item.displayName.toLowerCase().contains(q)) {
                    matched = true;
                }
                if (!matched && item.nbt != null && item.nbt.toString().toLowerCase().contains(q)) {
                    matched = true;
                }
                if (!matched && item.enchantments != null) {
                    for (String en : item.enchantments) {
                        if (en == null || !en.toLowerCase().contains(q)) continue;
                        matched = true;
                        break;
                    }
                }
                if (!matched && item.potionEffects != null) {
                    for (String pe : item.potionEffects) {
                        if (pe == null || !pe.toLowerCase().contains(q)) continue;
                        matched = true;
                        break;
                    }
                }
                if (matched || item.primaryPotion == null || !item.primaryPotion.toLowerCase().contains(q)) continue;
                matched = true;
            }
            if (!matched) continue;
            res.add(e);
        }
        return res;
    }

    private boolean equalsPos(ChestEntry a, ChestEntry b) {
        boolean boundsEqual;
        if (a == null || b == null) {
            return false;
        }
        int aMinX = Math.min(a.x, a.maxX);
        int aMinY = Math.min(a.y, a.maxY);
        int aMinZ = Math.min(a.z, a.maxZ);
        int aMaxX = Math.max(a.x, a.maxX);
        int aMaxY = Math.max(a.y, a.maxY);
        int aMaxZ = Math.max(a.z, a.maxZ);
        int bMinX = Math.min(b.x, b.maxX);
        int bMinY = Math.min(b.y, b.maxY);
        int bMinZ = Math.min(b.z, b.maxZ);
        int bMaxX = Math.max(b.x, b.maxX);
        int bMaxY = Math.max(b.y, b.maxY);
        int bMaxZ = Math.max(b.z, b.maxZ);
        boolean bl = boundsEqual = aMinX == bMinX && aMinY == bMinY && aMinZ == bMinZ && aMaxX == bMaxX && aMaxY == bMaxY && aMaxZ == bMaxZ;
        return boundsEqual;
    }

    private void finalizeInsert(ChestEntry entry) {
        boolean removed = this.removeOverlappingDuplicates(entry);
        if (removed) {
            System.out.println("[ChestDatabase] cleaned overlapping duplicates after insert.");
        }
        this.save();
    }

    private boolean removeOverlappingDuplicates(ChestEntry reference) {
        String refKey = this.contentsKey(reference);
        if (refKey == null) {
            return false;
        }
        int refMinX = Math.min(reference.x, reference.maxX);
        int refMinY = Math.min(reference.y, reference.maxY);
        int refMinZ = Math.min(reference.z, reference.maxZ);
        int refMaxX = Math.max(reference.x, reference.maxX);
        int refMaxY = Math.max(reference.y, reference.maxY);
        int refMaxZ = Math.max(reference.z, reference.maxZ);
        boolean removed = false;
        Iterator<ChestEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            boolean overlap;
            String otherKey;
            ChestEntry other = it.next();
            if (other == reference || !this.equalsServerDim(other, reference) || (otherKey = this.contentsKey(other)) == null || !refKey.equals(otherKey)) continue;
            int otherMinX = Math.min(other.x, other.maxX);
            int otherMinY = Math.min(other.y, other.maxY);
            int otherMinZ = Math.min(other.z, other.maxZ);
            int otherMaxX = Math.max(other.x, other.maxX);
            int otherMaxY = Math.max(other.y, other.maxY);
            int otherMaxZ = Math.max(other.z, other.maxZ);
            boolean bl = overlap = refMinX <= otherMaxX && refMaxX >= otherMinX && refMinY <= otherMaxY && refMaxY >= otherMinY && refMinZ <= otherMaxZ && refMaxZ >= otherMinZ;
            if (!overlap) continue;
            it.remove();
            System.out.println("[ChestDatabase] removed overlapping duplicate at " + String.valueOf(other.getMinPos()) + " -> " + String.valueOf(other.getMaxPos()));
            removed = true;
        }
        return removed;
    }

    private boolean dedupeLoadedEntries() {
        if (this.entries == null || this.entries.isEmpty()) {
            return false;
        }
        ArrayList<ChestEntry> copy = new ArrayList<ChestEntry>(this.entries);
        this.entries = new ArrayList<ChestEntry>();
        boolean removedAny = false;
        for (ChestEntry entry : copy) {
            if (entry == null) continue;
            entry.ensureBounds();
            this.entries.add(entry);
            if (!this.removeOverlappingDuplicates(entry)) continue;
            removedAny = true;
        }
        return removedAny;
    }

    private boolean equalsServerDim(ChestEntry a, ChestEntry b) {
        return this.equalsServerDim(a, b.serverIp, b.dimension);
    }

    private boolean equalsServerDim(ChestEntry a, String serverIp, String dimension) {
        if (a.serverIp == null && serverIp != null) {
            return false;
        }
        if (a.dimension == null && dimension != null) {
            return false;
        }
        return !(a.serverIp != null && !a.serverIp.equals(serverIp) || a.dimension != null && !a.dimension.equals(dimension));
    }

    public synchronized List<ChestEntry> all() {
        return new ArrayList<ChestEntry>(this.entries);
    }

    private String contentsKey(ChestEntry e) {
        if (e == null || e.items == null) {
            return null;
        }
        HashMap<CallSite, Integer> map = new HashMap<CallSite, Integer>();
        try {
            for (ChestEntry.ItemEntry it : e.items) {
                if (it == null) continue;
                String id = it.itemId == null ? "" : it.itemId;
                String nbt = it.nbt == null ? "" : it.nbt.toString();
                String key = id + "|" + nbt;
                map.put((CallSite)((Object)key), map.getOrDefault(key, 0) + it.count);
            }
            ArrayList<CallSite> parts = new ArrayList<CallSite>();
            for (Map.Entry en : map.entrySet()) {
                parts.add((CallSite)((Object)((String)en.getKey() + ":" + String.valueOf(en.getValue()))));
            }
            Collections.sort(parts);
            return String.join((CharSequence)";", parts);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static File defaultFile() {
        return Paths.get("config", "wurst", "chest_database.json").toFile();
    }
}

