/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.chestsearch;

import com.google.gson.JsonElement;
import java.time.Instant;
import java.util.List;
import net.minecraft.class_2338;

public class ChestEntry {
    public String serverIp;
    public String dimension;
    public int x;
    public int y;
    public int z;
    public int maxX;
    public int maxY;
    public int maxZ;
    public String facing;
    public String lastSeen;
    public List<ItemEntry> items;
    public Integer clickedX;
    public Integer clickedY;
    public Integer clickedZ;

    public ChestEntry() {
    }

    public ChestEntry(String serverIp, String dimension, int x, int y, int z, List<ItemEntry> items) {
        this(serverIp, dimension, x, y, z, items, x, y, z, null);
    }

    public ChestEntry(String serverIp, String dimension, int x, int y, int z, List<ItemEntry> items, int maxX, int maxY, int maxZ, String facing) {
        this.serverIp = serverIp;
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.facing = facing;
        this.items = items;
        this.lastSeen = Instant.now().toString();
    }

    public ChestEntry(String serverIp, String dimension, int x, int y, int z, List<ItemEntry> items, int maxX, int maxY, int maxZ, String facing, Integer clickedX, Integer clickedY, Integer clickedZ) {
        this(serverIp, dimension, x, y, z, items, maxX, maxY, maxZ, facing);
        this.clickedX = clickedX;
        this.clickedY = clickedY;
        this.clickedZ = clickedZ;
    }

    public void ensureBounds() {
        if (this.maxX == 0 && this.maxY == 0 && this.maxZ == 0 && (this.x != 0 || this.y != 0 || this.z != 0)) {
            this.maxX = this.x;
            this.maxY = this.y;
            this.maxZ = this.z;
        } else {
            if (this.maxX < this.x) {
                this.maxX = this.x;
            }
            if (this.maxY < this.y) {
                this.maxY = this.y;
            }
            if (this.maxZ < this.z) {
                this.maxZ = this.z;
            }
        }
    }

    public void touch() {
        this.lastSeen = Instant.now().toString();
    }

    public class_2338 getMinPos() {
        int minX = Math.min(this.x, this.maxX);
        int minY = Math.min(this.y, this.maxY);
        int minZ = Math.min(this.z, this.maxZ);
        return new class_2338(minX, minY, minZ);
    }

    public class_2338 getMaxPos() {
        int maxX = Math.max(this.x, this.maxX);
        int maxY = Math.max(this.y, this.maxY);
        int maxZ = Math.max(this.z, this.maxZ);
        return new class_2338(maxX, maxY, maxZ);
    }

    public class_2338 getClickedPos() {
        if (this.clickedX != null && this.clickedY != null && this.clickedZ != null) {
            return new class_2338(this.clickedX.intValue(), this.clickedY.intValue(), this.clickedZ.intValue());
        }
        return this.getMinPos();
    }

    public static class ItemEntry {
        public int slot;
        public int count;
        public String itemId;
        public String displayName;
        public JsonElement nbt;
        public List<String> enchantments;
        public List<Integer> enchantmentLevels;
        public List<String> potionEffects;
        public String primaryPotion;
    }
}

