/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.chestsearch;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.wurstclient.WurstClient;
import net.wurstclient.chestsearch.ChestConfig;
import net.wurstclient.chestsearch.ChestDatabase;
import net.wurstclient.chestsearch.ChestEntry;

public class ChestManager {
    private static final Map<String, ChestDatabase> DB_CACHE = new ConcurrentHashMap<String, ChestDatabase>();
    private final File baseDir;
    private final ChestConfig config;

    public ChestManager(File storageFile, ChestConfig config) {
        File target = storageFile == null ? ChestDatabase.defaultFile() : storageFile;
        File absolute = target.getAbsoluteFile();
        if (absolute.isDirectory()) {
            this.baseDir = absolute;
        } else {
            File parent;
            String name = absolute.getName();
            if (name.endsWith(".json")) {
                name = name.substring(0, name.length() - 5);
            }
            if ((parent = absolute.getParentFile()) == null) {
                parent = new File(".");
            }
            this.baseDir = new File(parent, name);
        }
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
        }
        this.config = config;
    }

    public ChestManager() {
        this(new ChestConfig());
    }

    public ChestManager(ChestConfig config) {
        this(new File(config.dbPath), config);
    }

    public void upsertChest(String serverIp, String dimension, int x, int y, int z, List<ChestEntry.ItemEntry> items) {
        this.upsertChest(serverIp, dimension, x, y, z, items, x, y, z, null, x, y, z);
    }

    public void upsertChest(String serverIp, String dimension, int x, int y, int z, List<ChestEntry.ItemEntry> items, int maxX, int maxY, int maxZ, String facing) {
        this.upsertChest(serverIp, dimension, x, y, z, items, maxX, maxY, maxZ, facing, x, y, z);
    }

    public void upsertChest(String serverIp, String dimension, int x, int y, int z, List<ChestEntry.ItemEntry> items, int maxX, int maxY, int maxZ, String facing, Integer clickedX, Integer clickedY, Integer clickedZ) {
        if (!this.config.enabled) {
            return;
        }
        ChestEntry entry = new ChestEntry(serverIp, dimension, x, y, z, items, maxX, maxY, maxZ, facing, clickedX, clickedY, clickedZ);
        this.getDb(serverIp).upsert(entry);
    }

    public void removeChest(String serverIp, String dimension, int x, int y, int z) {
        this.getDb(serverIp).removeAt(serverIp, dimension, x, y, z);
    }

    public List<ChestEntry> search(String q) {
        return this.getCurrentDb().search(q == null ? "" : q);
    }

    public List<ChestEntry> all() {
        return this.getCurrentDb().all();
    }

    public ChestConfig getConfig() {
        return this.config;
    }

    public static JsonElement parseNbtJson(String nbtJson) {
        if (nbtJson == null) {
            return null;
        }
        try {
            return JsonParser.parseString((String)nbtJson);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ChestEntry.ItemEntry makeItemEntry(int slot, int count, String itemId, String displayName, JsonElement nbt) {
        ChestEntry.ItemEntry it = new ChestEntry.ItemEntry();
        it.slot = slot;
        it.count = count;
        it.itemId = itemId;
        it.displayName = displayName;
        it.nbt = nbt;
        return it;
    }

    private ChestDatabase getCurrentDb() {
        String serverIp = null;
        try {
            if (WurstClient.MC != null && WurstClient.MC.method_1558() != null) {
                serverIp = WurstClient.MC.method_1558().field_3761;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getDb(serverIp);
    }

    private ChestDatabase getDb(String serverIp) {
        File file = this.resolveFile(serverIp);
        String key = file.getAbsolutePath();
        return DB_CACHE.computeIfAbsent(key, k -> new ChestDatabase(file));
    }

    private File resolveFile(String serverIp) {
        String name = this.sanitizeServer(serverIp);
        return new File(this.baseDir, name + ".json");
    }

    private String sanitizeServer(String serverIp) {
        if (serverIp == null || serverIp.isBlank()) {
            return "singleplayer";
        }
        return serverIp.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9._-]", "_");
    }
}

