/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.wurstclient.Category;
import net.wurstclient.Feature;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGuiIcons;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.KeyboardInput;
import net.wurstclient.clickgui.Popup;
import net.wurstclient.clickgui.SettingsWindow;
import net.wurstclient.clickgui.Window;
import net.wurstclient.clickgui.components.FeatureButton;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.ClickGuiHack;
import net.wurstclient.hacks.TooManyHaxHack;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.json.JsonUtils;
import org.joml.Matrix3x2fStack;

public final class ClickGui {
    private static final WurstClient WURST = WurstClient.INSTANCE;
    private static final class_310 MC = WurstClient.MC;
    private final ArrayList<Window> windows = new ArrayList();
    private final ArrayList<Popup> popups = new ArrayList();
    private final Path windowsFile;
    private float[] bgColor = new float[3];
    private float[] acColor = new float[3];
    private float[] enabledHackColor = new float[3];
    private float[] dropdownButtonColor = new float[3];
    private float[] pinButtonColor = new float[3];
    private int txtColor;
    private float opacity;
    private float ttOpacity;
    private int maxHeight;
    private int maxSettingsHeight;
    private boolean isolateWindows;
    private String tooltip = "";
    private boolean leftMouseButtonPressed;
    private KeyboardInput keyboardInput;

    public ClickGui(Path windowsFile) {
        this.windowsFile = windowsFile;
    }

    public Window findWindowByTitle(String title) {
        for (Window w : this.windows) {
            if (!w.getTitle().equals(title)) continue;
            return w;
        }
        return null;
    }

    public void bringWindowToFront(Window w) {
        if (this.windows.remove(w)) {
            this.windows.add(w);
        }
    }

    public void init() {
        JsonObject json;
        this.windows.clear();
        this.popups.clear();
        this.updateColors();
        LinkedHashMap<Category, Window> windowMap = new LinkedHashMap<Category, Window>();
        for (Category category : Category.values()) {
            windowMap.put(category, new Window(category.getName()));
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.addAll(WURST.getHax().getAllHax());
        features.addAll(WURST.getCmds().getAllCmds());
        features.addAll(WURST.getOtfs().getAllOtfs());
        TooManyHaxHack tooManyHax = ClickGui.WURST.getHax().tooManyHaxHack;
        for (Feature f : features) {
            if (f instanceof Hack && tooManyHax.isEnabled() && tooManyHax.isBlocked(f) && !((Hack)f).isEnabled() || f.getCategory() == null) continue;
            ((Window)windowMap.get((Object)f.getCategory())).add(new FeatureButton(f));
        }
        for (Feature f : features) {
            if (!(f instanceof Hack) || !((Hack)f).isFavorite() || f instanceof Hack && tooManyHax.isEnabled() && tooManyHax.isBlocked(f) && !((Hack)f).isEnabled()) continue;
            ((Window)windowMap.get((Object)Category.FAVORITES)).add(new FeatureButton(f));
        }
        Window favWindow = (Window)windowMap.get((Object)Category.FAVORITES);
        if (favWindow != null) {
            this.sortFavoritesWindow(favWindow);
        }
        this.windows.addAll(windowMap.values());
        Window uiSettings = new Window("UI Settings");
        uiSettings.add(new FeatureButton(ClickGui.WURST.getOtfs().wurstLogoOtf));
        uiSettings.add(new FeatureButton(ClickGui.WURST.getOtfs().hackListOtf));
        uiSettings.add(new FeatureButton(ClickGui.WURST.getOtfs().keybindManagerOtf));
        ClickGuiHack clickGuiHack = ClickGui.WURST.getHax().clickGuiHack;
        uiSettings.add(clickGuiHack.getIsolateWindowsSetting().getComponent());
        Stream<Setting> settings = clickGuiHack.getSettings().values().stream().filter(setting -> setting != clickGuiHack.getIsolateWindowsSetting());
        settings.map(Setting::getComponent).forEach(c -> uiSettings.add((Component)c));
        this.windows.add(uiSettings);
        for (Window window : this.windows) {
            window.setMinimized(true);
        }
        this.windows.add(WurstClient.INSTANCE.getHax().radarHack.getWindow());
        int x = 5;
        int y = 5;
        int scaledWidth = MC.method_22683().method_4486();
        for (Window window : this.windows) {
            window.pack();
            if (window.getTitle().equals("Chest Tools")) {
                window.setMinimized(false);
            }
            if (x + window.getWidth() + 5 > scaledWidth) {
                x = 5;
                y += 18;
            }
            window.setX(x);
            window.setY(y);
            x += window.getWidth() + 5;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.windowsFile);){
            json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (NoSuchFileException e) {
            this.saveWindows();
            return;
        }
        catch (Exception e) {
            System.out.println("Failed to load " + String.valueOf(this.windowsFile.getFileName()));
            e.printStackTrace();
            this.saveWindows();
            return;
        }
        for (Window window : this.windows) {
            JsonElement jsonPinned;
            JsonElement jsonMinimized;
            JsonElement jsonY;
            JsonElement jsonWindow = json.get(window.getTitle());
            if (jsonWindow == null || !jsonWindow.isJsonObject()) continue;
            JsonElement jsonX = jsonWindow.getAsJsonObject().get("x");
            if (jsonX.isJsonPrimitive() && jsonX.getAsJsonPrimitive().isNumber()) {
                window.setX(jsonX.getAsInt());
            }
            if ((jsonY = jsonWindow.getAsJsonObject().get("y")).isJsonPrimitive() && jsonY.getAsJsonPrimitive().isNumber()) {
                window.setY(jsonY.getAsInt());
            }
            if ((jsonMinimized = jsonWindow.getAsJsonObject().get("minimized")).isJsonPrimitive() && jsonMinimized.getAsJsonPrimitive().isBoolean()) {
                window.setMinimized(jsonMinimized.getAsBoolean());
            }
            if (!(jsonPinned = jsonWindow.getAsJsonObject().get("pinned")).isJsonPrimitive() || !jsonPinned.getAsJsonPrimitive().isBoolean()) continue;
            window.setPinned(jsonPinned.getAsBoolean());
        }
        this.saveWindows();
    }

    private void saveWindows() {
        JsonObject json = new JsonObject();
        for (Window window : this.windows) {
            if (window.isClosable()) continue;
            JsonObject jsonWindow = new JsonObject();
            jsonWindow.addProperty("x", (Number)window.getActualX());
            jsonWindow.addProperty("y", (Number)window.getActualY());
            jsonWindow.addProperty("minimized", Boolean.valueOf(window.isMinimized()));
            jsonWindow.addProperty("pinned", Boolean.valueOf(window.isPinned()));
            json.add(window.getTitle(), (JsonElement)jsonWindow);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.windowsFile, new OpenOption[0]);){
            JsonUtils.PRETTY_GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            System.out.println("Failed to save " + String.valueOf(this.windowsFile.getFileName()));
            e.printStackTrace();
        }
    }

    public void handleMouseClick(class_11909 context) {
        boolean closedPopups;
        boolean popupClicked;
        int mouseX = (int)context.comp_4798();
        int mouseY = (int)context.comp_4799();
        int mouseButton = context.method_74245();
        if (mouseButton == 0) {
            this.leftMouseButtonPressed = true;
        }
        if (!(popupClicked = this.handlePopupMouseClick(mouseX, mouseY, mouseButton)) && !(closedPopups = this.closeActivePopups())) {
            this.handleWindowMouseClick(mouseX, mouseY, mouseButton, context);
        }
        for (Popup popup : this.popups) {
            Window parent = popup.getOwner().getParent();
            if (parent == null || !parent.isClosing()) continue;
            popup.close();
        }
        this.windows.removeIf(Window::isClosing);
        this.popups.removeIf(Popup::isClosing);
    }

    private boolean closeActivePopups() {
        if (this.popups.isEmpty()) {
            return false;
        }
        for (Popup popup : this.popups) {
            popup.close();
        }
        return true;
    }

    public void handleMouseRelease(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.leftMouseButtonPressed = false;
        }
    }

    public void handleMouseScroll(double mouseX, double mouseY, double delta) {
        if (delta == 0.0) {
            return;
        }
        if (this.handlePopupMouseScroll(mouseX, mouseY, delta)) {
            return;
        }
        int dWheel = (int)delta * 4;
        if (dWheel == 0) {
            return;
        }
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window window = this.windows.get(i);
            if (!window.isScrollingEnabled() || window.isMinimized() || window.isInvisible() || mouseX < (double)window.getX() || mouseY < (double)(window.getY() + 13) || mouseX >= (double)(window.getX() + window.getWidth()) || mouseY >= (double)(window.getY() + window.getHeight())) continue;
            int scroll = window.getScrollOffset() + dWheel;
            scroll = Math.min(scroll, 0);
            scroll = Math.max(scroll, -window.getInnerHeight() + window.getHeight() - 13);
            window.setScrollOffset(scroll);
            break;
        }
    }

    public boolean handleNavigatorPopupClick(double mouseX, double mouseY, int mouseButton) {
        boolean popupClicked = this.handlePopupMouseClick(mouseX, mouseY, mouseButton);
        if (popupClicked) {
            for (Popup popup : this.popups) {
                if (!popup.getOwner().getParent().isClosing()) continue;
                popup.close();
            }
            this.popups.removeIf(Popup::isClosing);
        }
        return popupClicked;
    }

    public boolean handleNavigatorMouseScroll(double mouseX, double mouseY, double delta) {
        boolean popupScrolled = this.handlePopupMouseScroll(mouseX, mouseY, delta);
        if (popupScrolled) {
            for (Popup popup : this.popups) {
                if (!popup.getOwner().getParent().isClosing()) continue;
                popup.close();
            }
            this.popups.removeIf(Popup::isClosing);
        }
        return popupScrolled;
    }

    public boolean handleKeyPressed(class_11908 context) {
        if (this.keyboardInput != null && this.keyboardInput.onKeyPressed(context)) {
            return true;
        }
        if (context.comp_4795() == 256 && this.keyboardInput != null) {
            this.clearKeyboardInput();
            return true;
        }
        return false;
    }

    public boolean handleCharTyped(class_11905 event) {
        return this.keyboardInput != null && this.keyboardInput.onCharTyped(event);
    }

    public void requestKeyboardInput(KeyboardInput handler) {
        if (handler == null || this.keyboardInput == handler) {
            return;
        }
        if (this.keyboardInput != null) {
            this.clearKeyboardInput();
        }
        this.keyboardInput = handler;
    }

    public void releaseKeyboardInput(KeyboardInput handler) {
        if (handler != null && this.keyboardInput == handler) {
            this.keyboardInput = null;
        }
    }

    public void clearKeyboardInput() {
        if (this.keyboardInput == null) {
            return;
        }
        KeyboardInput handler = this.keyboardInput;
        this.keyboardInput = null;
        handler.onKeyboardFocusLost();
    }

    public boolean isKeyboardInputCaptured() {
        return this.keyboardInput != null;
    }

    public void handleNavigatorMouseClick(double cMouseX, double cMouseY, int mouseButton, Window window, class_11909 context) {
        if (mouseButton == 0) {
            this.leftMouseButtonPressed = true;
        }
        this.handleComponentMouseClick(window, cMouseX, cMouseY, mouseButton, context);
        for (Popup popup : this.popups) {
            Window parent = popup.getOwner().getParent();
            if (parent == null || !parent.isClosing()) continue;
            popup.close();
        }
        this.popups.removeIf(Popup::isClosing);
    }

    private boolean handlePopupMouseClick(double mouseX, double mouseY, int mouseButton) {
        for (int i = this.popups.size() - 1; i >= 0; --i) {
            Popup popup = this.popups.get(i);
            Component owner = popup.getOwner();
            Window parent = owner.getParent();
            if (parent == null) continue;
            int x0 = parent.getX() + owner.getX();
            int y0 = parent.getY() + 13 + parent.getScrollOffset() + owner.getY();
            int x1 = x0 + popup.getX();
            int y1 = y0 + popup.getY();
            int x2 = x1 + popup.getWidth();
            int y2 = y1 + popup.getHeight();
            if (mouseX < (double)x1 || mouseY < (double)y1 || mouseX >= (double)x2 || mouseY >= (double)y2) continue;
            int cMouseX = (int)(mouseX - (double)x0);
            int cMouseY = (int)(mouseY - (double)y0);
            popup.handleMouseClick(cMouseX, cMouseY, mouseButton);
            this.popups.remove(popup);
            this.popups.add(popup);
            return true;
        }
        return false;
    }

    private boolean handlePopupMouseScroll(double mouseX, double mouseY, double delta) {
        for (int i = this.popups.size() - 1; i >= 0; --i) {
            int cMouseY;
            int cMouseX;
            Component owner;
            Window parent;
            Popup popup = this.popups.get(i);
            if (popup.getWidth() <= 0 || popup.getHeight() <= 0 || (parent = (owner = popup.getOwner()).getParent()) == null) continue;
            int x0 = parent.getX() + owner.getX();
            int y0 = parent.getY() + 13 + parent.getScrollOffset() + owner.getY();
            int x1 = x0 + popup.getX();
            int y1 = y0 + popup.getY();
            int x2 = x1 + popup.getWidth();
            int y2 = y1 + popup.getHeight();
            if (mouseX < (double)x1 || mouseY < (double)y1 || mouseX >= (double)x2 || mouseY >= (double)y2 || !popup.handleMouseScroll(cMouseX = (int)(mouseX - (double)x0), cMouseY = (int)(mouseY - (double)y0), delta)) continue;
            return true;
        }
        return false;
    }

    private void handleWindowMouseClick(int mouseX, int mouseY, int mouseButton, class_11909 context) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window window = this.windows.get(i);
            if (window.isInvisible()) continue;
            int x1 = window.getX();
            int y1 = window.getY();
            int x2 = x1 + window.getWidth();
            int y2 = y1 + window.getHeight();
            int y3 = y1 + 13;
            if (mouseX < x1 || mouseY < y1 || mouseX >= x2 || mouseY >= y2) continue;
            if (mouseY < y3) {
                this.handleTitleBarMouseClick(window, mouseX, mouseY, mouseButton);
            } else {
                if (window.isMinimized()) continue;
                window.validate();
                int cMouseX = mouseX - x1;
                int cMouseY = mouseY - y3;
                if (window.isScrollingEnabled() && mouseX >= x2 - 3) {
                    this.handleScrollbarMouseClick(window, cMouseX, cMouseY, mouseButton);
                } else {
                    if (window.isScrollingEnabled()) {
                        cMouseY -= window.getScrollOffset();
                    }
                    this.handleComponentMouseClick(window, cMouseX, cMouseY, mouseButton, context);
                }
            }
            if (!this.windows.contains(window)) break;
            this.windows.remove(window);
            this.windows.add(window);
            break;
        }
    }

    private void handleTitleBarMouseClick(Window window, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        if (mouseY < window.getY() + 2 || mouseY >= window.getY() + 11) {
            window.startDragging(mouseX, mouseY);
            return;
        }
        int x3 = window.getX() + window.getWidth();
        if (window.isClosable() && mouseX >= (x3 -= 11) && mouseX < x3 + 9) {
            window.close();
            return;
        }
        if (window.isPinnable() && mouseX >= (x3 -= 11) && mouseX < x3 + 9) {
            window.setPinned(!window.isPinned());
            this.saveWindows();
            return;
        }
        if (window.isMinimizable() && mouseX >= (x3 -= 11) && mouseX < x3 + 9) {
            window.setMinimized(!window.isMinimized());
            this.saveWindows();
            return;
        }
        window.startDragging(mouseX, mouseY);
    }

    private void handleScrollbarMouseClick(Window window, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        if (mouseX >= window.getWidth() - 1) {
            return;
        }
        double outerHeight = window.getHeight() - 13;
        double innerHeight = window.getInnerHeight();
        double maxScrollbarHeight = outerHeight - 2.0;
        int scrollbarY = (int)(outerHeight * ((double)(-window.getScrollOffset()) / innerHeight) + 1.0);
        int scrollbarHeight = (int)(maxScrollbarHeight * outerHeight / innerHeight);
        if (mouseY < scrollbarY || mouseY >= scrollbarY + scrollbarHeight) {
            return;
        }
        window.startDraggingScrollbar(window.getY() + 13 + mouseY);
    }

    private void handleComponentMouseClick(Window window, double mouseX, double mouseY, int mouseButton, class_11909 context) {
        for (int i2 = window.countChildren() - 1; i2 >= 0; --i2) {
            Component c = window.getChild(i2);
            if (mouseX < (double)c.getX() || mouseY < (double)c.getY() || mouseX >= (double)(c.getX() + c.getWidth()) || mouseY >= (double)(c.getY() + c.getHeight())) continue;
            if (this.keyboardInput != null && this.keyboardInput != c) {
                this.clearKeyboardInput();
            }
            c.handleMouseClick(mouseX, mouseY, mouseButton, context);
            break;
        }
    }

    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        this.updateColors();
        Matrix3x2fStack matrixStack = context.method_51448();
        matrixStack.pushMatrix();
        this.tooltip = "";
        ArrayList<Window> visibleWindows = new ArrayList<Window>();
        for (Window window : this.windows) {
            if (window.isInvisible()) continue;
            if (window.isDragging()) {
                if (this.leftMouseButtonPressed) {
                    window.dragTo(mouseX, mouseY);
                } else {
                    window.stopDragging();
                    this.saveWindows();
                }
            }
            if (window.isDraggingScrollbar()) {
                if (this.leftMouseButtonPressed) {
                    window.dragScrollbarTo(mouseY);
                } else {
                    window.stopDraggingScrollbar();
                }
            }
            visibleWindows.add(window);
        }
        if (this.isolateWindows && !visibleWindows.isEmpty()) {
            this.renderWindowsWithIsolation(context, visibleWindows, mouseX, mouseY, partialTicks);
        } else {
            for (Window window : visibleWindows) {
                context.field_59826.method_71067();
                this.renderWindow(context, window, mouseX, mouseY, partialTicks);
            }
        }
        this.renderPopups(context, mouseX, mouseY);
        this.renderTooltip(context, mouseX, mouseY);
        matrixStack.popMatrix();
    }

    public void renderPopups(class_332 context, int mouseX, int mouseY) {
        Matrix3x2fStack matrixStack = context.method_51448();
        for (Popup popup : this.popups) {
            Component owner = popup.getOwner();
            Window parent = owner.getParent();
            if (parent == null) continue;
            int x1 = parent.getX() + owner.getX();
            int y1 = parent.getY() + 13 + parent.getScrollOffset() + owner.getY();
            matrixStack.pushMatrix();
            matrixStack.translate((float)x1, (float)y1);
            context.field_59826.method_71067();
            int cMouseX = mouseX - x1;
            int cMouseY = mouseY - y1;
            popup.render(context, cMouseX, cMouseY);
            matrixStack.popMatrix();
        }
    }

    public void renderTooltip(class_332 context, int mouseX, int mouseY) {
        if (this.tooltip.isEmpty()) {
            return;
        }
        String[] lines = this.tooltip.split("\n");
        class_327 tr = ClickGui.MC.field_1772;
        int tw = 0;
        int n = lines.length;
        Objects.requireNonNull(tr);
        int th = n * 9;
        for (String line : lines) {
            int lw = tr.method_1727(line);
            if (lw <= tw) continue;
            tw = lw;
        }
        int sw = ClickGui.MC.field_1755.field_22789;
        int sh = ClickGui.MC.field_1755.field_22790;
        int xt1 = mouseX + tw + 11 <= sw ? mouseX + 8 : mouseX - tw - 8;
        int xt2 = xt1 + tw + 3;
        int yt1 = mouseY + th - 2 <= sh ? mouseY - 4 : mouseY - th - 4;
        int yt2 = yt1 + th + 2;
        context.field_59826.method_71067();
        context.method_25294(xt1, yt1, xt2, yt2, RenderUtils.toIntColor(this.bgColor, this.ttOpacity));
        RenderUtils.drawBorder2D(context, xt1, yt1, xt2, yt2, RenderUtils.toIntColor(this.acColor, 0.5f));
        context.field_59826.method_71067();
        for (int i = 0; i < lines.length; ++i) {
            String string = lines[i];
            Objects.requireNonNull(tr);
            context.method_51433(tr, string, xt1 + 2, yt1 + 2 + i * 9, this.txtColor, false);
        }
    }

    public void renderPinnedWindows(class_332 context, float partialTicks) {
        ArrayList<Window> pinnedWindows = new ArrayList<Window>();
        for (Window window : this.windows) {
            if (!window.isPinned() || window.isInvisible()) continue;
            pinnedWindows.add(window);
        }
        if (pinnedWindows.isEmpty()) {
            return;
        }
        if (this.isolateWindows) {
            this.renderWindowsWithIsolation(context, pinnedWindows, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
        } else {
            for (Window window : pinnedWindows) {
                context.field_59826.method_71067();
                this.renderWindow(context, window, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            }
        }
    }

    public void updateColors() {
        ClickGuiHack clickGui = ClickGui.WURST.getHax().clickGuiHack;
        this.opacity = clickGui.getOpacity();
        this.ttOpacity = clickGui.getTooltipOpacity();
        this.bgColor = clickGui.getBackgroundColor();
        this.txtColor = clickGui.getTextColor();
        this.enabledHackColor = clickGui.getEnabledHackColor();
        this.dropdownButtonColor = clickGui.getDropdownButtonColor();
        this.pinButtonColor = clickGui.getPinButtonColor();
        this.isolateWindows = clickGui.isWindowIsolationEnabled();
        this.maxHeight = clickGui.getMaxHeight();
        this.maxSettingsHeight = clickGui.getMaxSettingsHeight();
        this.acColor = WurstClient.INSTANCE.getHax().rainbowUiHack.isEnabled() ? RenderUtils.getRainbowColor() : clickGui.getAccentColor();
    }

    private void renderWindow(class_332 context, Window window, int mouseX, int mouseY, float partialTicks) {
        boolean hovering;
        int x4;
        boolean hoveringY;
        int x3;
        int x1 = window.getX();
        int y1 = window.getY();
        int x2 = x1 + window.getWidth();
        int y2 = y1 + window.getHeight();
        int y3 = y1 + 13;
        int windowBgColor = RenderUtils.toIntColor(this.bgColor, this.opacity);
        int outlineColor = RenderUtils.toIntColor(this.acColor, 0.5f);
        Matrix3x2fStack matrixStack = context.method_51448();
        if (window.isMinimized()) {
            y2 = y3;
        }
        if (mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2) {
            this.tooltip = "";
        }
        if (!window.isMinimized()) {
            int yc1;
            window.setMaxHeight(window instanceof SettingsWindow ? this.maxSettingsHeight : this.maxHeight);
            window.validate();
            if (window.isScrollingEnabled()) {
                int xs1 = x2 - 3;
                int xs2 = xs1 + 2;
                int xs3 = x2;
                double outerHeight = y2 - y3;
                double innerHeight = window.getInnerHeight();
                double maxScrollbarHeight = outerHeight - 2.0;
                double scrollbarY = outerHeight * ((double)(-window.getScrollOffset()) / innerHeight) + 1.0;
                double scrollbarHeight = maxScrollbarHeight * outerHeight / innerHeight;
                int ys1 = y3;
                int ys2 = y2;
                int ys3 = ys1 + (int)scrollbarY;
                int ys4 = ys3 + (int)scrollbarHeight;
                context.method_25294(xs2, ys1, xs3, ys2, windowBgColor);
                context.method_25294(xs1, ys1, xs2, ys3, windowBgColor);
                context.method_25294(xs1, ys4, xs2, ys2, windowBgColor);
                boolean hovering2 = mouseX >= xs1 && mouseY >= ys3 && mouseX < xs2 && mouseY < ys4;
                int scrollbarColor = RenderUtils.toIntColor(this.acColor, hovering2 ? this.opacity * 1.5f : this.opacity);
                context.method_25294(xs1, ys3, xs2, ys4, scrollbarColor);
                RenderUtils.drawBorder2D(context, xs1, ys3, xs2, ys4, outlineColor);
            }
            x3 = x1 + 2;
            int x42 = window.isScrollingEnabled() ? x2 - 3 : x2;
            int x5 = x42 - 2;
            int y4 = y3 + window.getScrollOffset();
            context.method_25294(x1, y3, x3, y2, windowBgColor);
            context.method_25294(x5, y3, x42, y2, windowBgColor);
            context.method_44379(x1, y3, x2, y2);
            matrixStack.pushMatrix();
            matrixStack.translate((float)x1, (float)y4);
            int xc1 = 2;
            int xc2 = x5 - x1;
            for (int i = 0; i < window.countChildren(); ++i) {
                int yc12 = window.getChild(i).getY();
                int yc2 = yc12 - 2;
                context.method_25294(xc1, yc2, xc2, yc12, windowBgColor);
            }
            if (window.countChildren() == 0) {
                yc1 = 0;
            } else {
                Component lastChild = window.getChild(window.countChildren() - 1);
                yc1 = lastChild.getY() + lastChild.getHeight();
            }
            int yc2 = yc1 + 2;
            context.method_25294(xc1, yc2, xc2, yc1, windowBgColor);
            int cMouseX = mouseX - x1;
            int cMouseY = mouseY - y4;
            for (int i = 0; i < window.countChildren(); ++i) {
                window.getChild(i).render(context, cMouseX, cMouseY, partialTicks);
            }
            matrixStack.popMatrix();
            context.method_44380();
        }
        RenderUtils.drawBorder2D(context, x1, y1, x2, y2, outlineColor);
        if (!window.isMinimized()) {
            RenderUtils.drawLine2D(context, x1, y3, x2, y3, outlineColor);
        }
        x3 = x2;
        int y4 = y1 + 2;
        int y5 = y3 - 2;
        boolean bl = hoveringY = mouseY >= y4 && mouseY < y5;
        if (window.isClosable()) {
            x4 = (x3 -= 11) + 9;
            hovering = hoveringY && mouseX >= x3 && mouseX < x4;
            this.renderTitleBarButton(context, x3, y4, x4, y5, hovering);
            ClickGuiIcons.drawCross(context, x3, y4, x4, y5, hovering);
        }
        if (window.isPinnable()) {
            x4 = (x3 -= 11) + 9;
            hovering = hoveringY && mouseX >= x3 && mouseX < x4;
            this.renderTitleBarButton(context, x3, y4, x4, y5, hovering);
            ClickGuiIcons.drawPin(context, x3, y4, x4, y5, hovering, window.isPinned());
        }
        if (window.isMinimizable()) {
            x4 = (x3 -= 11) + 9;
            hovering = hoveringY && mouseX >= x3 && mouseX < x4;
            this.renderTitleBarButton(context, x3, y4, x4, y5, hovering);
            ClickGuiIcons.drawMinimizeArrow(context, x3, y4, x4, y5, hovering, window.isMinimized());
        }
        int titleBgColor = RenderUtils.toIntColor(this.acColor, this.opacity);
        context.method_25294(x3, y1, x2, y4, titleBgColor);
        context.method_25294(x3, y5, x2, y3, titleBgColor);
        context.method_25294(x1, y1, x3, y3, titleBgColor);
        class_327 tr = ClickGui.MC.field_1772;
        String title = tr.method_1714((class_5348)class_2561.method_43470((String)window.getTitle()), x3 - x1).getString();
        context.field_59826.method_71067();
        context.method_51433(tr, title, x1 + 2, y1 + 3, this.txtColor, false);
    }

    private void renderTitleBarButton(class_332 context, int x1, int y1, int x2, int y2, boolean hovering) {
        int x3 = x2 + 2;
        int buttonBgColor = RenderUtils.toIntColor(this.bgColor, hovering ? this.opacity * 1.5f : this.opacity);
        context.method_25294(x1, y1, x2, y2, buttonBgColor);
        int windowBgColor = RenderUtils.toIntColor(this.acColor, this.opacity);
        context.method_25294(x2, y1, x3, y2, windowBgColor);
        int outlineColor = RenderUtils.toIntColor(this.acColor, 0.5f);
        RenderUtils.drawBorder2D(context, x1, y1, x2, y2, outlineColor);
    }

    public float[] getBgColor() {
        return this.bgColor;
    }

    public float[] getAcColor() {
        return this.acColor;
    }

    public float[] getEnabledHackColor() {
        return this.enabledHackColor;
    }

    public int getTxtColor() {
        return this.txtColor;
    }

    public float[] getDropdownButtonColor() {
        return this.dropdownButtonColor;
    }

    public float[] getPinButtonColor() {
        return this.pinButtonColor;
    }

    public boolean isWindowIsolationEnabled() {
        return this.isolateWindows;
    }

    private void renderWindowsWithIsolation(class_332 context, List<Window> windowsToRender, int mouseX, int mouseY, float partialTicks) {
        List<List<Rect>> occlusionMasks = this.buildOcclusionMasks(windowsToRender);
        for (int i = 0; i < windowsToRender.size(); ++i) {
            Window window = windowsToRender.get(i);
            List<Rect> visibleAreas = this.computeVisibleAreas(window, occlusionMasks.get(i));
            if (visibleAreas.isEmpty()) continue;
            for (Rect rect : visibleAreas) {
                context.method_44379(rect.x1, rect.y1, rect.x2, rect.y2);
                context.field_59826.method_71067();
                this.renderWindow(context, window, mouseX, mouseY, partialTicks);
                context.method_44380();
            }
        }
    }

    private List<List<Rect>> buildOcclusionMasks(List<Window> windowsToRender) {
        ArrayList<List<Rect>> masks = new ArrayList<List<Rect>>(windowsToRender.size());
        for (int i = 0; i < windowsToRender.size(); ++i) {
            masks.add(new ArrayList());
        }
        ArrayList<Rect> accumulated = new ArrayList<Rect>();
        for (int i = windowsToRender.size() - 1; i >= 0; --i) {
            ArrayList<Rect> copy = new ArrayList<Rect>(accumulated.size());
            for (Rect rect : accumulated) {
                copy.add(rect.copy());
            }
            masks.set(i, copy);
            accumulated.add(Rect.fromWindow(windowsToRender.get(i)));
        }
        return masks;
    }

    private List<Rect> computeVisibleAreas(Window window, List<Rect> occluders) {
        ArrayList<Rect> visible = new ArrayList<Rect>();
        visible.add(Rect.fromWindow(window));
        for (Rect occluder : occluders) {
            visible = this.subtractRectangles(visible, occluder);
        }
        return visible;
    }

    private ArrayList<Rect> subtractRectangles(List<Rect> source, Rect occluder) {
        ArrayList<Rect> result = new ArrayList<Rect>();
        for (Rect rect : source) {
            result.addAll(rect.subtract(occluder));
        }
        return result;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public float getTooltipOpacity() {
        return this.ttOpacity;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = Objects.requireNonNull(tooltip);
    }

    public void addWindow(Window window) {
        this.windows.add(window);
    }

    public void addPopup(Popup popup) {
        this.popups.add(popup);
    }

    public void addFavoriteFeature(Feature feature) {
        String favTitle = Category.FAVORITES.getName();
        for (Window window : this.windows) {
            if (!window.getTitle().equals(favTitle)) continue;
            for (int i = 0; i < window.countChildren(); ++i) {
                FeatureButton fb;
                Component c = window.getChild(i);
                if (!(c instanceof FeatureButton) || !(fb = (FeatureButton)c).getFeature().getName().equals(feature.getName())) continue;
                return;
            }
            window.add(new FeatureButton(feature));
            this.sortFavoritesWindow(window);
            return;
        }
    }

    public void removeFavoriteFeature(Feature feature) {
        String favTitle = Category.FAVORITES.getName();
        for (Window window : this.windows) {
            if (!window.getTitle().equals(favTitle)) continue;
            for (int i = window.countChildren() - 1; i >= 0; --i) {
                FeatureButton fb;
                Component c = window.getChild(i);
                if (!(c instanceof FeatureButton) || !(fb = (FeatureButton)c).getFeature().getName().equals(feature.getName())) continue;
                window.remove(i);
                window.pack();
                return;
            }
        }
    }

    public boolean isLeftMouseButtonPressed() {
        return this.leftMouseButtonPressed;
    }

    private void sortFavoritesWindow(Window window) {
        int i;
        if (window == null) {
            return;
        }
        ArrayList<Component> all = new ArrayList<Component>();
        for (i = 0; i < window.countChildren(); ++i) {
            all.add(window.getChild(i));
        }
        all.sort((c1, c2) -> {
            String n1 = c1 instanceof FeatureButton ? ((FeatureButton)c1).getFeature().getName() : c1.getClass().getName();
            String n2 = c2 instanceof FeatureButton ? ((FeatureButton)c2).getFeature().getName() : c2.getClass().getName();
            return n1.compareToIgnoreCase(n2);
        });
        for (i = window.countChildren() - 1; i >= 0; --i) {
            window.remove(i);
        }
        for (Component c : all) {
            window.add(c);
        }
        window.pack();
    }

    private static final class Rect {
        final int x1;
        final int y1;
        final int x2;
        final int y2;

        Rect(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        static Rect fromWindow(Window window) {
            int x1 = window.getX();
            int y1 = window.getY();
            int width = window.getWidth();
            int height = window.isMinimized() ? 13 : window.getHeight();
            return new Rect(x1, y1, x1 + width, y1 + height);
        }

        Rect copy() {
            return new Rect(this.x1, this.y1, this.x2, this.y2);
        }

        List<Rect> subtract(Rect other) {
            ArrayList<Rect> pieces = new ArrayList<Rect>();
            if (!this.intersects(other)) {
                pieces.add(this);
                return pieces;
            }
            int ox1 = Math.max(this.x1, other.x1);
            int oy1 = Math.max(this.y1, other.y1);
            int ox2 = Math.min(this.x2, other.x2);
            int oy2 = Math.min(this.y2, other.y2);
            if (oy1 > this.y1) {
                pieces.add(new Rect(this.x1, this.y1, this.x2, oy1));
            }
            if (oy2 < this.y2) {
                pieces.add(new Rect(this.x1, oy2, this.x2, this.y2));
            }
            if (oy1 < oy2) {
                if (ox1 > this.x1) {
                    pieces.add(new Rect(this.x1, oy1, ox1, oy2));
                }
                if (ox2 < this.x2) {
                    pieces.add(new Rect(ox2, oy1, this.x2, oy2));
                }
            }
            return pieces;
        }

        private boolean intersects(Rect other) {
            return this.x1 < other.x2 && this.x2 > other.x1 && this.y1 < other.y2 && this.y2 > other.y1;
        }
    }
}

