/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui;

import net.minecraft.class_327;
import net.minecraft.class_332;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.Popup;
import net.wurstclient.settings.StringDropdownSetting;
import net.wurstclient.util.RenderUtils;

public final class StringDropdownPopup
extends Popup {
    private static final ClickGui GUI = WurstClient.INSTANCE.getGui();
    private static final class_327 TR = WurstClient.MC.field_1772;
    private static final int ROW_HEIGHT = 11;
    private static final int MAX_VISIBLE_ROWS = 8;
    private final StringDropdownSetting setting;
    private final int popupWidth;
    private final int totalRows;
    private final int visibleRows;
    private int scrollOffset;

    public StringDropdownPopup(Component owner, StringDropdownSetting setting, int popupWidth) {
        super(owner);
        this.setting = setting;
        this.popupWidth = popupWidth;
        this.totalRows = Math.max(0, setting.getValues().size() - 1);
        this.visibleRows = Math.min(8, this.totalRows);
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
        this.setX(owner.getWidth() - this.getWidth());
        this.setY(owner.getHeight());
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0 || this.visibleRows <= 0) {
            return;
        }
        int localX = mouseX - this.getX();
        int localY = mouseY - this.getY();
        if (localX < 0 || localX >= this.getWidth() || localY < 0 || localY >= this.getHeight()) {
            return;
        }
        int row = localY / 11;
        String value = this.getValueAt(row + this.scrollOffset);
        if (value == null) {
            return;
        }
        this.setting.setSelected(value);
        this.close();
    }

    @Override
    public boolean handleMouseScroll(int mouseX, int mouseY, double delta) {
        if (this.totalRows <= this.visibleRows || this.visibleRows <= 0) {
            return false;
        }
        int direction = (int)Math.signum(delta);
        if (direction == 0) {
            return false;
        }
        this.scrollOffset -= direction;
        this.clampScroll();
        return true;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        if (this.visibleRows <= 0) {
            return;
        }
        this.clampScroll();
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int y1 = this.getY();
        int y2 = y1 + this.getHeight();
        boolean hovering = this.isHovering(mouseX, mouseY, x1, x2, y1, y2);
        if (hovering) {
            GUI.setTooltip("");
        }
        RenderUtils.drawBorder2D(context, x1, y1, x2, y2, RenderUtils.toIntColor(GUI.getAcColor(), 0.5f));
        int drawn = 0;
        int skipped = 0;
        for (String value : this.setting.getValues()) {
            if (value.equals(this.setting.getSelected()) || skipped++ < this.scrollOffset) continue;
            if (drawn >= this.visibleRows) break;
            int yi1 = y1 + drawn * 11;
            int yi2 = yi1 + 11;
            boolean hValue = hovering && mouseY >= yi1 && mouseY < yi2;
            context.method_25294(x1, yi1, x2, yi2, RenderUtils.toIntColor(GUI.getBgColor(), GUI.getOpacity() * (hValue ? 1.5f : 1.0f)));
            context.field_59826.method_71067();
            context.method_51433(TR, value, x1 + 2, yi1 + 2, GUI.getTxtColor(), false);
            ++drawn;
        }
    }

    private void clampScroll() {
        int maxOffset = Math.max(0, this.totalRows - this.visibleRows);
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        } else if (this.scrollOffset > maxOffset) {
            this.scrollOffset = maxOffset;
        }
    }

    private String getValueAt(int index) {
        if (index < 0) {
            return null;
        }
        int skipped = 0;
        for (String value : this.setting.getValues()) {
            if (value.equals(this.setting.getSelected())) continue;
            if (skipped == index) {
                return value;
            }
            ++skipped;
        }
        return null;
    }

    private boolean isHovering(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        return mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2;
    }

    @Override
    public int getDefaultWidth() {
        return this.popupWidth + 15;
    }

    @Override
    public int getDefaultHeight() {
        return this.visibleRows * 11;
    }
}

