/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import java.util.ArrayList;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.ClickGuiIcons;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.Window;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SettingGroup;
import net.wurstclient.util.RenderUtils;

public final class SettingGroupComponent
extends Component {
    private static final int HEADER_HEIGHT = 13;
    private final SettingGroup group;
    private final ArrayList<Component> childComponents = new ArrayList();
    private final boolean popoutEnabled;
    private boolean expanded;

    public SettingGroupComponent(SettingGroup group) {
        this(group, true);
    }

    public SettingGroupComponent(SettingGroup group, boolean allowPopout) {
        this.group = group;
        this.popoutEnabled = allowPopout && group.isPopout();
        this.expanded = group.isDefaultExpanded();
        this.rebuildChildren();
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    private void rebuildChildren() {
        this.childComponents.clear();
        for (Setting child : this.group.getChildren()) {
            Component comp = child.getComponent();
            if (comp == null) continue;
            comp.setWidth(comp.getDefaultWidth());
            comp.setHeight(comp.getDefaultHeight());
            if (this.getParent() != null) {
                comp.setParent(this.getParent());
            }
            this.childComponents.add(comp);
        }
        this.updateHeight();
    }

    private void updateHeight() {
        int height = 13;
        if (this.expanded) {
            for (Component child : this.childComponents) {
                height += child.getHeight() + 2;
            }
        }
        this.setHeight(height);
    }

    private boolean togglePopoutWindow() {
        if (!this.popoutEnabled) {
            return false;
        }
        ClickGui gui = WURST.getGui();
        Window existing = gui.findWindowByTitle(this.group.getName());
        if (existing != null) {
            existing.close();
            return true;
        }
        Window parent = this.getParent();
        if (parent == null) {
            return false;
        }
        Window popupWin = new Window(this.group.getName());
        for (Setting s : this.group.getChildren()) {
            Component c = s.getComponent();
            if (c == null) continue;
            c.setWidth(c.getDefaultWidth());
            c.setHeight(c.getDefaultHeight());
            popupWin.add(c);
        }
        popupWin.pack();
        popupWin.setPinnable(true);
        popupWin.setClosable(true);
        popupWin.setX(parent.getX() + this.getX() + this.getWidth() + 5);
        popupWin.setY(parent.getY() + 13 + parent.getScrollOffset() + this.getY());
        gui.addWindow(popupWin);
        return true;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton, class_11909 context) {
        if (mouseButton != 0) {
            if (this.expanded) {
                for (Component child : this.childComponents) {
                    child.handleMouseClick(mouseX, mouseY, mouseButton, context);
                }
            }
            return;
        }
        int x1 = this.getX();
        int y1 = this.getY();
        int y2 = y1 + 13;
        int x2 = x1 + this.getWidth();
        int arrowX1 = x2 - 11;
        if (mouseX >= (double)x1 && mouseX <= (double)(x1 + this.getWidth()) && mouseY >= (double)y1 && mouseY <= (double)y2) {
            boolean clickedArrow;
            boolean bl = clickedArrow = mouseX >= (double)arrowX1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2;
            if (this.popoutEnabled && clickedArrow && this.togglePopoutWindow()) {
                return;
            }
            if (this.popoutEnabled && this.togglePopoutWindow()) {
                return;
            }
            this.expanded = !this.expanded;
            this.updateHeight();
            return;
        }
        if (!this.expanded) {
            return;
        }
        for (Component child : this.childComponents) {
            int cx1 = child.getX();
            int cy1 = child.getY();
            int cx2 = cx1 + child.getWidth();
            int cy2 = cy1 + child.getHeight();
            if (mouseX < (double)cx1 || mouseX > (double)cx2 || mouseY < (double)cy1 || mouseY > (double)cy2) continue;
            child.handleMouseClick(mouseX, mouseY, mouseButton, context);
            break;
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        int sectionTop;
        int x1 = this.getX();
        int y1 = this.getY();
        int x2 = x1 + this.getWidth();
        int y2 = y1 + 13;
        boolean hoverHeader = mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
        float opacity = WURST.getGui().getOpacity() * (hoverHeader ? 1.2f : 1.0f);
        int bgColor = RenderUtils.toIntColor(WURST.getGui().getBgColor(), opacity);
        context.method_25294(x1, y1, x2, y2, bgColor);
        int txtColor = WURST.getGui().getTxtColor();
        context.method_51433(SettingGroupComponent.MC.field_1772, this.group.getName(), x1 + 4, y1 + 2, txtColor, false);
        ClickGuiIcons.drawMinimizeArrow(context, x2 - 11, y1 + 1, x2 - 1, y2 - 1, hoverHeader, !this.expanded);
        if (!this.expanded) {
            return;
        }
        int sectionBottom = sectionTop = y2;
        for (Component child : this.childComponents) {
            sectionBottom += child.getHeight() + 2;
        }
        float sectionOpacity = this.popoutEnabled ? opacity * 0.9f : 1.0f;
        int sectionColor = RenderUtils.toIntColor(WURST.getGui().getBgColor(), sectionOpacity);
        context.method_25294(x1, sectionTop, x2, sectionBottom, sectionColor);
        int outlineColor = RenderUtils.toIntColor(WURST.getGui().getAcColor(), opacity * 0.5f);
        RenderUtils.drawLine2D(context, x1, sectionTop, x2, sectionTop, outlineColor);
        RenderUtils.drawLine2D(context, x1, sectionBottom, x2, sectionBottom, outlineColor);
        int childY = sectionTop + 1;
        for (Component child : this.childComponents) {
            child.setX(x1 + 2);
            child.setY(childY);
            child.setWidth(this.getWidth() - 4);
            child.render(context, mouseX, mouseY, partialTicks);
            childY += child.getHeight() + 2;
        }
    }

    @Override
    public void setParent(Window parent) {
        super.setParent(parent);
        for (Component child : this.childComponents) {
            child.setParent(parent);
        }
    }

    @Override
    public int getDefaultWidth() {
        return 200;
    }

    @Override
    public int getDefaultHeight() {
        return 13;
    }
}

