/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.components;

import net.minecraft.class_11909;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.ClickGuiIcons;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.StringDropdownPopup;
import net.wurstclient.settings.StringDropdownSetting;
import net.wurstclient.util.RenderUtils;

public final class StringDropdownComponent
extends Component {
    private static final ClickGui GUI = WurstClient.INSTANCE.getGui();
    private static final class_327 TR = WurstClient.MC.field_1772;
    private static final int ARROW_SIZE = 11;
    private static final int LABEL_HEIGHT = 11;
    private final StringDropdownSetting setting;
    private StringDropdownPopup popup;

    public StringDropdownComponent(StringDropdownSetting setting) {
        this.setting = setting;
        this.setWidth(this.getDefaultWidth());
        this.setHeight(this.getDefaultHeight());
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton, class_11909 context) {
        double localX = mouseX - (double)this.getX();
        double localY = mouseY - (double)this.getY();
        if (localX < 0.0 || localX >= (double)this.getWidth()) {
            return;
        }
        if (localY < 11.0) {
            return;
        }
        int popupWidth = this.computePopupWidth();
        switch (mouseButton) {
            case 0: {
                this.handleLeftClick(popupWidth);
                break;
            }
            case 1: {
                this.handleRightClick();
            }
        }
    }

    private void handleLeftClick(int popupWidth) {
        if (this.isPopupOpen()) {
            this.popup.close();
            this.popup = null;
            return;
        }
        this.popup = new StringDropdownPopup(this, this.setting, popupWidth);
        GUI.addPopup(this.popup);
    }

    private void handleRightClick() {
        this.setting.resetToDefault();
    }

    private boolean isPopupOpen() {
        return this.popup != null && !this.popup.isClosing();
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float partialTicks) {
        boolean hBox;
        int popupWidth = this.computePopupWidth();
        int x1 = this.getX();
        int x2 = x1 + this.getWidth();
        int boxY1 = this.getY() + 11;
        int boxY2 = boxY1 + 11;
        int arrowX1 = x2 - 11;
        int arrowX2 = x2;
        boolean hovering = this.isHovering(mouseX, mouseY);
        boolean hText = hovering && mouseY < boxY1;
        boolean bl = hBox = hovering && mouseY >= boxY1;
        if (hText) {
            GUI.setTooltip(this.setting.getWrappedDescription(200));
        }
        context.method_25294(x1, this.getY(), x2, boxY1, this.getFillColor(false));
        context.method_25294(x1, boxY1, x2, boxY2, this.getFillColor(hBox));
        context.field_59826.method_71067();
        int outlineColor = RenderUtils.toIntColor(GUI.getAcColor(), 0.5f);
        RenderUtils.drawBorder2D(context, x1, boxY1, x2, boxY2, outlineColor);
        RenderUtils.drawLine2D(context, arrowX1, boxY1, arrowX1, boxY2, outlineColor);
        ClickGuiIcons.drawMinimizeArrow(context, arrowX1, (float)boxY1 + 0.5f, arrowX2, (float)boxY2 - 0.5f, hBox, !this.isPopupOpen());
        String name = this.setting.getName();
        String value = this.setting.getSelected();
        int txtColor = GUI.getTxtColor();
        context.method_51433(TR, name, x1, this.getY() + 2, txtColor, false);
        context.method_51433(TR, value, x1 + 2, boxY1 + 2, txtColor, false);
    }

    private int computePopupWidth() {
        return this.setting.getValues().stream().mapToInt(s -> TR.method_1727(s)).max().orElse(TR.method_1727(this.setting.getName()));
    }

    private int getFillColor(boolean hovering) {
        float opacity = GUI.getOpacity() * (hovering ? 1.5f : 1.0f);
        return RenderUtils.toIntColor(GUI.getBgColor(), opacity);
    }

    @Override
    public int getDefaultWidth() {
        int popupWidth = this.computePopupWidth();
        int boxWidth = popupWidth + 11 + 6;
        int labelWidth = TR.method_1727(this.setting.getName()) + 4;
        return Math.max(labelWidth, boxWidth);
    }

    @Override
    public int getDefaultHeight() {
        return 22;
    }
}

