/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.screens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.wurstclient.clickgui.widgets.MultiSelectEntryListWidget;
import net.wurstclient.settings.EntityTypeListSetting;
import org.joml.Matrix3x2fStack;

public final class EditEntityTypeListScreen
extends class_437 {
    private final class_437 prevScreen;
    private final EntityTypeListSetting typeList;
    private ListGui listGui;
    private class_342 typeNameField;
    private class_4185 addKeywordButton;
    private class_4185 addButton;
    private class_4185 removeButton;
    private class_4185 doneButton;
    private class_1299<?> typeToAdd;
    private List<class_1299<?>> fuzzyMatches = Collections.emptyList();

    public EditEntityTypeListScreen(class_437 prevScreen, EntityTypeListSetting typeList) {
        super((class_2561)class_2561.method_43470((String)""));
        this.prevScreen = prevScreen;
        this.typeList = typeList;
    }

    public void method_25426() {
        this.listGui = new ListGui(this.field_22787, this, this.typeList.getTypeNames());
        this.method_25429((class_364)this.listGui);
        int rowY = this.field_22790 - 56;
        int gap = 8;
        int fieldWidth = 160;
        int keywordWidth = 110;
        int addWidth = 80;
        int removeWidth = 120;
        int totalWidth = fieldWidth + keywordWidth + addWidth + removeWidth + gap * 3;
        int rowStart = this.field_22789 / 2 - totalWidth / 2;
        this.typeNameField = new class_342(this.field_22787.field_1772, rowStart, rowY, fieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.method_25429((class_364)this.typeNameField);
        this.typeNameField.method_1880(256);
        int keywordX = rowStart + fieldWidth + gap;
        int addX = keywordX + keywordWidth + gap;
        int removeX = addX + addWidth + gap;
        this.addKeywordButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add Keyword"), b -> {
            String raw = this.typeNameField.method_1882();
            if (raw != null) {
                raw = raw.trim();
            }
            if (raw == null || raw.isEmpty()) {
                return;
            }
            MultiSelectEntryListWidget.SelectionState prevState = this.listGui.captureState();
            ArrayList<String> before = new ArrayList<String>(this.typeList.getTypeNames());
            this.typeList.addRawName(raw);
            ArrayList<String> added = new ArrayList<String>(this.typeList.getTypeNames());
            added.removeAll(before);
            this.refreshList(prevState, added, prevState.scrollAmount());
        }).method_46434(keywordX, rowY, keywordWidth, 20).method_46431();
        this.method_37063((class_364)this.addKeywordButton);
        this.addButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), b -> {
            MultiSelectEntryListWidget.SelectionState prevState = this.listGui.captureState();
            ArrayList<String> before = new ArrayList<String>(this.typeList.getTypeNames());
            if (this.typeToAdd != null) {
                this.typeList.add(this.typeToAdd);
            } else if (this.fuzzyMatches != null && !this.fuzzyMatches.isEmpty()) {
                for (class_1299<?> et : this.fuzzyMatches) {
                    this.typeList.add(et);
                }
            } else {
                String raw = this.typeNameField.method_1882();
                if (raw != null) {
                    raw = raw.trim();
                }
                if (raw != null && !raw.isEmpty()) {
                    this.typeList.addRawName(raw);
                }
            }
            ArrayList<String> added = new ArrayList<String>(this.typeList.getTypeNames());
            added.removeAll(before);
            this.refreshList(prevState, added, prevState.scrollAmount());
        }).method_46434(addX, rowY, addWidth, 20).method_46431();
        this.method_37063((class_364)this.addButton);
        this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove Selected"), b -> {
            List<String> selected = this.listGui.getSelectedTypeNames();
            if (selected.isEmpty()) {
                return;
            }
            MultiSelectEntryListWidget.SelectionState prevState = this.listGui.captureState();
            for (String key : selected) {
                int index = this.typeList.getTypeNames().indexOf(key);
                if (index < 0) continue;
                this.typeList.remove(index);
            }
            this.refreshList(prevState, Collections.emptyList(), prevState.scrollAmount());
        }).method_46434(removeX, rowY, removeWidth, 20).method_46431();
        this.method_37063((class_364)this.removeButton);
        this.listGui.setSelectionListener(this::updateButtons);
        this.updateButtons();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset to Defaults"), b -> this.field_22787.method_1507((class_437)new class_410(b2 -> {
            if (b2) {
                this.typeList.resetToDefaults();
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_2561.method_43470((String)"Reset to Defaults"), (class_2561)class_2561.method_43470((String)"Are you sure?")))).method_46434(this.field_22789 - 328, 8, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear List"), b -> {
            this.typeList.clear();
            this.field_22787.method_1507((class_437)this);
        }).method_46434(this.field_22789 - 168, 8, 150, 20).method_46431());
        this.doneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), b -> this.field_22787.method_1507(this.prevScreen)).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431();
        this.method_37063((class_364)this.doneButton);
    }

    public boolean method_25402(class_11909 context, boolean doubleClick) {
        this.typeNameField.method_25402(context, doubleClick);
        return super.method_25402(context, doubleClick);
    }

    public boolean method_25404(class_11908 keyInput) {
        int keyCode = keyInput.comp_4795();
        switch (keyCode) {
            case 257: {
                if (!this.addButton.field_22763) break;
                this.addButton.method_25306((class_11907)keyInput);
                break;
            }
            case 261: {
                if (this.typeNameField.method_25370()) break;
                this.removeButton.method_25306((class_11907)keyInput);
                break;
            }
            case 256: {
                this.doneButton.method_25306((class_11907)keyInput);
                break;
            }
        }
        return super.method_25404(keyInput);
    }

    public void method_25393() {
        String rawInput = this.typeNameField.method_1882();
        String nameOrId = rawInput == null ? "" : rawInput.toLowerCase();
        String trimmed = rawInput == null ? "" : rawInput.trim();
        boolean hasInput = !trimmed.isEmpty();
        try {
            class_2960 id = class_2960.method_60654((String)nameOrId);
            this.typeToAdd = class_7923.field_41177.method_10250(id) ? (class_1299)class_7923.field_41177.method_63535(id) : null;
        }
        catch (IllegalArgumentException e) {
            this.typeToAdd = null;
        }
        if (this.typeToAdd == null) {
            String q;
            String string = q = trimmed.isEmpty() ? "" : trimmed.toLowerCase(Locale.ROOT);
            if (q.isEmpty()) {
                this.fuzzyMatches = Collections.emptyList();
            } else {
                ArrayList<class_1299> list = new ArrayList<class_1299>();
                for (class_2960 id : class_7923.field_41177.method_10235()) {
                    String s = id.toString().toLowerCase(Locale.ROOT);
                    if (!s.contains(q)) continue;
                    list.add((class_1299)class_7923.field_41177.method_63535(id));
                }
                LinkedHashMap<String, class_1299> map = new LinkedHashMap<String, class_1299>();
                for (class_1299 et : list) {
                    map.put(class_7923.field_41177.method_10221((Object)et).toString(), et);
                }
                this.fuzzyMatches = new ArrayList(map.values());
                this.fuzzyMatches.sort(Comparator.comparing(t -> class_7923.field_41177.method_10221(t).toString()));
            }
            this.addButton.field_22763 = !this.fuzzyMatches.isEmpty() || hasInput;
            this.addButton.method_25355((class_2561)class_2561.method_43470((String)(this.fuzzyMatches.isEmpty() ? "Add" : "Add Matches (" + this.fuzzyMatches.size() + ")")));
        } else {
            this.fuzzyMatches = Collections.emptyList();
            this.addButton.field_22763 = true;
            this.addButton.method_25355((class_2561)class_2561.method_43470((String)"Add"));
        }
        this.addKeywordButton.field_22763 = hasInput;
        this.updateButtons();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        Matrix3x2fStack matrixStack = context.method_51448();
        this.listGui.method_25394(context, mouseX, mouseY, partialTicks);
        context.method_25300(this.field_22787.field_1772, this.typeList.getName() + " (" + this.typeList.getTypeNames().size() + ")", this.field_22789 / 2, 12, -1);
        matrixStack.pushMatrix();
        this.typeNameField.method_25394(context, mouseX, mouseY, partialTicks);
        for (class_4068 drawable : this.field_33816) {
            drawable.method_25394(context, mouseX, mouseY, partialTicks);
        }
        context.field_59826.method_71067();
        int x0 = this.typeNameField.method_46426();
        int y0 = this.typeNameField.method_46427();
        int y1 = y0 + this.typeNameField.method_25364();
        if (this.typeNameField.method_1882().isEmpty() && !this.typeNameField.method_25370()) {
            context.method_25303(this.field_22787.field_1772, "entity type id", x0 + 6, y0 + 6, -8355712);
        }
        int border = this.typeNameField.method_25370() ? -1 : -6250336;
        int black = -16777216;
        context.method_25294(x0 - 16, y0, x0, y1, border);
        context.method_25294(x0 - 15, y0 + 1, x0 - 1, y1 - 1, black);
        matrixStack.popMatrix();
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        return false;
    }

    private void updateButtons() {
        if (this.removeButton != null) {
            this.removeButton.field_22763 = this.listGui.hasSelection();
        }
    }

    private void refreshList(MultiSelectEntryListWidget.SelectionState previousState, Collection<String> preferredKeys, double scrollAmount) {
        this.listGui.reloadPreservingState(this.typeList.getTypeNames(), previousState, preferredKeys, scrollAmount);
        this.updateButtons();
    }

    private final class ListGui
    extends MultiSelectEntryListWidget<Entry> {
        public ListGui(class_310 minecraft, EditEntityTypeListScreen screen, List<String> list) {
            super(minecraft, screen.field_22789, screen.field_22790 - 96, 36, 30);
            this.reload(list);
            this.ensureSelection();
        }

        public void reload(List<String> list) {
            this.method_25339();
            list.stream().map(name -> new Entry(this, (String)name)).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        }

        public void reloadPreservingState(List<String> list, MultiSelectEntryListWidget.SelectionState previousState, Collection<String> preferredKeys, double scrollAmount) {
            this.reload(list);
            if (preferredKeys != null && !preferredKeys.isEmpty()) {
                this.setSelection(preferredKeys, scrollAmount);
                return;
            }
            if (previousState != null) {
                this.restoreState(new MultiSelectEntryListWidget.SelectionState(new ArrayList<String>(previousState.selectedKeys()), previousState.anchorKey(), scrollAmount, previousState.anchorIndex()));
                return;
            }
            this.ensureSelection();
        }

        public List<String> getSelectedTypeNames() {
            return this.getSelectedKeys();
        }

        @Override
        protected String getSelectionKey(Entry entry) {
            return entry.typeName;
        }
    }

    private final class Entry
    extends MultiSelectEntryListWidget.Entry<Entry> {
        private final String typeName;

        public Entry(ListGui parent, String typeName) {
            super(parent);
            this.typeName = Objects.requireNonNull(typeName);
        }

        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{"Entity " + this.typeName});
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 tr = ((EditEntityTypeListScreen)EditEntityTypeListScreen.this).field_22787.field_1772;
            class_2960 id = class_2960.method_12829((String)this.typeName);
            String display = id != null && class_7923.field_41177.method_10250(id) ? ((class_1299)class_7923.field_41177.method_63535(id)).method_5897().getString() : "\u00a7okeyword\u00a7r";
            int x = this.method_73380();
            int y = this.method_73382();
            context.method_51433(tr, display, x + 8, y, -986896, false);
            context.method_51433(tr, this.typeName, x + 8, y + 10, -6250336, false);
        }

        @Override
        public String selectionKey() {
            return this.typeName;
        }
    }
}

