/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.screens;

import java.awt.Color;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.wurstclient.clickgui.screens.EditColorScreen;
import net.wurstclient.clickgui.screens.WaypointsScreen;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.waypoints.Waypoint;
import net.wurstclient.waypoints.WaypointDimension;
import net.wurstclient.waypoints.WaypointsManager;

public final class WaypointEditScreen
extends class_437 {
    private final class_437 prev;
    private final WaypointsManager manager;
    private final WaypointsScreen listScreen;
    private final Waypoint waypoint;
    private int fieldsBaseX;
    private int fieldsWidth;
    private boolean narrow;
    private int yName;
    private int yXYZ;
    private int yToggles;
    private int yColor;
    private int xXYZ1;
    private int xXYZ2;
    private int xXYZ3;
    private int yYField;
    private int yZField;
    private boolean compactMode = false;
    private class_342 nameField;
    private class_342 xField;
    private class_342 yField;
    private class_342 zField;
    private class_4185 colorButton;
    private ColorSetting colorSetting;
    private int alphaPercent = 100;
    private String draftName;
    private String draftX;
    private String draftY;
    private String draftZ;
    private int dimIndex;
    private class_4185 dimButton;
    private Integer draftDimIndex;
    private static final String[] ICON_KEYS = new String[]{"square", "circle", "triangle", "star", "diamond", "skull", "heart", "check", "x", "arrow_down", "sun", "snowflake"};
    private static final String[] ICONS = new String[ICON_KEYS.length];
    private int iconIndex;
    private class_4185 iconButton;
    private class_4185 oppositeButton;
    private class_4185 visibleButton;
    private class_4185 linesButton;
    private class_4185 beaconButton;

    public WaypointEditScreen(class_437 prev, WaypointsManager manager, Waypoint waypoint, boolean isNew) {
        super((class_2561)class_2561.method_43470((String)"Edit Waypoint"));
        this.prev = prev;
        this.manager = manager;
        this.listScreen = prev instanceof WaypointsScreen ? (WaypointsScreen)prev : null;
        this.waypoint = waypoint;
    }

    protected void method_25426() {
        int cw = Math.max(220, Math.min(this.field_22789 - 40, 360));
        this.narrow = cw < 340;
        int x = this.field_22789 / 2 - cw / 2;
        int y = 36;
        this.fieldsBaseX = x;
        this.fieldsWidth = cw;
        this.compactMode = cw < 260;
        this.yName = y;
        this.nameField = new class_342(this.field_22787.field_1772, x, y, cw, 20, (class_2561)class_2561.method_43470((String)""));
        String baseName = this.waypoint.getName() == null ? "" : this.waypoint.getName();
        this.nameField.method_1852(this.draftName != null ? this.draftName : baseName);
        this.method_37063((class_364)this.nameField);
        this.method_25395((class_364)this.nameField);
        y += 44;
        if (!this.compactMode) {
            int a;
            class_2338 p = this.waypoint.getPos();
            this.yXYZ = y;
            int gap = 8;
            int colW = (cw - gap * 2) / 3;
            this.xXYZ1 = x;
            this.xXYZ2 = x + colW + gap;
            this.xXYZ3 = x + (colW + gap) * 2;
            this.xField = new class_342(this.field_22787.field_1772, this.xXYZ1, y, colW, 20, (class_2561)class_2561.method_43470((String)""));
            this.xField.method_1852(this.draftX != null ? this.draftX : Integer.toString(p.method_10263()));
            this.method_37063((class_364)this.xField);
            this.yField = new class_342(this.field_22787.field_1772, this.xXYZ2, this.narrow ? y + 28 : y, colW, 20, (class_2561)class_2561.method_43470((String)""));
            this.yField.method_1852(this.draftY != null ? this.draftY : Integer.toString(p.method_10264()));
            this.method_37063((class_364)this.yField);
            this.zField = new class_342(this.field_22787.field_1772, this.xXYZ3, this.narrow ? y + 56 : y, colW, 20, (class_2561)class_2561.method_43470((String)""));
            this.zField.method_1852(this.draftZ != null ? this.draftZ : Integer.toString(p.method_10260()));
            this.method_37063((class_364)this.zField);
            this.yYField = this.narrow ? y + 28 : y;
            this.yZField = this.narrow ? y + 56 : y;
            y += this.narrow ? 84 : 28;
            WaypointDimension[] dims = WaypointDimension.values();
            this.dimIndex = 0;
            for (int i = 0; i < dims.length; ++i) {
                if (dims[i] != this.waypoint.getDimension()) continue;
                this.dimIndex = i;
                break;
            }
            if (this.draftDimIndex != null) {
                this.dimIndex = this.draftDimIndex;
                this.draftDimIndex = null;
            }
            this.dimButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Dimension: " + dims[this.dimIndex].name())), b -> {
                this.dimIndex = (this.dimIndex + 1) % dims.length;
                b.method_25355((class_2561)class_2561.method_43470((String)("Dimension: " + dims[this.dimIndex].name())));
            }).method_46434(x, y, cw, 20).method_46431();
            this.method_37063((class_364)this.dimButton);
            this.yToggles = y += 28;
            int halfGap = 10;
            int halfW = (cw - halfGap) / 2;
            this.oppositeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)WaypointEditScreen.buttonLabel("Opposite", this.waypoint.isOpposite())), b -> {
                this.waypoint.setOpposite(!this.waypoint.isOpposite());
                b.method_25355((class_2561)class_2561.method_43470((String)WaypointEditScreen.buttonLabel("Opposite", this.waypoint.isOpposite())));
            }).method_46434(x, y, halfW, 20).method_46431();
            this.method_37063((class_364)this.oppositeButton);
            this.visibleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)WaypointEditScreen.buttonLabel("Visible", this.waypoint.isVisible())), b -> {
                this.waypoint.setVisible(!this.waypoint.isVisible());
                b.method_25355((class_2561)class_2561.method_43470((String)WaypointEditScreen.buttonLabel("Visible", this.waypoint.isVisible())));
            }).method_46434(x + halfW + halfGap, y, halfW, 20).method_46431();
            this.method_37063((class_364)this.visibleButton);
            y += 28;
            int toggleWidth = (cw - halfGap) / 2;
            this.linesButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)WaypointEditScreen.buttonLabel("Lines", this.waypoint.isLines())), b -> {
                this.waypoint.setLines(!this.waypoint.isLines());
                b.method_25355((class_2561)class_2561.method_43470((String)WaypointEditScreen.buttonLabel("Lines", this.waypoint.isLines())));
            }).method_46434(x, y += 16, toggleWidth, 20).method_46431();
            this.method_37063((class_364)this.linesButton);
            this.beaconButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.beaconLabel(this.waypoint.getBeaconMode())), b -> {
                Waypoint.BeaconMode next = this.nextBeaconMode(this.waypoint.getBeaconMode());
                this.waypoint.setBeaconMode(next);
                b.method_25355((class_2561)class_2561.method_43470((String)this.beaconLabel(next)));
            }).method_46434(x + toggleWidth + halfGap, y, toggleWidth, 20).method_46431();
            this.method_37063((class_364)this.beaconButton);
            y += 28;
            this.iconIndex = 0;
            String currentIcon = this.waypoint.getIcon();
            for (int i = 0; i < ICON_KEYS.length; ++i) {
                if (!ICON_KEYS[i].equalsIgnoreCase(currentIcon)) continue;
                this.iconIndex = i;
                break;
            }
            this.iconButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Icon: " + ICONS[this.iconIndex])), b -> {
                this.iconIndex = (this.iconIndex + 1) % ICONS.length;
                b.method_25355((class_2561)class_2561.method_43470((String)("Icon: " + ICONS[this.iconIndex])));
            }).method_46434(x, y, cw, 20).method_46431();
            this.method_37063((class_364)this.iconButton);
            y += 28;
            this.yColor = y += 8;
            if (this.colorSetting == null) {
                this.colorSetting = new ColorSetting("Waypoint Color", new Color(this.waypoint.getColor() & 0xFFFFFF | 0xFF000000, true));
            }
            if (this.alphaPercent == 100 && (a = this.waypoint.getColor() >>> 24 & 0xFF) > 0) {
                this.alphaPercent = Math.max(1, Math.min(100, (int)Math.round((double)a / 255.0 * 100.0)));
            }
            this.colorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Pick color (#" + this.toHex6(this.colorSetting.getColorI()) + ")")), b -> {
                this.draftName = this.nameField.method_1882();
                this.draftX = this.xField.method_1882();
                this.draftY = this.yField.method_1882();
                this.draftZ = this.zField.method_1882();
                this.draftDimIndex = this.dimIndex;
                this.field_22787.method_1507((class_437)new EditColorScreen(this, this.colorSetting));
            }).method_46434(x, y, cw - 24, 20).method_46431();
            this.method_37063((class_364)this.colorButton);
            this.method_37063((class_364)new class_357(x, y += 28, this.fieldsWidth, 20, (class_2561)class_2561.method_43470((String)("Transparency: " + this.alphaPercent + "%")), (double)(this.alphaPercent - 1) / 99.0){

                protected void method_25346() {
                    int val = 1 + (int)Math.round(this.field_22753 * 99.0);
                    WaypointEditScreen.this.alphaPercent = Math.max(1, Math.min(100, val));
                    this.method_25355((class_2561)class_2561.method_43470((String)("Transparency: " + WaypointEditScreen.this.alphaPercent + "%")));
                }

                protected void method_25344() {
                    int val = 1 + (int)Math.round(this.field_22753 * 99.0);
                    WaypointEditScreen.this.alphaPercent = Math.max(1, Math.min(100, val));
                }
            });
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Use player pos"), b -> this.usePlayerPos()).method_46434(x, y += 28, halfW, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), b -> this.doDelete()).method_46434(x + halfW + halfGap, y, halfW, 20).method_46431());
            y += 28;
        }
        int halfGap = 10;
        int halfW = (this.fieldsWidth - halfGap) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.saveAndBack()).method_46434(this.fieldsBaseX, this.field_22790 - 52, halfW, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.prev)).method_46434(this.fieldsBaseX + halfW + halfGap, this.field_22790 - 52, halfW, 20).method_46431());
    }

    public void method_25410(class_310 client, int width, int height) {
        if (this.nameField != null) {
            this.draftName = this.nameField.method_1882();
            this.draftX = this.xField.method_1882();
            this.draftY = this.yField.method_1882();
            this.draftZ = this.zField.method_1882();
            this.draftDimIndex = this.dimIndex;
        }
        this.method_25423(client, width, height);
    }

    private static String buttonLabel(String name, boolean on) {
        return name + ": " + (on ? "ON" : "OFF");
    }

    private String beaconLabel(Waypoint.BeaconMode mode) {
        Waypoint.BeaconMode safe = mode == null ? Waypoint.BeaconMode.OFF : mode;
        String state = switch (safe) {
            default -> throw new MatchException(null, null);
            case Waypoint.BeaconMode.OFF -> "OFF";
            case Waypoint.BeaconMode.SOLID -> "ON";
            case Waypoint.BeaconMode.ESP -> "ESP";
        };
        return "Beacon: " + state;
    }

    private Waypoint.BeaconMode nextBeaconMode(Waypoint.BeaconMode mode) {
        Waypoint.BeaconMode safe = mode == null ? Waypoint.BeaconMode.OFF : mode;
        return switch (safe) {
            default -> throw new MatchException(null, null);
            case Waypoint.BeaconMode.OFF -> Waypoint.BeaconMode.SOLID;
            case Waypoint.BeaconMode.SOLID -> Waypoint.BeaconMode.ESP;
            case Waypoint.BeaconMode.ESP -> Waypoint.BeaconMode.OFF;
        };
    }

    private void usePlayerPos() {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        class_2338 p = class_2338.method_49637((double)this.field_22787.field_1724.method_23317(), (double)this.field_22787.field_1724.method_23318(), (double)this.field_22787.field_1724.method_23321());
        this.xField.method_1852(Integer.toString(p.method_10263()));
        this.yField.method_1852(Integer.toString(p.method_10264()));
        this.zField.method_1852(Integer.toString(p.method_10260()));
    }

    private void doDelete() {
        this.manager.remove(this.waypoint);
        if (this.listScreen != null) {
            this.listScreen.saveNow();
        }
        this.field_22787.method_1507(this.prev);
    }

    private void saveAndBack() {
        this.waypoint.setName(this.nameField.method_1882());
        if (this.xField != null && this.yField != null && this.zField != null) {
            try {
                int x = Integer.parseInt(this.xField.method_1882());
                int y = Integer.parseInt(this.yField.method_1882());
                int z = Integer.parseInt(this.zField.method_1882());
                this.waypoint.setPos(new class_2338(x, y, z));
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        this.waypoint.setDimension(WaypointDimension.values()[this.dimIndex]);
        this.waypoint.setIcon(ICON_KEYS[this.iconIndex]);
        int saveAlpha = (int)Math.round((double)Math.max(1, Math.min(100, this.alphaPercent)) / 100.0 * 255.0);
        this.waypoint.setColor(this.colorSetting.getColorI(saveAlpha));
        this.manager.addOrUpdate(this.waypoint);
        if (this.listScreen != null) {
            this.listScreen.saveNow();
        }
        this.field_22787.method_1507(this.prev);
    }

    private String toHex6(int argb) {
        int rgb = argb & 0xFFFFFF;
        Object s = Integer.toHexString(rgb).toUpperCase();
        while (((String)s).length() < 6) {
            s = "0" + (String)s;
        }
        return s;
    }

    private static String iconChar(String icon) {
        if (icon == null) {
            return "";
        }
        switch (icon.toLowerCase()) {
            case "square": {
                return "\u25a0";
            }
            case "circle": {
                return "\u25cf";
            }
            case "triangle": {
                return "\u25b2";
            }
            case "triangle_down": {
                return "\u25bc";
            }
            case "star": {
                return "\u2605";
            }
            case "diamond": {
                return "\u2666";
            }
            case "skull": {
                return "\u2620";
            }
            case "heart": {
                return "\u2665";
            }
            case "check": {
                return "\u2713";
            }
            case "x": {
                return "\u2717";
            }
            case "arrow_down": {
                return "\u2193";
            }
            case "sun": {
                return "\u2600";
            }
            case "snowflake": {
                return "\u2744";
            }
        }
        return "";
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -2013265920);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.colorButton != null && this.colorSetting != null) {
            this.colorButton.method_25355((class_2561)class_2561.method_43470((String)("Pick color (#" + this.toHex6(this.colorSetting.getColorI()) + ")")));
        }
        int x = this.fieldsBaseX;
        context.method_51433(this.field_22787.field_1772, "Name", x, this.yName - 18, -6250336, false);
        if (this.xField != null) {
            context.method_51433(this.field_22787.field_1772, "X", this.xXYZ1, this.yXYZ - 18, -6250336, false);
            context.method_51433(this.field_22787.field_1772, "Y", this.xXYZ2, (this.narrow ? this.yYField : this.yXYZ) - 18, -6250336, false);
            context.method_51433(this.field_22787.field_1772, "Z", this.xXYZ3, (this.narrow ? this.yZField : this.yXYZ) - 18, -6250336, false);
        }
        int boxX = x + this.fieldsWidth - 20;
        int boxY = this.yColor;
        int alpha = (int)Math.round((double)Math.max(1, Math.min(100, this.alphaPercent)) / 100.0 * 255.0);
        int color = this.colorSetting.getColorI(alpha);
        context.method_25294(boxX - 1, boxY - 1, boxX + 18, boxY + 18, -8355712);
        context.method_25294(boxX, boxY, boxX + 16, boxY + 16, color);
        String opp = this.oppositePreview();
        if (!opp.isEmpty()) {
            context.method_51433(this.field_22787.field_1772, opp, this.fieldsBaseX, this.yToggles + 28 + 8, -3355444, false);
        }
    }

    private String oppositePreview() {
        if (!this.waypoint.isOpposite()) {
            return "";
        }
        WaypointDimension d = WaypointDimension.values()[this.dimIndex];
        if (d == WaypointDimension.END) {
            return "Opposite has no effect in the End";
        }
        try {
            WaypointDimension td;
            int x = Integer.parseInt(this.xField.method_1882());
            int z = Integer.parseInt(this.zField.method_1882());
            int y = Integer.parseInt(this.yField.method_1882());
            int ox = x;
            int oz = z;
            if (d == WaypointDimension.OVERWORLD) {
                ox = Math.floorDiv(x, 8);
                oz = Math.floorDiv(z, 8);
                td = WaypointDimension.NETHER;
            } else {
                ox = x * 8;
                oz = z * 8;
                td = WaypointDimension.OVERWORLD;
            }
            return "Opposite shows in " + td.name() + " at (" + ox + ", " + y + ", " + oz + ")";
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        for (int i = 0; i < ICON_KEYS.length; ++i) {
            WaypointEditScreen.ICONS[i] = WaypointEditScreen.iconChar(ICON_KEYS[i]) + " " + ICON_KEYS[i];
        }
    }
}

