/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.clickgui.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_11906;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import org.lwjgl.glfw.GLFW;

public abstract class MultiSelectEntryListWidget<E extends Entry<E>>
extends class_4280<E> {
    private final LinkedHashSet<String> selectedKeys = new LinkedHashSet();
    private String anchorKey;
    private Runnable selectionListener = () -> {};

    protected MultiSelectEntryListWidget(class_310 client, int width, int height, int top, int itemHeight) {
        super(client, width, height, top, itemHeight);
    }

    public void setSelectionListener(Runnable listener) {
        this.selectionListener = listener != null ? listener : () -> {};
    }

    protected void notifySelectionChanged() {
        this.selectionListener.run();
    }

    public List<E> getSelectedEntries() {
        Map<String, E> byKey = this.buildEntryMap(this.method_25396());
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (String key : this.selectedKeys) {
            Entry entry = (Entry)((Object)byKey.get(key));
            if (entry == null) continue;
            entries.add(entry);
        }
        return List.copyOf(entries);
    }

    public List<String> getSelectedKeys() {
        return List.copyOf(this.selectedKeys);
    }

    public boolean hasSelection() {
        if (this.selectedKeys.isEmpty()) {
            return false;
        }
        return this.resolveAnchorEntry() != null;
    }

    protected boolean isEntrySelected(E entry) {
        return this.selectedKeys.contains(this.getSelectionKey(entry));
    }

    protected void renderItem(class_332 context, int mouseX, int mouseY, float delta, E entry) {
        if (this.method_73379() && this.selectedKeys.contains(this.getSelectionKey(entry))) {
            int color = this.method_25334() == entry && this.method_25370() ? -1 : -8355712;
            this.method_44398(context, (class_350.class_351)entry, color);
        }
        entry.method_25343(context, mouseX, mouseY, Objects.equals(this.method_37019(), entry), delta);
    }

    protected abstract String getSelectionKey(E var1);

    protected void onEntryClicked(E entry, boolean shiftDown, boolean ctrlDown) {
        Object anchorEntry;
        String entryKey = this.getSelectionKey(entry);
        boolean entrySelected = shiftDown && this.anchorKey != null ? this.selectRange(this.anchorKey, entry, ctrlDown) : (ctrlDown ? this.toggleEntry(entry) : this.selectSingle(entry));
        if (entrySelected) {
            this.anchorKey = entryKey;
            anchorEntry = entry;
        } else {
            anchorEntry = this.resolveAnchorEntry();
        }
        if (anchorEntry == null && !this.method_25396().isEmpty()) {
            anchorEntry = (Entry)((Object)this.method_25396().get(0));
            String key = this.getSelectionKey(anchorEntry);
            if (this.selectedKeys.isEmpty()) {
                this.selectedKeys.add(key);
            }
            this.anchorKey = key;
        }
        super.method_25313(anchorEntry);
        this.notifySelectionChanged();
    }

    private boolean selectSingle(E entry) {
        this.selectedKeys.clear();
        this.selectedKeys.add(this.getSelectionKey(entry));
        return true;
    }

    private boolean toggleEntry(E entry) {
        String key = this.getSelectionKey(entry);
        if (this.selectedKeys.contains(key)) {
            if (this.selectedKeys.size() > 1) {
                this.selectedKeys.remove(key);
                return false;
            }
            return true;
        }
        this.selectedKeys.add(key);
        return true;
    }

    private boolean selectRange(String fromKey, E to, boolean additive) {
        E from = this.findEntryByKey(fromKey);
        if (from == null) {
            return this.selectSingle(to);
        }
        if (!additive) {
            this.selectedKeys.clear();
        }
        List children = this.method_25396();
        int start = children.indexOf(from);
        int end = children.indexOf(to);
        if (start == -1 || end == -1) {
            return this.selectSingle(to);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        for (int i = start; i <= end; ++i) {
            this.selectedKeys.add(this.getSelectionKey((Entry)((Object)children.get(i))));
        }
        return true;
    }

    private E findEntryByKey(String key) {
        if (key == null) {
            return null;
        }
        for (Entry entry : this.method_25396()) {
            if (!Objects.equals(this.getSelectionKey(entry), key)) continue;
            return (E)((Object)entry);
        }
        return null;
    }

    private Map<String, E> buildEntryMap(List<E> entries) {
        return entries.stream().collect(Collectors.toMap(this::getSelectionKey, Function.identity(), (a, b) -> a, LinkedHashMap::new));
    }

    private E resolveAnchorEntry() {
        String firstKey;
        Entry entry;
        if (this.selectedKeys.isEmpty()) {
            this.anchorKey = null;
            return null;
        }
        List entries = this.method_25396();
        if (entries.isEmpty()) {
            this.selectedKeys.clear();
            this.anchorKey = null;
            return null;
        }
        Map byKey = this.buildEntryMap(entries);
        if (this.selectedKeys.removeIf(key -> !byKey.containsKey(key)) && this.selectedKeys.isEmpty()) {
            this.anchorKey = null;
            return null;
        }
        if (this.anchorKey != null && (entry = (Entry)((Object)byKey.get(this.anchorKey))) != null) {
            return (E)((Object)entry);
        }
        this.anchorKey = firstKey = (String)this.selectedKeys.iterator().next();
        return (E)((Object)((Entry)((Object)byKey.get(firstKey))));
    }

    protected boolean isSelectedEntry(int index) {
        Entry entry = (Entry)((Object)this.method_25396().get(index));
        return this.selectedKeys.contains(this.getSelectionKey(entry));
    }

    protected boolean isShiftDown() {
        return this.isKeyDown(340) || this.isKeyDown(344);
    }

    protected boolean isControlDown() {
        boolean control;
        boolean bl = control = this.isKeyDown(341) || this.isKeyDown(345) || this.isKeyDown(class_11906.field_62587) || this.isKeyDown(class_11906.field_62588);
        if (class_156.method_668() == class_156.class_158.field_1137) {
            control |= this.isKeyDown(343) || this.isKeyDown(347);
        }
        return control;
    }

    private boolean isKeyDown(int keyCode) {
        class_1041 window = class_310.method_1551().method_22683();
        return GLFW.glfwGetKey((long)window.method_4490(), (int)keyCode) == 1;
    }

    public SelectionState captureState() {
        E anchorEntry = this.resolveAnchorEntry();
        ArrayList<String> keys = new ArrayList<String>(this.selectedKeys);
        String anchorKey = this.anchorKey;
        int anchorIndex = anchorEntry != null ? this.method_25396().indexOf(anchorEntry) : -1;
        return new SelectionState(new ArrayList<String>(keys), anchorKey, this.method_44387(), anchorIndex);
    }

    public void restoreState(SelectionState state) {
        double targetScroll;
        this.selectedKeys.clear();
        this.anchorKey = null;
        List entries = this.method_25396();
        if (entries.isEmpty()) {
            super.method_25313(null);
            this.notifySelectionChanged();
            return;
        }
        Map byKey = this.buildEntryMap(entries);
        double d = targetScroll = state != null ? class_3532.method_15350((double)state.scrollAmount(), (double)0.0, (double)this.method_44390()) : this.method_44387();
        if (state != null && !state.selectedKeys().isEmpty()) {
            for (String key2 : state.selectedKeys()) {
                Entry entry = (Entry)((Object)byKey.get(key2));
                if (entry == null) continue;
                this.selectedKeys.add(key2);
            }
            if (!this.selectedKeys.isEmpty()) {
                if (state.anchorKey() != null) {
                    this.anchorKey = state.anchorKey();
                }
                if (this.anchorKey == null || !byKey.containsKey(this.anchorKey)) {
                    this.anchorKey = (String)this.selectedKeys.iterator().next();
                }
            }
        }
        this.selectedKeys.removeIf(key -> !byKey.containsKey(key));
        if (this.selectedKeys.isEmpty()) {
            int index = state != null ? state.anchorIndex() : -1;
            index = class_3532.method_15340((int)index, (int)0, (int)(entries.size() - 1));
            Entry fallback = (Entry)((Object)entries.get(index));
            String key3 = this.getSelectionKey(fallback);
            this.selectedKeys.add(key3);
            this.anchorKey = key3;
        }
        E anchorEntry = this.resolveAnchorEntry();
        super.method_25313(anchorEntry);
        this.method_44382(targetScroll);
        this.notifySelectionChanged();
    }

    public void ensureSelection() {
        if (!this.selectedKeys.isEmpty() || this.method_25396().isEmpty()) {
            if (this.selectedKeys.isEmpty() && this.method_25396().isEmpty()) {
                super.method_25313(null);
                this.notifySelectionChanged();
            }
            return;
        }
        Entry first = (Entry)((Object)this.method_25396().get(0));
        String key = this.getSelectionKey(first);
        this.selectedKeys.add(key);
        this.anchorKey = key;
        super.method_25313((class_350.class_351)first);
        this.notifySelectionChanged();
    }

    public void setSelection(Collection<String> keys, double scrollAmount) {
        ArrayList<String> list = new ArrayList<String>(keys);
        String anchorKey = list.isEmpty() ? null : (String)list.get(0);
        this.restoreState(new SelectionState(list, anchorKey, scrollAmount, -1));
    }

    public static abstract class Entry<E extends Entry<E>>
    extends class_4280.class_4281<E> {
        private final MultiSelectEntryListWidget<E> parent;

        protected Entry(MultiSelectEntryListWidget<E> parent) {
            this.parent = parent;
        }

        protected MultiSelectEntryListWidget<E> parent() {
            return this.parent;
        }

        public abstract String selectionKey();

        public boolean method_25402(class_11909 context, boolean doubleClick) {
            if (context.method_74245() != 0) {
                return false;
            }
            boolean shiftDown = (context.comp_4797() & 1) != 0 || context.method_74239() || this.parent.isShiftDown();
            boolean ctrlDown = (context.comp_4797() & 2) != 0 || context.method_74240() || this.parent.isControlDown();
            this.parent.onEntryClicked(this.self(), shiftDown, ctrlDown);
            return true;
        }

        private E self() {
            return (E)((Object)this);
        }
    }

    public record SelectionState(List<String> selectedKeys, String anchorKey, double scrollAmount, int anchorIndex) {
    }
}

