/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import net.wurstclient.hack.Hack;
import net.wurstclient.hack.HackList;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.json.WsonArray;

public final class FavoriteHacksFile {
    private final Path path;
    private boolean disableSaving;

    public FavoriteHacksFile(Path path) {
        this.path = path;
    }

    public void load(HackList hackList) {
        try {
            WsonArray wson = JsonUtils.parseFileToArray(this.path);
            this.applyFavorites(hackList, wson);
        }
        catch (NoSuchFileException wson) {
        }
        catch (IOException | JsonException e) {
            System.out.println("Couldn't load " + String.valueOf(this.path.getFileName()));
            e.printStackTrace();
        }
        this.save(hackList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFavorites(HackList hax, WsonArray wson) {
        try {
            this.disableSaving = true;
            for (Hack hack : hax.getAllHax()) {
                hack.setFavorite(false);
            }
            for (String name : wson.getAllStrings()) {
                Hack hack = hax.getHackByName(name);
                if (hack == null) continue;
                hack.setFavorite(true);
            }
        }
        finally {
            this.disableSaving = false;
        }
    }

    public void save(HackList hax) {
        if (this.disableSaving) {
            return;
        }
        JsonArray json = this.createJson(hax);
        try {
            JsonUtils.toJson((JsonElement)json, this.path);
        }
        catch (IOException | JsonException e) {
            System.out.println("Couldn't save " + String.valueOf(this.path.getFileName()));
            e.printStackTrace();
        }
    }

    private JsonArray createJson(HackList hax) {
        JsonArray json = new JsonArray();
        hax.getAllHax().stream().filter(Hack::isFavorite).map(Hack::getName).forEach(name -> json.add(name));
        return json;
    }
}

