/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4969;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.FaceTargetSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.SwingHandSetting;
import net.wurstclient.settings.filterlists.AnchorAuraFilterList;
import net.wurstclient.settings.filterlists.EntityFilterList;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.FakePlayerEntity;
import net.wurstclient.util.InventoryUtils;
import net.wurstclient.util.RotationUtils;

@SearchTags(value={"anchor aura", "CrystalAura", "crystal aura"})
public final class AnchorAuraHack
extends Hack
implements UpdateListener {
    private final SliderSetting range = new SliderSetting("Range", "description.wurst.setting.anchoraura.range", 6.0, 1.0, 6.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final CheckboxSetting autoPlace = new CheckboxSetting("Auto-place anchors", "description.wurst.setting.anchoraura.auto-place_anchors", true);
    private final CheckboxSetting checkLOS = new CheckboxSetting("Check line of sight", "description.wurst.setting.anchoraura.check_line_of_sight", false);
    private final FaceTargetSetting faceTarget = FaceTargetSetting.withPacketSpam(this, FaceTargetSetting.FaceTarget.OFF);
    private final SwingHandSetting swingHand = new SwingHandSetting(this, SwingHandSetting.SwingHand.CLIENT);
    private final EnumSetting<TakeItemsFrom> takeItemsFrom = new EnumSetting("Take items from", "description.wurst.setting.anchoraura.take_items_from", (Enum[])TakeItemsFrom.values(), (Enum)TakeItemsFrom.INVENTORY);
    private final EntityFilterList entityFilters = AnchorAuraFilterList.create();

    public AnchorAuraHack() {
        super("AnchorAura");
        this.setCategory(Category.COMBAT);
        this.addSetting(this.range);
        this.addSetting(this.autoPlace);
        this.addSetting(this.checkLOS);
        this.addSetting(this.faceTarget);
        this.addSetting(this.swingHand);
        this.addSetting(this.takeItemsFrom);
        this.entityFilters.forEach(x$0 -> this.addSetting((Setting)x$0));
    }

    @Override
    protected void onEnable() {
        EVENTS.add(UpdateListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        if (AnchorAuraHack.MC.field_1687.method_8597().comp_649()) {
            ChatUtils.error("Respawn anchors don't explode in this dimension.");
            this.setEnabled(false);
        }
        ArrayList<class_2338> anchors = this.getNearbyAnchors();
        Map<Boolean, ArrayList> anchorsByCharge = anchors.stream().collect(Collectors.partitioningBy(this::isChargedAnchor, Collectors.toCollection(ArrayList::new)));
        ArrayList chargedAnchors = anchorsByCharge.get(true);
        ArrayList unchargedAnchors = anchorsByCharge.get(false);
        if (!chargedAnchors.isEmpty()) {
            this.detonate(chargedAnchors);
            return;
        }
        int maxInvSlot = this.takeItemsFrom.getSelected().maxInvSlot;
        if (!unchargedAnchors.isEmpty() && InventoryUtils.indexOf(class_1802.field_8801, maxInvSlot) >= 0) {
            this.charge(unchargedAnchors);
            this.detonate(unchargedAnchors);
            return;
        }
        if (!this.autoPlace.isChecked() || InventoryUtils.indexOf(class_1802.field_23141, maxInvSlot) == -1) {
            return;
        }
        ArrayList<class_1297> targets = this.getNearbyTargets();
        ArrayList<class_2338> newAnchors = this.placeAnchorsNear(targets);
        if (!newAnchors.isEmpty() && InventoryUtils.indexOf(class_1802.field_8801, maxInvSlot) >= 0) {
            this.charge(newAnchors);
            this.detonate(newAnchors);
        }
    }

    private ArrayList<class_2338> placeAnchorsNear(ArrayList<class_1297> targets) {
        ArrayList<class_2338> newAnchors = new ArrayList<class_2338>();
        boolean shouldSwing = false;
        block0: for (class_1297 target : targets) {
            ArrayList<class_2338> freeBlocks = this.getFreeBlocksNear(target);
            for (class_2338 pos : freeBlocks) {
                if (!this.placeAnchor(pos)) continue;
                shouldSwing = true;
                newAnchors.add(pos);
                continue block0;
            }
        }
        if (shouldSwing) {
            this.swingHand.swing(class_1268.field_5808);
        }
        return newAnchors;
    }

    private void detonate(ArrayList<class_2338> chargedAnchors) {
        if (this.isSneaking()) {
            return;
        }
        InventoryUtils.selectItem(stack -> !stack.method_31574(class_1802.field_8801), this.takeItemsFrom.getSelected().maxInvSlot);
        if (AnchorAuraHack.MC.field_1724.method_24518(class_1802.field_8801)) {
            return;
        }
        boolean shouldSwing = false;
        for (class_2338 pos : chargedAnchors) {
            if (!this.rightClickBlock(pos)) continue;
            shouldSwing = true;
        }
        if (shouldSwing) {
            this.swingHand.swing(class_1268.field_5808);
        }
    }

    private void charge(ArrayList<class_2338> unchargedAnchors) {
        if (this.isSneaking()) {
            return;
        }
        InventoryUtils.selectItem(class_1802.field_8801, this.takeItemsFrom.getSelected().maxInvSlot);
        if (!AnchorAuraHack.MC.field_1724.method_24518(class_1802.field_8801)) {
            return;
        }
        boolean shouldSwing = false;
        for (class_2338 pos : unchargedAnchors) {
            if (!this.rightClickBlock(pos)) continue;
            shouldSwing = true;
        }
        if (shouldSwing) {
            this.swingHand.swing(class_1268.field_5808);
        }
    }

    private boolean rightClickBlock(class_2338 pos) {
        class_243 eyesPos = RotationUtils.getEyesPos();
        class_243 posVec = class_243.method_24953((class_2382)pos);
        double distanceSqPosVec = eyesPos.method_1025(posVec);
        for (class_2350 side : class_2350.values()) {
            class_243 hitVec = posVec.method_1019(class_243.method_24954((class_2382)side.method_62675()).method_1021(0.5));
            double distanceSqHitVec = eyesPos.method_1025(hitVec);
            if (distanceSqHitVec > 36.0 || distanceSqHitVec >= distanceSqPosVec || this.checkLOS.isChecked() && !BlockUtils.hasLineOfSight(eyesPos, hitVec)) continue;
            this.faceTarget.face(hitVec);
            IMC.getInteractionManager().rightClickBlock(pos, side, hitVec);
            return true;
        }
        return false;
    }

    private boolean placeAnchor(class_2338 pos) {
        class_243 eyesPos = RotationUtils.getEyesPos();
        double rangeSq = this.range.getValueSq();
        class_243 posVec = class_243.method_24953((class_2382)pos);
        double distanceSqPosVec = eyesPos.method_1025(posVec);
        for (class_2350 side : class_2350.values()) {
            class_243 dirVec;
            class_243 hitVec;
            class_2338 neighbor = pos.method_10093(side);
            if (!this.isClickableNeighbor(neighbor) || eyesPos.method_1025(hitVec = posVec.method_1019((dirVec = class_243.method_24954((class_2382)side.method_62675())).method_1021(0.5))) > rangeSq || distanceSqPosVec > eyesPos.method_1025(posVec.method_1019(dirVec)) || this.checkLOS.isChecked() && !BlockUtils.hasLineOfSight(eyesPos, hitVec)) continue;
            InventoryUtils.selectItem(class_1802.field_23141, this.takeItemsFrom.getSelected().maxInvSlot);
            if (!AnchorAuraHack.MC.field_1724.method_24518(class_1802.field_23141)) {
                return false;
            }
            this.faceTarget.face(hitVec);
            IMC.getInteractionManager().rightClickBlock(neighbor, side.method_10153(), hitVec);
            return true;
        }
        return false;
    }

    private ArrayList<class_2338> getNearbyAnchors() {
        class_243 eyesVec = RotationUtils.getEyesPos().method_1023(0.5, 0.5, 0.5);
        class_2338 center = class_2338.method_49638((class_2374)RotationUtils.getEyesPos());
        int rangeI = this.range.getValueCeil();
        double rangeSq = class_3532.method_33723((double)(this.range.getValue() + 0.5));
        Comparator<class_2338> furthestFromPlayer = Comparator.comparingDouble(pos -> eyesVec.method_1025(class_243.method_24954((class_2382)pos))).reversed();
        return BlockUtils.getAllInBoxStream(center, rangeI).filter(pos -> eyesVec.method_1025(class_243.method_24954((class_2382)pos)) <= rangeSq).filter(pos -> BlockUtils.getBlock(pos) == class_2246.field_23152).sorted(furthestFromPlayer).collect(Collectors.toCollection(ArrayList::new));
    }

    private ArrayList<class_1297> getNearbyTargets() {
        double rangeSq = this.range.getValueSq();
        Comparator<class_1297> furthestFromPlayer = Comparator.comparingDouble(e -> AnchorAuraHack.MC.field_1724.method_5858(e)).reversed();
        Stream<class_1297> stream = StreamSupport.stream(AnchorAuraHack.MC.field_1687.method_18112().spliterator(), false).filter(e -> !e.method_31481()).filter(e -> e instanceof class_1309 && ((class_1309)e).method_6032() > 0.0f).filter(e -> e != AnchorAuraHack.MC.field_1724).filter(e -> !(e instanceof FakePlayerEntity)).filter(e -> !WURST.getFriends().contains(e.method_5477().getString())).filter(e -> AnchorAuraHack.MC.field_1724.method_5858(e) <= rangeSq);
        stream = this.entityFilters.applyTo(stream);
        return stream.sorted(furthestFromPlayer).collect(Collectors.toCollection(ArrayList::new));
    }

    private ArrayList<class_2338> getFreeBlocksNear(class_1297 target) {
        class_243 eyesVec = RotationUtils.getEyesPos().method_1023(0.5, 0.5, 0.5);
        double rangeSq = class_3532.method_33723((double)(this.range.getValue() + 0.5));
        class_2338 center = target.method_24515();
        int rangeI = 2;
        class_238 targetBB = target.method_5829();
        class_243 targetEyesVec = target.method_73189().method_1031(0.0, (double)target.method_18381(target.method_18376()), 0.0);
        Comparator<class_2338> closestToTarget = Comparator.comparingDouble(pos -> targetEyesVec.method_1025(class_243.method_24953((class_2382)pos)));
        return BlockUtils.getAllInBoxStream(center, rangeI).filter(pos -> eyesVec.method_1025(class_243.method_24954((class_2382)pos)) <= rangeSq).filter(this::isReplaceable).filter(this::hasClickableNeighbor).filter(pos -> !targetBB.method_994(new class_238(pos))).sorted(closestToTarget).collect(Collectors.toCollection(ArrayList::new));
    }

    private boolean isReplaceable(class_2338 pos) {
        return BlockUtils.getState(pos).method_45474();
    }

    private boolean hasClickableNeighbor(class_2338 pos) {
        return this.isClickableNeighbor(pos.method_10084()) || this.isClickableNeighbor(pos.method_10074()) || this.isClickableNeighbor(pos.method_10095()) || this.isClickableNeighbor(pos.method_10078()) || this.isClickableNeighbor(pos.method_10072()) || this.isClickableNeighbor(pos.method_10067());
    }

    private boolean isClickableNeighbor(class_2338 pos) {
        return BlockUtils.canBeClicked(pos) && !BlockUtils.getState(pos).method_45474();
    }

    private boolean isChargedAnchor(class_2338 pos) {
        return BlockUtils.getState(pos).method_28500((class_2769)class_4969.field_23153).orElse(0) > 0;
    }

    private boolean isSneaking() {
        return AnchorAuraHack.MC.field_1724.method_5715() || AnchorAuraHack.WURST.getHax().sneakHack.isEnabled();
    }

    private static enum TakeItemsFrom {
        HOTBAR("Hotbar", 9),
        INVENTORY("Inventory", 36);

        private final String name;
        private final int maxInvSlot;

        private TakeItemsFrom(String name, int maxInvSlot) {
            this.name = name;
            this.maxInvSlot = maxInvSlot;
        }

        public String toString() {
            return this.name;
        }
    }
}

