/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.util.Comparator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2868;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.AimAssistHack;
import net.wurstclient.hacks.MaceDmgHack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.EntityUtils;

@SearchTags(value={"mace", "auto mace", "fall attack"})
public final class AutoMaceHack
extends Hack
implements UpdateListener {
    private final SliderSetting minFallDistance = new SliderSetting("Min fall distance", "Minimum distance you must fall before AutoMace will react.", 3.0, 1.0, 10.0, 0.5, SliderSetting.ValueDisplay.DECIMAL.withSuffix(" blocks"));
    private final SliderSetting switchDelayMin = new SliderSetting("Switch delay (min)", "Shortest delay before AutoMace can switch to your mace.", 100.0, 0.0, 900.0, 10.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("ms"));
    private final SliderSetting switchDelayMax = new SliderSetting("Switch delay (max)", "Longest delay before AutoMace can switch to your mace.", 200.0, 50.0, 1000.0, 10.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("ms"));
    private final SliderSetting attackDelayMin = new SliderSetting("Attack delay (min)", "Shortest delay before AutoMace can swing the mace.", 80.0, 0.0, 300.0, 10.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("ms"));
    private final SliderSetting attackDelayMax = new SliderSetting("Attack delay (max)", "Longest delay before AutoMace can swing the mace.", 150.0, 50.0, 500.0, 10.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("ms"));
    private final SliderSetting slamDelayMs = new SliderSetting("Slam delay", "Extra time to wait after all conditions are met before swinging.\nHelps time the slam right before landing.", 60.0, 0.0, 200.0, 5.0, SliderSetting.ValueDisplay.INTEGER.withSuffix("ms"));
    private final CheckboxSetting targetPlayers = new CheckboxSetting("Target players", true);
    private final CheckboxSetting targetMobs = new CheckboxSetting("Target mobs", false);
    private final CheckboxSetting autoSwitchBack = new CheckboxSetting("Auto switch back", "Switches back to the previously selected slot afterwards.", true);
    private final CheckboxSetting instantSwitchBack = new CheckboxSetting("Instant switch back", "Switches back immediately if the target is lost mid-air.", true);
    private final CheckboxSetting ignorePassiveMobs = new CheckboxSetting("Ignore passive mobs", true);
    private final CheckboxSetting ignoreInvisible = new CheckboxSetting("Ignore invisible entities", true);
    private final CheckboxSetting respectCooldown = new CheckboxSetting("Respect cooldown", "Only attacks once the mace cooldown is ready.", true);
    private final CheckboxSetting useAimAssist = new CheckboxSetting("Use AimAssist", "Temporarily enables AimAssist while you are falling towards a target.", false);
    private final CheckboxSetting useMaceDmg = new CheckboxSetting("Use MaceDMG", "Enables the MaceDMG hack for guaranteed slam damage. Skips fall distance checks.", false);
    private final CheckboxSetting debugLogs = new CheckboxSetting("Debug logs", "Prints status messages that can help diagnose timing issues.", false);
    private static final Function<class_1297, class_243> TOP_HITBOX_AIM = AutoMaceHack::getTopAimPoint;
    private static final long POST_SWITCH_ATTACK_BUFFER_MS = 75L;
    private int previousSlot = -1;
    private boolean hadMaceEquipped;
    private class_1297 currentTarget;
    private double fallStartY = -1.0;
    private boolean isInAir;
    private boolean hasSwitchedToMace;
    private long lastSwitchMs;
    private long switchDelayMs;
    private long lastAttackMs;
    private long attackDelayMs;
    private boolean aimAssistTemporarilyEnabled;
    private long lastLandingLogMs;
    private boolean landingLogged;
    private boolean attackedThisFall;
    private class_1297 scheduledTarget;
    private long scheduledAttackTime;
    private boolean maceDmgForced;

    public AutoMaceHack() {
        super("AutoMace");
        this.setCategory(Category.COMBAT);
        this.addSetting(this.minFallDistance);
        this.addSetting(this.switchDelayMin);
        this.addSetting(this.switchDelayMax);
        this.addSetting(this.attackDelayMin);
        this.addSetting(this.attackDelayMax);
        this.addSetting(this.slamDelayMs);
        this.addSetting(this.targetPlayers);
        this.addSetting(this.targetMobs);
        this.addSetting(this.autoSwitchBack);
        this.addSetting(this.instantSwitchBack);
        this.addSetting(this.ignorePassiveMobs);
        this.addSetting(this.ignoreInvisible);
        this.addSetting(this.respectCooldown);
        this.addSetting(this.useAimAssist);
        this.addSetting(this.useMaceDmg);
        this.addSetting(this.debugLogs);
    }

    @Override
    protected void onEnable() {
        this.resetState();
        EVENTS.add(UpdateListener.class, this);
        this.updateMaceDmgState();
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        if (this.autoSwitchBack.isChecked() && this.previousSlot != -1 && !this.hadMaceEquipped) {
            this.switchToSlot(this.previousSlot);
        }
        this.updateAimAssist(false, null);
        this.disableForcedMaceDmg();
        this.clearScheduledAttack();
        this.resetState();
    }

    @Override
    public void onUpdate() {
        boolean fallingWindow;
        if (AutoMaceHack.MC.field_1724 == null || AutoMaceHack.MC.field_1687 == null) {
            return;
        }
        this.enforceSliderBounds();
        this.updateFallTracking();
        this.updateCurrentTarget();
        boolean airborne = !AutoMaceHack.MC.field_1724.method_24828();
        class_243 velocity = AutoMaceHack.MC.field_1724.method_18798();
        boolean falling = velocity.field_1351 < -0.1;
        double currentFallDistance = this.getCurrentFallDistance();
        boolean bl = fallingWindow = airborne && falling && currentFallDistance >= this.minFallDistance.getValue();
        if (airborne) {
            this.landingLogged = false;
        }
        boolean hasTarget = this.hasValidTarget(this.currentTarget);
        if (airborne && falling && !this.isMaceEquipped() && !this.hasSwitchedToMace && currentFallDistance >= Math.max(1.0, this.minFallDistance.getValue() * 0.4) && this.canSwitchWeapon()) {
            this.storePreviousSlot();
            this.hasSwitchedToMace = this.switchToMace();
        }
        this.updateAimAssist(fallingWindow && hasTarget, hasTarget ? this.currentTarget : null);
        this.processScheduledAttack(fallingWindow && hasTarget);
        if (fallingWindow) {
            if (hasTarget) {
                this.logDebug("Falling - target acquired: " + this.currentTarget.method_5477().getString());
                this.alignToTargetTop(this.currentTarget);
                if (this.isMaceEquipped()) {
                    this.tryScheduleAttack();
                }
            } else {
                this.handleNoTarget();
            }
        } else if (AutoMaceHack.MC.field_1724.method_24828()) {
            this.handleLanding();
        } else if (airborne && !falling) {
            this.handleNotFalling();
        }
    }

    private void enforceSliderBounds() {
        this.ensureSliderOrdering(this.switchDelayMin, this.switchDelayMax);
        this.ensureSliderOrdering(this.attackDelayMin, this.attackDelayMax);
    }

    private void ensureSliderOrdering(SliderSetting minSetting, SliderSetting maxSetting) {
        double maxValue;
        double minValue = minSetting.getValue();
        if (minValue < (maxValue = maxSetting.getValue())) {
            return;
        }
        double newMax = minValue + maxSetting.getIncrement();
        if (newMax <= maxSetting.getMaximum()) {
            maxSetting.setValue(newMax);
            return;
        }
        double newMin = maxSetting.getValue() - minSetting.getIncrement();
        newMin = Math.max(newMin, minSetting.getMinimum());
        minSetting.setValue(newMin);
    }

    private void updateCurrentTarget() {
        if (this.isTargetCandidate(this.currentTarget)) {
            return;
        }
        class_1297 candidate = null;
        if (AutoMaceHack.MC.field_1765 != null && AutoMaceHack.MC.field_1765.method_17783() == class_239.class_240.field_1331) {
            candidate = ((class_3966)AutoMaceHack.MC.field_1765).method_17782();
        }
        if (!this.isTargetCandidate(candidate) || !this.isFallReachable(candidate)) {
            candidate = this.findBestFallTarget();
        }
        this.currentTarget = this.isTargetCandidate(candidate) && this.isFallReachable(candidate) ? candidate : null;
    }

    private void updateFallTracking() {
        boolean onGround = AutoMaceHack.MC.field_1724.method_24828();
        class_243 velocity = AutoMaceHack.MC.field_1724.method_18798();
        boolean falling = velocity.field_1351 < -0.1;
        double currentY = AutoMaceHack.MC.field_1724.method_23318();
        if (onGround) {
            if (this.isInAir) {
                this.isInAir = false;
                this.fallStartY = -1.0;
                this.attackedThisFall = false;
            }
            return;
        }
        if (!this.isInAir) {
            this.isInAir = true;
            this.fallStartY = currentY;
            this.attackedThisFall = false;
            return;
        }
        if (falling) {
            if (this.fallStartY == -1.0 || currentY > this.fallStartY) {
                this.fallStartY = currentY;
            }
            return;
        }
        if (velocity.field_1351 > 0.1) {
            this.fallStartY = Math.max(this.fallStartY == -1.0 ? currentY : this.fallStartY, currentY);
        }
    }

    private double getCurrentFallDistance() {
        if (!this.isInAir || this.fallStartY == -1.0) {
            return 0.0;
        }
        return Math.max(0.0, this.fallStartY - AutoMaceHack.MC.field_1724.method_23318());
    }

    private boolean hasValidTarget(class_1297 entity) {
        return this.isTargetCandidate(entity);
    }

    private boolean isTargetCandidate(class_1297 entity) {
        class_1309 living;
        if (entity == null || entity == AutoMaceHack.MC.field_1724) {
            return false;
        }
        if (!EntityUtils.IS_ATTACKABLE.test(entity)) {
            return false;
        }
        if (!(entity instanceof class_1309) || (living = (class_1309)entity).method_29504() || !living.method_5805()) {
            return false;
        }
        if (AutoMaceHack.MC.field_1724.method_5722(entity)) {
            return false;
        }
        if (entity instanceof class_1657) {
            if (!this.targetPlayers.isChecked()) {
                return false;
            }
        } else {
            class_1321 tame;
            if (!this.targetMobs.isChecked()) {
                return false;
            }
            if (this.ignorePassiveMobs.isChecked() && entity instanceof class_1296) {
                return false;
            }
            if (entity instanceof class_1321 && (tame = (class_1321)entity).method_6181()) {
                return false;
            }
        }
        return !this.ignoreInvisible.isChecked() || !entity.method_5767();
    }

    private boolean canSwitchWeapon() {
        long now = System.currentTimeMillis();
        return now - this.lastSwitchMs >= this.switchDelayMs;
    }

    private boolean shouldAttack() {
        float minCritFall;
        boolean cheatMode = this.useMaceDmg.isChecked();
        if (this.currentTarget == null) {
            this.logSkip("no target");
            return false;
        }
        if (this.respectCooldown.isChecked() && AutoMaceHack.MC.field_1724.method_7261(0.0f) < 0.75f) {
            this.logSkip("cooldown=" + String.format("%.2f", Float.valueOf(AutoMaceHack.MC.field_1724.method_7261(0.0f))));
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastAttackMs < this.attackDelayMs) {
            this.logSkip("attack delay remaining " + (this.attackDelayMs - (now - this.lastAttackMs)) + "ms");
            return false;
        }
        if (this.hasSwitchedToMace && now - this.lastSwitchMs < 75L) {
            this.logSkip("slot sync buffer " + (now - this.lastSwitchMs) + "ms");
            return false;
        }
        if (!this.isWithinAttackRange(this.currentTarget)) {
            this.logSkip("out of reach");
            return false;
        }
        if (this.attackedThisFall) {
            this.logSkip("already attacked this fall");
            return false;
        }
        if (!cheatMode && AutoMaceHack.MC.field_1724.field_6017 < (double)(minCritFall = (float)class_3532.method_15350((double)(this.minFallDistance.getValue() * (double)0.8f), (double)1.2f, (double)Math.max(2.0, this.minFallDistance.getValue() + (double)0.4f)))) {
            this.logSkip("fall distance " + String.format("%.2f", AutoMaceHack.MC.field_1724.field_6017) + " < min " + String.format("%.2f", Float.valueOf(minCritFall)));
            return false;
        }
        this.lastAttackMs = now;
        this.attackDelayMs = this.nextDelay(this.attackDelayMin.getValue(), this.attackDelayMax.getValue());
        return true;
    }

    private void attackTarget(class_1297 target) {
        if (target == null || AutoMaceHack.MC.field_1761 == null) {
            return;
        }
        this.currentTarget = target;
        AutoMaceHack.MC.field_1761.method_2918((class_1657)AutoMaceHack.MC.field_1724, target);
        AutoMaceHack.MC.field_1724.method_6104(class_1268.field_5808);
        AutoMaceHack.MC.field_1724.method_7350();
        this.attackedThisFall = true;
        double vertical = AutoMaceHack.MC.field_1724.method_23318() - target.method_5829().field_1325;
        this.logDebug("Attacked target " + target.method_5477().getString() + " fallDist=" + String.format("%.2f", AutoMaceHack.MC.field_1724.field_6017) + " vertDiff=" + String.format("%.2f", vertical) + " horDist=" + String.format("%.2f", Math.hypot(AutoMaceHack.MC.field_1724.method_23317() - target.method_23317(), AutoMaceHack.MC.field_1724.method_23321() - target.method_23321())));
    }

    private void tryScheduleAttack() {
        if (this.currentTarget == null || this.scheduledTarget != null) {
            return;
        }
        if (!this.shouldAttack()) {
            return;
        }
        this.scheduleAttack(this.currentTarget);
    }

    private void scheduleAttack(class_1297 target) {
        long delay;
        if (target == null) {
            return;
        }
        long l = delay = this.useMaceDmg.isChecked() ? 0L : Math.max(0L, Math.round(this.slamDelayMs.getValue()));
        if (delay <= 0L) {
            this.attackTarget(target);
            return;
        }
        this.scheduledTarget = target;
        this.scheduledAttackTime = System.currentTimeMillis() + delay;
        this.logDebug("Scheduled attack in " + delay + "ms");
    }

    private void processScheduledAttack(boolean canAttackNow) {
        if (this.scheduledTarget == null) {
            return;
        }
        if (!canAttackNow || !this.hasValidTarget(this.scheduledTarget)) {
            this.logDebug("Cancelled scheduled attack");
            this.clearScheduledAttack();
            return;
        }
        if (System.currentTimeMillis() < this.scheduledAttackTime) {
            return;
        }
        if (!this.useMaceDmg.isChecked() && !this.isWithinAttackRange(this.scheduledTarget)) {
            this.scheduledAttackTime = System.currentTimeMillis() + 10L;
            return;
        }
        this.attackTarget(this.scheduledTarget);
        this.clearScheduledAttack();
    }

    private void handleLanding() {
        this.isInAir = false;
        this.fallStartY = -1.0;
        this.hasSwitchedToMace = false;
        this.updateAimAssist(false, null);
        this.clearScheduledAttack();
        this.attackedThisFall = false;
        if (!this.landingLogged) {
            this.logLandingState("Landing - resetting state");
            this.landingLogged = true;
        }
        if (this.autoSwitchBack.isChecked() && this.previousSlot != -1 && !this.hadMaceEquipped) {
            this.switchToSlot(this.previousSlot);
        }
        this.previousSlot = -1;
        this.currentTarget = null;
    }

    private void handleNoTarget() {
        this.updateAimAssist(false, null);
        this.clearScheduledAttack();
        if (!this.autoSwitchBack.isChecked() || !this.instantSwitchBack.isChecked()) {
            return;
        }
        if (this.previousSlot == -1 || this.hadMaceEquipped || !this.isMaceEquipped()) {
            return;
        }
        this.switchToSlot(this.previousSlot);
        this.previousSlot = -1;
        this.hasSwitchedToMace = false;
        this.logDebug("Lost target - switching back to slot " + this.slotDescription(this.previousSlot));
    }

    private void handleNotFalling() {
        this.updateAimAssist(false, null);
        this.handleNoTarget();
    }

    private boolean isMaceEquipped() {
        class_1799 mainHand = AutoMaceHack.MC.field_1724.method_6047();
        return mainHand.method_31574(class_1802.field_49814);
    }

    private void storePreviousSlot() {
        if (this.isMaceEquipped()) {
            this.hadMaceEquipped = true;
            return;
        }
        if (this.previousSlot == -1) {
            this.previousSlot = AutoMaceHack.MC.field_1724.method_31548().method_67532();
            this.hadMaceEquipped = false;
        }
    }

    private boolean switchToMace() {
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = AutoMaceHack.MC.field_1724.method_31548().method_5438(i);
            if (!stack.method_31574(class_1802.field_49814)) continue;
            this.setSelectedHotbarSlot(i);
            this.hasSwitchedToMace = true;
            this.lastSwitchMs = System.currentTimeMillis();
            this.switchDelayMs = this.nextDelay(this.switchDelayMin.getValue(), this.switchDelayMax.getValue());
            this.logDebug("Switched to mace slot " + i);
            return true;
        }
        return false;
    }

    private void switchToSlot(int slot) {
        if (slot < 0 || slot >= 9) {
            return;
        }
        this.setSelectedHotbarSlot(slot);
    }

    private void setSelectedHotbarSlot(int slot) {
        if (AutoMaceHack.MC.field_1724 == null || AutoMaceHack.MC.field_1724.method_31548().method_67532() == slot) {
            return;
        }
        AutoMaceHack.MC.field_1724.method_31548().method_61496(slot);
        if (AutoMaceHack.MC.field_1724.field_3944 != null) {
            AutoMaceHack.MC.field_1724.field_3944.method_52787((class_2596)new class_2868(slot));
        }
    }

    private void alignToTargetTop(class_1297 target) {
        if (!this.useAimAssist.isChecked() || target == null) {
            return;
        }
        class_243 topCenter = AutoMaceHack.getTopAimPoint(target);
        WURST.getRotationFaker().faceVectorClient(topCenter);
        WURST.getRotationFaker().faceVectorPacket(topCenter);
    }

    private boolean isWithinAttackRange(class_1297 entity) {
        double maxHorizontal;
        if (entity == null) {
            return false;
        }
        class_238 playerBox = AutoMaceHack.MC.field_1724.method_5829();
        class_238 targetBox = entity.method_5829();
        double playerFeet = playerBox.field_1322;
        double playerTop = playerBox.field_1325;
        double targetTop = targetBox.field_1325;
        double targetBottom = targetBox.field_1322;
        if (playerFeet > targetTop + 0.25) {
            return false;
        }
        if (playerTop < targetBottom - 0.2) {
            return false;
        }
        double playerCenterX = (playerBox.field_1323 + playerBox.field_1320) * 0.5;
        double targetCenterX = (targetBox.field_1323 + targetBox.field_1320) * 0.5;
        double playerCenterZ = (playerBox.field_1321 + playerBox.field_1324) * 0.5;
        double targetCenterZ = (targetBox.field_1321 + targetBox.field_1324) * 0.5;
        double horizontal = Math.hypot(playerCenterX - targetCenterX, playerCenterZ - targetCenterZ);
        if (horizontal > (maxHorizontal = Math.max(1.4, 0.9 + (double)entity.method_17681() * 0.6))) {
            this.logSkip(String.format("horizontal %.2f > %.2f", horizontal, maxHorizontal));
            return false;
        }
        double downwardSpeed = AutoMaceHack.MC.field_1724.method_18798().field_1351;
        if (downwardSpeed > -0.35) {
            this.logSkip(String.format("velocity %.3f too slow", downwardSpeed));
            return false;
        }
        if (playerFeet - targetTop > 0.35) {
            this.logSkip(String.format("feet above target by %.2f", playerFeet - targetTop));
            return false;
        }
        return true;
    }

    private boolean isFallReachable(class_1297 entity) {
        if (entity == null) {
            return false;
        }
        class_243 playerPos = new class_243(AutoMaceHack.MC.field_1724.method_23317(), AutoMaceHack.MC.field_1724.method_23318(), AutoMaceHack.MC.field_1724.method_23321());
        class_243 top = AutoMaceHack.getTopAimPoint(entity);
        if (top.field_1351 >= playerPos.field_1351) {
            return false;
        }
        double horizontal = Math.hypot(playerPos.field_1352 - top.field_1352, playerPos.field_1350 - top.field_1350);
        double vertical = playerPos.field_1351 - top.field_1351;
        if (vertical < 0.2 || vertical > 3.5) {
            return false;
        }
        double maxHorizontal = Math.min(2.5, vertical + 1.1);
        return horizontal <= maxHorizontal;
    }

    private class_1297 findBestFallTarget() {
        class_243 playerPos = new class_243(AutoMaceHack.MC.field_1724.method_23317(), AutoMaceHack.MC.field_1724.method_23318(), AutoMaceHack.MC.field_1724.method_23321());
        double maxDistanceSq = 36.0;
        double maxHorizontal = 5.5;
        return EntityUtils.getAttackableEntities().filter(this::isTargetCandidate).filter(e -> AutoMaceHack.MC.field_1724.method_5858(e) <= maxDistanceSq).filter(e -> AutoMaceHack.getTopAimPoint((class_1297)e).field_1351 < playerPos.field_1351).filter(this::isFallReachable).filter(e -> {
            class_243 top = AutoMaceHack.getTopAimPoint(e);
            double dx = top.field_1352 - playerPos.field_1352;
            double dz = top.field_1350 - playerPos.field_1350;
            double horizontal = Math.hypot(dx, dz);
            return horizontal <= maxHorizontal;
        }).min(Comparator.comparingDouble(e -> {
            class_243 top = AutoMaceHack.getTopAimPoint(e);
            double verticalDiff = Math.max(0.0, playerPos.field_1351 - top.field_1351 - 0.05);
            double dx = top.field_1352 - playerPos.field_1352;
            double dz = top.field_1350 - playerPos.field_1350;
            double horizontal = Math.hypot(dx, dz);
            return verticalDiff * verticalDiff + horizontal;
        })).orElse(null);
    }

    private static class_243 getTopAimPoint(class_1297 entity) {
        class_238 box = entity.method_5829();
        double x = (box.field_1323 + box.field_1320) * 0.5;
        double y = box.field_1325 + 0.05;
        double z = (box.field_1321 + box.field_1324) * 0.5;
        return new class_243(x, y, z);
    }

    private long nextDelay(double min, double max) {
        double minVal = Math.min(min, max);
        double maxVal = Math.max(min, max);
        if (maxVal <= minVal) {
            maxVal = minVal + 1.0;
        }
        return Math.round(ThreadLocalRandom.current().nextDouble(minVal, maxVal + 1.0));
    }

    private void resetState() {
        AimAssistHack aimAssist = AutoMaceHack.WURST.getHax().aimAssistHack;
        aimAssist.setOverrideAimPoint(null);
        aimAssist.clearExternalTarget();
        this.previousSlot = -1;
        this.hadMaceEquipped = false;
        this.currentTarget = null;
        this.fallStartY = -1.0;
        this.isInAir = false;
        this.hasSwitchedToMace = false;
        this.lastSwitchMs = 0L;
        this.switchDelayMs = 0L;
        this.lastAttackMs = 0L;
        this.attackDelayMs = 0L;
        this.aimAssistTemporarilyEnabled = false;
        this.lastLandingLogMs = 0L;
        this.landingLogged = false;
        this.attackedThisFall = false;
        this.clearScheduledAttack();
        this.maceDmgForced = false;
    }

    private void updateAimAssist(boolean shouldEnable, class_1297 target) {
        if (!this.useAimAssist.isChecked()) {
            shouldEnable = false;
        }
        AimAssistHack aimAssist = AutoMaceHack.WURST.getHax().aimAssistHack;
        if (shouldEnable && target != null) {
            aimAssist.setOverrideAimPoint(TOP_HITBOX_AIM);
            aimAssist.setExternalTarget(target);
            if (!aimAssist.isEnabled()) {
                aimAssist.setEnabled(true);
                this.aimAssistTemporarilyEnabled = true;
            }
            return;
        }
        aimAssist.setOverrideAimPoint(null);
        aimAssist.clearExternalTarget();
        if (this.aimAssistTemporarilyEnabled && aimAssist.isEnabled()) {
            aimAssist.setEnabled(false);
        }
        this.aimAssistTemporarilyEnabled = false;
    }

    private void logDebug(String message) {
        if (!this.debugLogs.isChecked()) {
            return;
        }
        ChatUtils.message("[AutoMace] " + message);
    }

    private void logDebugState(String message) {
        if (!this.debugLogs.isChecked()) {
            return;
        }
        CombinedFormatter formatter = new CombinedFormatter();
        formatter.add(message, new Object[0]);
        formatter.add("fallDist=%.2f", AutoMaceHack.MC.field_1724.field_6017);
        formatter.add("velY=%.3f", AutoMaceHack.MC.field_1724.method_18798().field_1351);
        formatter.add("hasMace=%s", this.isMaceEquipped());
        formatter.add("target=%s", this.currentTarget == null ? "none" : this.currentTarget.method_5477().getString());
        ChatUtils.message("[AutoMace] " + formatter.toString());
    }

    private void logLandingState(String message) {
        if (!this.debugLogs.isChecked()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastLandingLogMs < 200L) {
            return;
        }
        this.lastLandingLogMs = now;
        this.logDebugState(message);
    }

    private String slotDescription(int slot) {
        return slot < 0 ? "none" : Integer.toString(slot);
    }

    private void logSkip(String message) {
        if (!this.debugLogs.isChecked()) {
            return;
        }
        ChatUtils.message("[AutoMace] Skip attack: " + message);
    }

    private void clearScheduledAttack() {
        this.scheduledTarget = null;
        this.scheduledAttackTime = -1L;
    }

    private void updateMaceDmgState() {
        if (!this.useMaceDmg.isChecked()) {
            this.disableForcedMaceDmg();
            return;
        }
        MaceDmgHack maceDmg = AutoMaceHack.WURST.getHax().maceDmgHack;
        if (maceDmg != null && !maceDmg.isEnabled()) {
            maceDmg.setEnabled(true);
            this.maceDmgForced = true;
        }
    }

    private void disableForcedMaceDmg() {
        if (!this.maceDmgForced) {
            return;
        }
        MaceDmgHack maceDmg = AutoMaceHack.WURST.getHax().maceDmgHack;
        if (maceDmg != null && maceDmg.isEnabled()) {
            maceDmg.setEnabled(false);
        }
        this.maceDmgForced = false;
    }

    private static final class CombinedFormatter {
        private final StringBuilder builder = new StringBuilder();
        private boolean first = true;

        private CombinedFormatter() {
        }

        private void add(String format, Object ... args) {
            if (!this.first) {
                this.builder.append(" | ");
            }
            this.first = false;
            this.builder.append(String.format(format, args));
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

