/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1439;
import net.minecraft.class_1646;
import net.minecraft.class_1923;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8961;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.CameraTransformViewBobbingListener;
import net.wurstclient.events.PacketInputListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hacks.bedesp.BedEspBlockGroup;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ChunkAreaSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EspStyleSetting;
import net.wurstclient.settings.Setting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.BlockUtils;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.util.chunk.ChunkSearcher;
import net.wurstclient.util.chunk.ChunkSearcherCoordinator;
import net.wurstclient.util.chunk.ChunkUtils;

@SearchTags(value={"BedESP", "bed esp"})
public final class BedEspHack
extends Hack
implements UpdateListener,
CameraTransformViewBobbingListener,
RenderListener {
    private final EspStyleSetting style = new EspStyleSetting();
    private final CheckboxSetting stickyArea = new CheckboxSetting("Sticky area", "Off: Re-centers every chunk to match ESP drop-off.\nOn: Keeps results anchored so you can path back to them.", false);
    private final BedEspBlockGroup beds = new BedEspBlockGroup(new ColorSetting("Bed color", "Beds will be highlighted in this color.", new Color(16738740)));
    private final List<BedEspBlockGroup> groups = Arrays.asList(this.beds);
    private final CheckboxSetting showCountInHackList = new CheckboxSetting("HackList count", "Appends the number of found beds to this hack's entry in the HackList.", false);
    private final ChunkAreaSetting area = new ChunkAreaSetting("Area", "The area around the player to search in.\nHigher values require a faster computer.");
    private final CheckboxSetting onlyAboveGround = new CheckboxSetting("Above ground only", "Only show beds at or above the configured Y level.", false);
    private final SliderSetting aboveGroundY = new SliderSetting("Set ESP Y limit", 62.0, -65.0, 255.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting filterTrialChambers = new CheckboxSetting("Filter trial chambers", "Hides beds that match common trial chamber layouts.", false);
    private final CheckboxSetting filterVillageBeds = new CheckboxSetting("Filter village beds", "Hides beds that appear to belong to villages.", false);
    private final BiPredicate<class_2338, class_2680> query = (pos, state) -> state.method_26204() instanceof class_2244;
    private final ChunkSearcherCoordinator coordinator = new ChunkSearcherCoordinator(this.query, this.area);
    private boolean groupsUpToDate;
    private class_1923 lastPlayerChunk;
    private int foundCount;
    private int lastMatchesVersion;
    private List<class_2338> cachedTrialSpawners = List.of();
    private List<class_243> cachedVillagerPositions = List.of();
    private List<class_243> cachedGolemPositions = List.of();
    private static final class_6862<class_2248> WAXED_COPPER_BLOCKS_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"minecraft", (String)"waxed_copper_blocks"));
    private boolean lastTrialFilterState;
    private boolean lastVillageFilterState;

    public BedEspHack() {
        super("BedESP");
        this.setCategory(Category.RENDER);
        this.addSetting(this.style);
        this.groups.stream().flatMap(BedEspBlockGroup::getSettings).forEach(x$0 -> this.addSetting((Setting)x$0));
        this.addSetting(this.showCountInHackList);
        this.addSetting(this.area);
        this.addSetting(this.stickyArea);
        this.addSetting(this.onlyAboveGround);
        this.addSetting(this.aboveGroundY);
        this.addSetting(this.filterTrialChambers);
        this.addSetting(this.filterVillageBeds);
        this.lastTrialFilterState = this.filterTrialChambers.isChecked();
        this.lastVillageFilterState = this.filterVillageBeds.isChecked();
    }

    @Override
    protected void onEnable() {
        this.groupsUpToDate = false;
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(PacketInputListener.class, this.coordinator);
        EVENTS.add(CameraTransformViewBobbingListener.class, this);
        EVENTS.add(RenderListener.class, this);
        this.lastPlayerChunk = new class_1923(BedEspHack.MC.field_1724.method_24515());
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        this.lastTrialFilterState = this.filterTrialChambers.isChecked();
        this.lastVillageFilterState = this.filterVillageBeds.isChecked();
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(PacketInputListener.class, this.coordinator);
        EVENTS.remove(CameraTransformViewBobbingListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.coordinator.reset();
        this.lastMatchesVersion = this.coordinator.getMatchesVersion();
        this.groups.forEach(BedEspBlockGroup::clear);
        this.foundCount = 0;
        this.cachedTrialSpawners = List.of();
        this.cachedVillagerPositions = List.of();
        this.cachedGolemPositions = List.of();
    }

    @Override
    public void onUpdate() {
        int matchesVersion;
        boolean searchersChanged = this.coordinator.update();
        if (searchersChanged) {
            this.groupsUpToDate = false;
        }
        if ((matchesVersion = this.coordinator.getMatchesVersion()) != this.lastMatchesVersion) {
            this.lastMatchesVersion = matchesVersion;
            this.groupsUpToDate = false;
        }
        class_1923 currentChunk = new class_1923(BedEspHack.MC.field_1724.method_24515());
        if (!this.stickyArea.isChecked() && !currentChunk.equals((Object)this.lastPlayerChunk)) {
            this.lastPlayerChunk = currentChunk;
            this.coordinator.reset();
            this.groupsUpToDate = false;
        }
        if (this.didFiltersChange()) {
            this.groupsUpToDate = false;
        }
        if (!this.groupsUpToDate && this.coordinator.isDone()) {
            this.updateGroupBoxes();
        }
    }

    @Override
    public void onCameraTransformViewBobbing(CameraTransformViewBobbingListener.CameraTransformViewBobbingEvent event) {
        if (this.style.hasLines()) {
            event.cancel();
        }
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        if (this.style.hasBoxes()) {
            this.renderBoxes(matrixStack);
        }
        if (this.style.hasLines()) {
            this.renderTracers(matrixStack, partialTicks);
        }
    }

    private void renderBoxes(class_4587 matrixStack) {
        for (BedEspBlockGroup group : this.groups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            int quadsColor = group.getColorI(64);
            int linesColor = group.getColorI(128);
            RenderUtils.drawSolidBoxes(matrixStack, boxes, quadsColor, false);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, linesColor, false);
        }
    }

    private void renderTracers(class_4587 matrixStack, float partialTicks) {
        for (BedEspBlockGroup group : this.groups) {
            if (!group.isEnabled()) continue;
            List<class_238> boxes = group.getBoxes();
            List<class_243> ends = boxes.stream().map(class_238::method_1005).toList();
            int color = group.getColorI(128);
            RenderUtils.drawTracers(matrixStack, partialTicks, ends, color, false);
        }
    }

    private void updateGroupBoxes() {
        this.groups.forEach(BedEspBlockGroup::clear);
        List<ChunkSearcher.Result> results = this.coordinator.getMatches().toList();
        this.refreshEnvironmentalCaches();
        results.forEach(this::addToGroupBoxes);
        this.groupsUpToDate = true;
        int total = this.groups.stream().mapToInt(g -> g.getBoxes().size()).sum();
        this.foundCount = Math.min(total, 999);
    }

    @Override
    public String getRenderName() {
        String base = this.getName();
        if (this.showCountInHackList.isChecked() && this.foundCount > 0) {
            return base + " [" + this.foundCount + "]";
        }
        return base;
    }

    private void addToGroupBoxes(ChunkSearcher.Result result) {
        block4: {
            class_2680 state = result.state();
            if (!(state.method_26204() instanceof class_2244) || state.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12557) {
                return;
            }
            class_2338 headPos = result.pos();
            if (this.onlyAboveGround.isChecked() && (double)headPos.method_10264() < this.aboveGroundY.getValue()) {
                return;
            }
            if (this.filterTrialChambers.isChecked() && this.isTrialChamberBed(headPos)) {
                return;
            }
            if (this.filterVillageBeds.isChecked() && this.isLikelyVillageBed(headPos)) {
                return;
            }
            Iterator<BedEspBlockGroup> iterator = this.groups.iterator();
            if (!iterator.hasNext()) break block4;
            BedEspBlockGroup group = iterator.next();
            group.add(result);
        }
    }

    private void refreshEnvironmentalCaches() {
        this.cachedTrialSpawners = this.filterTrialChambers.isChecked() ? this.collectTrialSpawnerPositions() : List.of();
        if (this.filterVillageBeds.isChecked()) {
            this.cachedVillagerPositions = this.collectEntityPositions(class_1646.class);
            this.cachedGolemPositions = this.collectEntityPositions(class_1439.class);
        } else {
            this.cachedVillagerPositions = List.of();
            this.cachedGolemPositions = List.of();
        }
    }

    private boolean didFiltersChange() {
        boolean trial = this.filterTrialChambers.isChecked();
        boolean village = this.filterVillageBeds.isChecked();
        if (trial != this.lastTrialFilterState || village != this.lastVillageFilterState) {
            this.lastTrialFilterState = trial;
            this.lastVillageFilterState = village;
            return true;
        }
        return false;
    }

    private List<class_2338> collectTrialSpawnerPositions() {
        if (BedEspHack.MC.field_1687 == null) {
            return List.of();
        }
        return ChunkUtils.getLoadedBlockEntities().filter(be -> be instanceof class_8961).map(class_2586::method_11016).map(class_2338::method_10062).collect(Collectors.toList());
    }

    private <T extends class_1297> List<class_243> collectEntityPositions(Class<T> type) {
        if (BedEspHack.MC.field_1687 == null) {
            return List.of();
        }
        return StreamSupport.stream(BedEspHack.MC.field_1687.method_18112().spliterator(), false).filter(e -> !e.method_31481()).filter(type::isInstance).map(entity -> class_243.method_24953((class_2382)entity.method_24515())).collect(Collectors.toList());
    }

    private boolean isTrialChamberBed(class_2338 headPos) {
        int y = headPos.method_10264();
        if (y < -38 || y > 10) {
            return false;
        }
        if (!this.isNearWaxedCopper(headPos, 5)) {
            return false;
        }
        return this.isNearTrialSpawner(headPos, 100);
    }

    private boolean isNearWaxedCopper(class_2338 center, int range) {
        if (BedEspHack.MC.field_1687 == null) {
            return false;
        }
        return BlockUtils.getAllInBoxStream(center, range).anyMatch(pos -> this.isWaxedCopper(BlockUtils.getState(pos)));
    }

    private boolean isWaxedCopper(class_2680 state) {
        if (state.method_26164(WAXED_COPPER_BLOCKS_TAG)) {
            return true;
        }
        String idPath = class_7923.field_41175.method_10221((Object)state.method_26204()).method_12832();
        return idPath.contains("waxed") && idPath.contains("copper");
    }

    private boolean isNearTrialSpawner(class_2338 center, int range) {
        if (this.cachedTrialSpawners.isEmpty()) {
            return false;
        }
        double rangeSq = range * range;
        class_243 centerVec = class_243.method_24953((class_2382)center);
        return this.cachedTrialSpawners.stream().anyMatch(pos -> class_243.method_24953((class_2382)pos).method_1025(centerVec) <= rangeSq);
    }

    private boolean isLikelyVillageBed(class_2338 headPos) {
        if (!this.hasDoorNearby(headPos, 4)) {
            return false;
        }
        boolean hasVillageEntity = this.isEntityWithinRange(this.cachedVillagerPositions, headPos, 24.0) || this.isEntityWithinRange(this.cachedGolemPositions, headPos, 24.0);
        boolean hayCluster = this.hasHayBaleCluster(headPos, 6);
        if (hasVillageEntity || hayCluster) {
            return true;
        }
        return this.hasGlassPaneCluster(headPos, 4, 1);
    }

    private boolean isEntityWithinRange(List<class_243> positions, class_2338 center, double range) {
        if (positions.isEmpty()) {
            return false;
        }
        double rangeSq = range * range;
        class_243 centerVec = class_243.method_24953((class_2382)center);
        return positions.stream().anyMatch(pos -> pos.method_1025(centerVec) <= rangeSq);
    }

    private boolean hasHayBaleCluster(class_2338 center, int range) {
        if (BedEspHack.MC.field_1687 == null) {
            return false;
        }
        long count = BlockUtils.getAllInBoxStream(center, range).filter(pos -> BlockUtils.getBlock(pos) == class_2246.field_10359).limit(16L).count();
        return count >= 4L;
    }

    private boolean hasDoorNearby(class_2338 center, int range) {
        if (BedEspHack.MC.field_1687 == null) {
            return false;
        }
        return BlockUtils.getAllInBoxStream(center, range).anyMatch(pos -> BlockUtils.getBlock(pos) instanceof class_2323);
    }

    private boolean hasGlassPaneCluster(class_2338 center, int range, int requiredCount) {
        if (BedEspHack.MC.field_1687 == null) {
            return false;
        }
        long glassCount = BlockUtils.getAllInBoxStream(center, range).filter(pos -> this.isGlassPane(BlockUtils.getBlock(pos))).limit(requiredCount).count();
        return glassCount >= (long)requiredCount;
    }

    private boolean isGlassPane(class_2248 block) {
        String path = class_7923.field_41175.method_10221((Object)block).method_12832();
        return path.contains("glass_pane");
    }
}

