/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.util.PlayerColorRegistry;
import net.wurstclient.util.RenderUtils;

@SearchTags(value={"breadcrumbs", "trail"})
public final class BreadcrumbsHack
extends Hack
implements UpdateListener,
RenderListener {
    private static final int MAX_SECTIONS_INFINITE = 10050;
    private final ColorSetting color = new ColorSetting("Color", "Trail color.", new Color(255, 64, 64));
    private final EnumSetting<Target> target = new EnumSetting("Target", (Enum[])Target.values(), (Enum)Target.YOU);
    private final ColorSetting otherColor = new ColorSetting("Other color", "Color for other players' trails. Note: PlayerESP overrides Breadcrumbs'\ncolors; if PlayerESP is using a static or unique color for a player,\nBreadcrumbs will show that color instead.", new Color(64, 160, 255));
    private final CheckboxSetting keepOthersOnLeave = new CheckboxSetting("Keep trails when out of view/logout", false);
    private final CheckboxSetting randomBrightColors = new CheckboxSetting("Unique colors for others", "Assign bright deterministic colors per-player so other hacks\n(for example PlayerESP) can share the same color. If you turn\nthis off, Breadcrumbs will remove colors it owns from the\nshared registry so other features may take over.", false);
    private static final int[] SECTIONS_MAP = BreadcrumbsHack.buildSectionsMap();
    private final SliderSetting maxSections = new SliderSetting("Max sections", BreadcrumbsHack.findIndexFor(1000), 0.0, SECTIONS_MAP.length - 1, 1.0, new SliderSetting.ValueDisplay(){

        @Override
        public String getValueString(double v) {
            int idx = (int)v;
            int mapped = BreadcrumbsHack.this.computeMaxSections(idx);
            return mapped >= 10050 ? "Infinite" : Integer.toString(mapped);
        }
    });
    private final SliderSetting sectionLen = new SliderSetting("Section length", 0.5, 0.1, 5.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting lineThickness = new SliderSetting("Line thickness", 2.0, 1.0, 10.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting paused = new CheckboxSetting("Paused", false);
    private final Deque<Point> points = new ArrayDeque<Point>();
    private final Map<UUID, Deque<Point>> otherPoints = new HashMap<UUID, Deque<Point>>();
    private Target prevTarget = null;
    private boolean prevRandom = false;

    private boolean movedEnough(class_243 a, class_243 b, double minDist) {
        double dx = a.field_1352 - b.field_1352;
        double dy = a.field_1351 - b.field_1351;
        double dz = a.field_1350 - b.field_1350;
        double sq = dx * dx + dy * dy + dz * dz;
        return sq >= minDist * minDist;
    }

    private static int[] buildSectionsMap() {
        int v;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i <= 100; ++i) {
            list.add(i);
        }
        for (v = 200; v <= 1000; v += 100) {
            list.add(v);
        }
        for (v = 1200; v <= 5000; v += 200) {
            list.add(v);
        }
        for (v = 6000; v <= 9000; v += 1000) {
            list.add(v);
        }
        list.add(9999);
        list.add(10050);
        int[] arr = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (Integer)list.get(i);
        }
        return arr;
    }

    private static int findIndexFor(int value) {
        for (int i = 0; i < SECTIONS_MAP.length; ++i) {
            if (SECTIONS_MAP[i] != value) continue;
            return i;
        }
        return 0;
    }

    public BreadcrumbsHack() {
        super("Breadcrumbs");
        this.setCategory(Category.RENDER);
        this.addSetting(this.color);
        this.addSetting(this.target);
        this.addSetting(this.otherColor);
        this.addSetting(this.randomBrightColors);
        this.addSetting(this.keepOthersOnLeave);
        this.addSetting(this.maxSections);
        this.addSetting(this.sectionLen);
        this.addSetting(this.lineThickness);
        this.addSetting(this.paused);
    }

    @Override
    public String getRenderName() {
        return this.paused.isChecked() ? this.getName() + " [Paused]" : this.getName();
    }

    @Override
    protected void onEnable() {
        this.points.clear();
        this.otherPoints.clear();
        this.prevTarget = this.target.getSelected();
        this.prevRandom = this.randomBrightColors.isChecked();
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(RenderListener.class, this);
    }

    @Override
    protected void onDisable() {
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(RenderListener.class, this);
        this.points.clear();
        this.otherPoints.clear();
    }

    @Override
    public void onUpdate() {
        if (BreadcrumbsHack.MC.field_1724 == null) {
            return;
        }
        Target sel = this.target.getSelected();
        if (this.prevTarget == null) {
            this.prevTarget = sel;
        }
        if (sel != this.prevTarget) {
            if (sel == Target.YOU) {
                this.otherPoints.clear();
            }
            if (sel == Target.OTHERS) {
                this.points.clear();
            }
            if (sel == Target.BOTH) {
                this.otherPoints.clear();
            }
            this.prevTarget = sel;
        }
        if (this.paused.isChecked()) {
            return;
        }
        class_243 herePos = new class_243(BreadcrumbsHack.MC.field_1724.method_23317(), BreadcrumbsHack.MC.field_1724.method_23318(), BreadcrumbsHack.MC.field_1724.method_23321());
        class_2874 hereDim = BreadcrumbsHack.MC.field_1687.method_8597();
        if (this.points.isEmpty()) {
            this.points.add(new Point(herePos, hereDim));
            return;
        }
        class_243 last = this.points.peekLast().pos;
        if (this.movedEnough(last, herePos, this.sectionLen.getValue())) {
            boolean infinite;
            this.points.add(new Point(herePos, hereDim));
            int limit = this.computeMaxSections(this.maxSections.getValueI());
            boolean bl = infinite = limit >= 10050;
            while (!infinite && this.points.size() > limit) {
                this.points.pollFirst();
            }
        }
        if (sel == Target.OTHERS || sel == Target.BOTH) {
            for (class_742 p : BreadcrumbsHack.MC.field_1687.method_18456()) {
                boolean infinite;
                Color assigned;
                if (p == BreadcrumbsHack.MC.field_1724) continue;
                UUID id = p.method_5667();
                if (this.randomBrightColors.isChecked() && (assigned = PlayerColorRegistry.get(id)) == null) {
                    PlayerColorRegistry.assignDeterministic(id, "Breadcrumbs");
                }
                Deque dq = this.otherPoints.computeIfAbsent(id, k -> new ArrayDeque());
                class_243 pos = new class_243(p.method_23317(), p.method_23318(), p.method_23321());
                class_2874 pdim = BreadcrumbsHack.MC.field_1687.method_8597();
                if (dq.isEmpty()) {
                    dq.add(new Point(pos, pdim));
                    continue;
                }
                class_243 lastp = ((Point)dq.peekLast()).pos;
                if (!this.movedEnough(lastp, pos, this.sectionLen.getValue())) continue;
                dq.add(new Point(pos, pdim));
                int limit = this.computeMaxSections(this.maxSections.getValueI());
                boolean bl = infinite = limit >= 10050;
                while (!infinite && dq.size() > limit) {
                    dq.pollFirst();
                }
            }
            if (!this.keepOthersOnLeave.isChecked()) {
                this.otherPoints.keySet().removeIf(uuid -> BreadcrumbsHack.MC.field_1687.method_18470(uuid) == null);
                this.otherPoints.keySet().forEach(uuid -> {
                    if (BreadcrumbsHack.MC.field_1687.method_18470(uuid) == null) {
                        PlayerColorRegistry.remove(uuid);
                    }
                });
            }
        }
        boolean curRandom = this.randomBrightColors.isChecked();
        if (this.prevRandom && !curRandom) {
            PlayerColorRegistry.removeByOwner("Breadcrumbs");
        }
        this.prevRandom = curRandom;
    }

    private int computeMaxSections(int sliderIndex) {
        if (sliderIndex < 0) {
            return SECTIONS_MAP[0];
        }
        if (sliderIndex >= SECTIONS_MAP.length) {
            return SECTIONS_MAP[SECTIONS_MAP.length - 1];
        }
        return SECTIONS_MAP[sliderIndex];
    }

    @Override
    public void onRender(class_4587 matrixStack, float partialTicks) {
        class_2874 curDim;
        double thickness = this.lineThickness.getValue();
        Target sel = this.target.getSelected();
        if (sel == Target.YOU || sel == Target.BOTH) {
            curDim = BreadcrumbsHack.MC.field_1687.method_8597();
            ArrayList<class_243> list = new ArrayList<class_243>();
            for (Point p : this.points) {
                if (p.dim != curDim) continue;
                list.add(p.pos);
            }
            if (list.size() >= 2) {
                int c = RenderUtils.toIntColor(new float[]{this.color.getColorF()[0], this.color.getColorF()[1], this.color.getColorF()[2]}, 0.8f);
                RenderUtils.drawCurvedLine(matrixStack, list, c, false, thickness);
            }
        }
        if (sel == Target.OTHERS || sel == Target.BOTH) {
            curDim = BreadcrumbsHack.MC.field_1687.method_8597();
            for (Map.Entry<UUID, Deque<Point>> entry : this.otherPoints.entrySet()) {
                int oc;
                Deque<Point> dq = entry.getValue();
                UUID id = entry.getKey();
                ArrayList<class_243> l = new ArrayList<class_243>();
                for (Point p : dq) {
                    if (p.dim != curDim) continue;
                    l.add(p.pos);
                }
                if (l.size() < 2) continue;
                if (this.randomBrightColors.isChecked()) {
                    Color col = PlayerColorRegistry.get(id);
                    if (col == null) {
                        col = this.otherColor.getColor();
                    }
                    oc = RenderUtils.toIntColor(new float[]{(float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f}, 0.9f);
                } else {
                    oc = RenderUtils.toIntColor(new float[]{this.otherColor.getColorF()[0], this.otherColor.getColorF()[1], this.otherColor.getColorF()[2]}, 0.8f);
                }
                RenderUtils.drawCurvedLine(matrixStack, l, oc, false, thickness);
            }
        }
    }

    private Color generateBrightColor(int index) {
        Color[] base = new Color[]{new Color(255, 64, 64), new Color(64, 255, 64), new Color(64, 64, 255), new Color(255, 196, 64), new Color(196, 64, 255), new Color(64, 255, 196), new Color(255, 64, 196), new Color(196, 255, 64), new Color(64, 196, 255)};
        int baseCount = base.length;
        int b = index % baseCount;
        int round = index / baseCount;
        float factor = 1.0f - Math.min(0.5f, (float)round * 0.15f);
        Color bc = base[b];
        int r = Math.min(255, Math.max(0, (int)((float)bc.getRed() * factor)));
        int g = Math.min(255, Math.max(0, (int)((float)bc.getGreen() * factor)));
        int bl = Math.min(255, Math.max(0, (int)((float)bc.getBlue() * factor)));
        return new Color(r, g, bl);
    }

    private static enum Target {
        YOU,
        OTHERS,
        BOTH;

    }

    private static final class Point {
        final class_243 pos;
        final class_2874 dim;

        Point(class_243 pos, class_2874 dim) {
            this.pos = pos;
            this.dim = dim;
        }
    }
}

